/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ducks.IEMatrix4f;
import com.qouteall.immersive_portals.my_util.DQuaternion;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TransformationManager {
    private static DQuaternion interpolationStart;
    private static DQuaternion lastCameraRotation;
    private static long interpolationStartTime;
    private static long interpolationEndTime;
    public static final Minecraft client;

    public static void processTransformation(ActiveRenderInfo camera, MatrixStack matrixStack) {
        matrixStack.func_227866_c_().func_227870_a_().func_226591_a_();
        matrixStack.func_227866_c_().func_227872_b_().func_226119_c_();
        DQuaternion cameraRotation = DQuaternion.getCameraRotation(camera.func_216777_e(), camera.func_216778_f());
        DQuaternion finalRotation = TransformationManager.getFinalRotation(cameraRotation);
        matrixStack.func_227863_a_(finalRotation.toMcQuaternion());
        RenderInfo.applyAdditionalTransformations(matrixStack);
    }

    public static boolean isAnimationRunning() {
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        return progress >= -0.1 && progress <= 1.1;
    }

    public static DQuaternion getFinalRotation(DQuaternion cameraRotation) {
        double progress = (double)(RenderStates.renderStartNanoTime - interpolationStartTime) / ((double)interpolationEndTime - (double)interpolationStartTime);
        if (progress < 0.0 || progress >= 1.0) {
            return cameraRotation;
        }
        progress = TransformationManager.mapProgress(progress);
        DQuaternion cameraRotDelta = cameraRotation.hamiltonProduct(lastCameraRotation.getConjugated());
        interpolationStart = interpolationStart.hamiltonProduct(cameraRotDelta);
        lastCameraRotation = cameraRotation;
        return DQuaternion.interpolate(interpolationStart, cameraRotation, progress);
    }

    public static double mapProgress(double progress) {
        return Math.sin(progress * 1.5707963267948966);
    }

    public static void onClientPlayerTeleported(Portal portal) {
        if (portal.rotation != null) {
            ClientPlayerEntity player = TransformationManager.client.field_71439_g;
            DQuaternion currentCameraRotation = DQuaternion.getCameraRotation(player.field_70125_A, player.field_70177_z);
            DQuaternion currentCameraRotationInterpolated = TransformationManager.getFinalRotation(currentCameraRotation);
            DQuaternion rotationThroughPortal = currentCameraRotationInterpolated.hamiltonProduct(DQuaternion.fromMcQuaternion(portal.rotation).getConjugated());
            Vector3d oldViewVector = player.func_70676_i(RenderStates.tickDelta);
            Tuple<Double, Double> pitchYaw = DQuaternion.getPitchYawFromRotation(rotationThroughPortal);
            player.field_70177_z = (float)((Double)pitchYaw.func_76340_b()).doubleValue();
            player.field_70125_A = (float)((Double)pitchYaw.func_76341_a()).doubleValue();
            if (player.field_70125_A > 90.0f) {
                player.field_70125_A = 90.0f - (player.field_70125_A - 90.0f);
            } else if (player.field_70125_A < -90.0f) {
                player.field_70125_A = -90.0f + (-90.0f - player.field_70125_A);
            }
            player.field_70126_B = player.field_70177_z;
            player.field_70127_C = player.field_70125_A;
            player.field_71154_f = player.field_70177_z;
            player.field_71155_g = player.field_70125_A;
            player.field_71163_h = player.field_71154_f;
            player.field_71164_i = player.field_71155_g;
            DQuaternion newCameraRotation = DQuaternion.getCameraRotation(player.field_70125_A, player.field_70177_z);
            if (!DQuaternion.isClose(newCameraRotation, rotationThroughPortal, 0.001f)) {
                interpolationStart = rotationThroughPortal;
                lastCameraRotation = newCameraRotation;
                interpolationStartTime = RenderStates.renderStartNanoTime;
                interpolationEndTime = interpolationStartTime + Helper.secondToNano(TransformationManager.getAnimationDurationSeconds());
            }
            TransformationManager.updateCamera(client);
        }
    }

    private static double getAnimationDurationSeconds() {
        return 1.0;
    }

    private static void updateCamera(Minecraft client) {
        ActiveRenderInfo camera = client.field_71460_t.func_215316_n();
        camera.func_216772_a((IBlockReader)client.field_71441_e, (Entity)client.field_71439_g, !client.field_71474_y.func_243230_g().func_243192_a(), client.field_71474_y.func_243230_g().func_243193_b(), RenderStates.tickDelta);
    }

    public static Matrix4f getMirrorTransformation(Vector3d normal) {
        float x = (float)normal.field_72450_a;
        float y = (float)normal.field_72448_b;
        float z = (float)normal.field_72449_c;
        float[] arr = new float[]{1.0f - 2.0f * x * x, 0.0f - 2.0f * x * y, 0.0f - 2.0f * x * z, 0.0f, 0.0f - 2.0f * y * x, 1.0f - 2.0f * y * y, 0.0f - 2.0f * y * z, 0.0f, 0.0f - 2.0f * z * x, 0.0f - 2.0f * z * y, 1.0f - 2.0f * z * z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix4f matrix = new Matrix4f();
        ((IEMatrix4f)matrix).loadFromArray(arr);
        return matrix;
    }

    static {
        interpolationStartTime = 0L;
        interpolationEndTime = 1L;
        client = Minecraft.func_71410_x();
    }
}

