/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.qouteall.immersive_portals.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

public class ShaderManager {
    private int idContentShaderProgram = -1;

    public ShaderManager() {
        this.loadShaders();
    }

    public void loadShaders() {
        this.idContentShaderProgram = this.compileShaderPrograms("immersive_portals:shaders/content_shader_vs.glsl", "immersive_portals:shaders/content_shader_fs.glsl");
    }

    private int compileShader(String resourceName, int shaderType) {
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(resourceName)).func_199027_b();
            String shaderCode = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            int idShader = GL20.glCreateShader((int)shaderType);
            GL20.glShaderSource((int)idShader, (CharSequence)shaderCode);
            GL20.glCompileShader((int)idShader);
            int logLength = GL20.glGetShaderi((int)idShader, (int)35716);
            if (logLength > 0) {
                String errorLog = GL20.glGetShaderInfoLog((int)idShader, (int)logLength);
                Helper.err("SHADER COMPILE ERROR");
                System.err.print(errorLog);
            }
            return idShader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int compileShaderPrograms(String vertexShaderName, String fragmentShaderName) {
        int idVertexShader = this.compileShader(vertexShaderName, 35633);
        int idFragmentShader = this.compileShader(fragmentShaderName, 35632);
        int idProgram = GL20.glCreateProgram();
        GL20.glAttachShader((int)idProgram, (int)idVertexShader);
        GL20.glAttachShader((int)idProgram, (int)idFragmentShader);
        GL20.glLinkProgram((int)idProgram);
        int logLength = GL20.glGetProgrami((int)idProgram, (int)35716);
        if (logLength > 0) {
            Helper.err("LINKING ERROR");
        }
        GL20.glDeleteShader((int)idVertexShader);
        GL20.glDeleteShader((int)idFragmentShader);
        return idProgram;
    }

    public void loadContentShaderAndShaderVars(int textureSlot) {
        GL20.glUseProgram((int)this.idContentShaderProgram);
        int uniModelView = GL20.glGetUniformLocation((int)this.idContentShaderProgram, (CharSequence)"modelView");
        int uniProjection = GL20.glGetUniformLocation((int)this.idContentShaderProgram, (CharSequence)"projection");
        int uniSampler = GL20.glGetUniformLocation((int)this.idContentShaderProgram, (CharSequence)"sampler");
        int uniWidth = GL20.glGetUniformLocation((int)this.idContentShaderProgram, (CharSequence)"w");
        int uniHeight = GL20.glGetUniformLocation((int)this.idContentShaderProgram, (CharSequence)"h");
        GL20.glUniformMatrix4fv((int)uniModelView, (boolean)false, (FloatBuffer)Helper.getModelViewMatrix());
        GL20.glUniformMatrix4fv((int)uniProjection, (boolean)false, (FloatBuffer)Helper.getProjectionMatrix());
        GL20.glUniform1i((int)uniSampler, (int)textureSlot);
        GL20.glUniform1f((int)uniWidth, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k());
        GL20.glUniform1f((int)uniHeight, (float)Minecraft.func_71410_x().func_228018_at_().func_198091_l());
    }

    public void unloadShader() {
        GL20.glUseProgram((int)0);
    }
}

