/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.ducks.IEFrameBuffer;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyGameRenderer;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.QueryManager;
import com.qouteall.immersive_portals.render.ViewAreaRenderer;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class RendererUsingStencil
extends PortalRenderer {
    @Override
    public boolean shouldSkipClearing() {
        return PortalRendering.isRendering();
    }

    @Override
    public void onBeforeTranslucentRendering(MatrixStack matrixStack) {
        this.doPortalRendering(matrixStack);
    }

    private void doPortalRendering(MatrixStack matrixStack) {
        client.func_213239_aq().func_219895_b("render_portal_total");
        this.renderPortals(matrixStack);
        if (PortalRendering.isRendering()) {
            this.setStencilStateForWorldRendering();
        } else {
            this.myFinishRendering();
        }
    }

    @Override
    public void onAfterTranslucentRendering(MatrixStack matrixStack) {
    }

    @Override
    public void onRenderCenterEnded(MatrixStack matrixStack) {
    }

    @Override
    public void prepareRendering() {
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GlStateManager.func_227734_k_();
        GL11.glEnable((int)2960);
        IEFrameBuffer ieFrameBuffer = (IEFrameBuffer)client.func_147110_a();
        if (!ieFrameBuffer.getIsStencilBufferEnabled()) {
            ieFrameBuffer.setIsStencilBufferEnabledAndReload(true);
            if (Minecraft.func_238218_y_()) {
                RendererUsingStencil.client.field_71438_f.func_72712_a();
            }
        }
    }

    @Override
    public void finishRendering() {
    }

    private void myFinishRendering() {
        GL11.glStencilFunc((int)519, (int)2333, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glDisable((int)2960);
        GlStateManager.func_227734_k_();
    }

    @Override
    protected void doRenderPortal(Portal portal, MatrixStack matrixStack) {
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        client.func_213239_aq().func_76320_a("render_view_area");
        boolean anySamplePassed = QueryManager.renderAndGetDoesAnySamplePassed(() -> this.renderPortalViewAreaToStencil(portal, matrixStack));
        client.func_213239_aq().func_76319_b();
        if (!anySamplePassed) {
            this.setStencilStateForWorldRendering();
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        int thisPortalStencilValue = outerPortalStencilValue + 1;
        client.func_213239_aq().func_76320_a("clear_depth_of_view_area");
        this.clearDepthOfThePortalViewArea(portal);
        client.func_213239_aq().func_76319_b();
        this.renderPortalContent(portal);
        this.restoreDepthOfPortalViewArea(portal, matrixStack);
        RendererUsingStencil.clampStencilValue(outerPortalStencilValue);
        MyGameRenderer.resetDiffuseLighting(matrixStack);
        PortalRendering.popPortalLayer();
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public void invokeWorldRendering(RenderInfo renderInfo) {
        MyGameRenderer.renderWorldNew(renderInfo, runnable -> {
            this.setStencilStateForWorldRendering();
            runnable.run();
        });
    }

    private void renderPortalViewAreaToStencil(Portal portal, MatrixStack matrixStack) {
        int outerPortalStencilValue = PortalRendering.getPortalLayer();
        GL11.glStencilFunc((int)514, (int)outerPortalStencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GL11.glStencilMask((int)255);
        GlStateManager.func_227737_l_();
        GL20.glUseProgram((int)0);
        RenderSystem.enableDepthTest();
        GlStateManager.func_227667_a_((boolean)true);
        ViewAreaRenderer.drawPortalViewTriangle(portal, matrixStack, true, true);
        GlStateManager.func_227740_m_();
        CHelper.checkGlError();
    }

    private void clearDepthOfThePortalViewArea(Portal portal) {
        GlStateManager.func_227734_k_();
        this.setStencilStateForWorldRendering();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        int originalDepthFunc = GL11.glGetInteger((int)2932);
        GL11.glDepthFunc((int)519);
        GL11.glDepthRange((double)1.0, (double)1.0);
        MyRenderHelper.renderScreenTriangle();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthFunc((int)originalDepthFunc);
        GL11.glDepthRange((double)0.0, (double)1.0);
    }

    private void restoreDepthOfPortalViewArea(Portal portal, MatrixStack matrixStack) {
        this.setStencilStateForWorldRendering();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)true);
        GL20.glUseProgram((int)0);
        GlStateManager.func_227734_k_();
        ViewAreaRenderer.drawPortalViewTriangle(portal, matrixStack, false, false);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void clampStencilValue(int maximumValue) {
        GL11.glStencilFunc((int)513, (int)maximumValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7681, (int)7681);
        GL11.glDepthMask((boolean)false);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_227731_j_();
        MyRenderHelper.renderScreenTriangle();
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_227734_k_();
    }

    private void setStencilStateForWorldRendering() {
        int thisPortalStencilValue = PortalRendering.getPortalLayer();
        GL11.glStencilFunc((int)514, (int)thisPortalStencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
    }
}

