/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ducks.IEMinecraftClient;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.QueryManager;
import com.qouteall.immersive_portals.render.SecondaryFrameBuffer;
import com.qouteall.immersive_portals.render.ShaderManager;
import com.qouteall.immersive_portals.render.ViewAreaRenderer;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class RendererUsingFrameBuffer
extends PortalRenderer {
    SecondaryFrameBuffer secondaryFrameBuffer = new SecondaryFrameBuffer();

    @Override
    public void onBeforeTranslucentRendering(MatrixStack matrixStack) {
        this.renderPortals(matrixStack);
    }

    @Override
    public void onAfterTranslucentRendering(MatrixStack matrixStack) {
    }

    @Override
    public void onRenderCenterEnded(MatrixStack matrixStack) {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public void prepareRendering() {
        this.secondaryFrameBuffer.prepare();
        GlStateManager.func_227734_k_();
        GL11.glDisable((int)2960);
        if (CGlobal.shaderManager == null) {
            CGlobal.shaderManager = new ShaderManager();
        }
    }

    @Override
    protected void doRenderPortal(Portal portal, MatrixStack matrixStack) {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        Framebuffer oldFrameBuffer = client.func_147110_a();
        ((IEMinecraftClient)client).setFrameBuffer(this.secondaryFrameBuffer.fb);
        this.secondaryFrameBuffer.fb.func_147610_a(true);
        GlStateManager.func_227673_b_((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227631_a_((double)1.0);
        GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
        GL11.glDisable((int)2960);
        this.renderPortalContent(portal);
        ((IEMinecraftClient)client).setFrameBuffer(oldFrameBuffer);
        oldFrameBuffer.func_147610_a(true);
        PortalRendering.popPortalLayer();
        this.renderSecondBufferIntoMainBuffer(portal, matrixStack);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public boolean shouldSkipClearing() {
        return false;
    }

    private boolean testShouldRenderPortal(Portal portal, MatrixStack matrixStack) {
        return QueryManager.renderAndGetDoesAnySamplePassed(() -> {
            GlStateManager.func_227734_k_();
            GlStateManager.func_227667_a_((boolean)false);
            GL20.glUseProgram((int)0);
            ViewAreaRenderer.drawPortalViewTriangle(portal, matrixStack, true, true);
            GlStateManager.func_227667_a_((boolean)true);
        });
    }

    private void renderSecondBufferIntoMainBuffer(Portal portal, MatrixStack matrixStack) {
        MyRenderHelper.drawFrameBufferUp(portal, this.secondaryFrameBuffer.fb, matrixStack);
    }
}

