/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyGameRenderer;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.TransformationManager;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.Validate;

public abstract class PortalRenderer {
    public static final Minecraft client = Minecraft.func_71410_x();

    public abstract void onBeforeTranslucentRendering(MatrixStack var1);

    public abstract void onAfterTranslucentRendering(MatrixStack var1);

    public abstract void onRenderCenterEnded(MatrixStack var1);

    public abstract void prepareRendering();

    public abstract void finishRendering();

    public abstract void renderPortalInEntityRenderer(Portal var1);

    public abstract boolean shouldSkipClearing();

    protected void renderPortals(MatrixStack matrixStack) {
        Validate.isTrue((PortalRenderer.client.field_175622_Z.field_70170_p == PortalRenderer.client.field_71441_e ? 1 : 0) != 0);
        List<Portal> portalsNearbySorted = this.getPortalsNearbySorted();
        if (portalsNearbySorted.isEmpty()) {
            return;
        }
        ClippingHelper frustum = null;
        if (CGlobal.earlyFrustumCullingPortal) {
            frustum = new ClippingHelper(matrixStack.func_227866_c_().func_227870_a_(), RenderStates.projectionMatrix);
            Vector3d cameraPos = PortalRenderer.client.field_71460_t.func_215316_n().func_216785_c();
            frustum.func_228952_a_(cameraPos.field_72450_a, cameraPos.field_72448_b, cameraPos.field_72449_c);
        }
        for (Portal portal : portalsNearbySorted) {
            this.renderPortalIfRoughCheckPassed(portal, matrixStack, frustum);
        }
    }

    private void renderPortalIfRoughCheckPassed(Portal portal, MatrixStack matrixStack, ClippingHelper frustum) {
        Portal outerPortal;
        if (!portal.isPortalValid()) {
            Helper.err("rendering invalid portal " + (Object)((Object)portal));
            return;
        }
        if (RenderStates.getRenderedPortalNum() >= Global.portalRenderLimit) {
            return;
        }
        Vector3d thisTickEyePos = PortalRenderer.client.field_71460_t.func_215316_n().func_216785_c();
        if (!portal.isInFrontOfPortal(thisTickEyePos)) {
            return;
        }
        if (PortalRendering.isRendering() && Portal.isParallelPortal(portal, outerPortal = PortalRendering.getRenderingPortal())) {
            return;
        }
        if (this.isOutOfDistance(portal)) {
            return;
        }
        if (CGlobal.earlyFrustumCullingPortal && !frustum.func_228957_a_(portal.func_174813_aQ())) {
            return;
        }
        this.doRenderPortal(portal, matrixStack);
    }

    protected final double getRenderRange() {
        double range = PortalRenderer.client.field_71474_y.field_151451_c * 16;
        if (PortalRendering.getPortalLayer() > 1) {
            range /= (double)PortalRendering.getPortalLayer();
        }
        if (RenderStates.isLaggy) {
            range = 16.0;
        }
        return range;
    }

    private List<Portal> getPortalsNearbySorted() {
        Vector3d cameraPos = PortalRenderer.client.field_71460_t.func_215316_n().func_216785_c();
        return CHelper.getClientNearbyPortals(this.getRenderRange()).sorted(Comparator.comparing(portalEntity -> portalEntity.getDistanceToNearestPointInPortal(cameraPos))).collect(Collectors.toList());
    }

    protected abstract void doRenderPortal(Portal var1, MatrixStack var2);

    protected final void renderPortalContent(Portal portal) {
        if (PortalRendering.getPortalLayer() > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        Entity cameraEntity = PortalRenderer.client.field_175622_Z;
        ClientWorld newWorld = CGlobal.clientWorldLoader.getWorld(portal.dimensionTo);
        ActiveRenderInfo camera = PortalRenderer.client.field_71460_t.func_215316_n();
        PortalRendering.onBeginPortalWorldRendering();
        this.invokeWorldRendering(new RenderInfo(newWorld, PortalRendering.getRenderingCameraPos(), PortalRenderer.getAdditionalCameraTransformation(portal), portal));
        PortalRendering.onEndPortalWorldRendering();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227737_l_();
        MyRenderHelper.restoreViewPort();
    }

    public void invokeWorldRendering(RenderInfo renderInfo) {
        MyGameRenderer.renderWorldNew(renderInfo, Runnable::run);
    }

    private boolean isOutOfDistance(Portal portal) {
        return false;
    }

    @Nullable
    public static Matrix4f getAdditionalCameraTransformation(Portal portal) {
        if (portal instanceof Mirror) {
            return TransformationManager.getMirrorTransformation(portal.getNormal());
        }
        if (portal.rotation != null) {
            Quaternion rot = portal.rotation.func_227068_g_();
            rot.func_195892_e();
            return new Matrix4f(rot);
        }
        return null;
    }
}

