/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.context_management.RenderDimensionRedirect;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class PixelCuller {
    private static final Minecraft client = Minecraft.func_71410_x();
    private static double[] activeClipPlaneEquation;
    public static boolean isCullingEnabled;

    public static void endCulling() {
        GL11.glDisable((int)12288);
        isCullingEnabled = false;
    }

    public static void startCulling() {
        if (CGlobal.useFrontCulling && !PixelCuller.isShaderCulling()) {
            GL11.glEnable((int)12288);
        }
        isCullingEnabled = true;
    }

    public static void startClassicalCulling() {
        GL11.glEnable((int)12288);
        isCullingEnabled = true;
    }

    public static void updateCullingPlaneInner(MatrixStack matrixStack, Portal portal, boolean doCompensate) {
        activeClipPlaneEquation = PixelCuller.getClipEquationInner(portal, doCompensate);
        if (!PixelCuller.isShaderCulling()) {
            PixelCuller.loadCullingPlaneClassical(matrixStack);
        }
    }

    public static boolean isShaderCulling() {
        return OFInterface.isShaders.getAsBoolean() && !RenderDimensionRedirect.isNoShader((RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
    }

    public static void loadCullingPlaneClassical(MatrixStack matrixStack) {
        McHelper.runWithTransformation(matrixStack, () -> GL11.glClipPlane((int)12288, (double[])activeClipPlaneEquation));
    }

    public static void updateCullingPlaneOuter(MatrixStack matrixStack, Portal portal) {
        activeClipPlaneEquation = PixelCuller.getClipEquationOuter(portal);
        if (!PixelCuller.isShaderCulling()) {
            PixelCuller.loadCullingPlaneClassical(matrixStack);
        }
    }

    private static double[] getClipEquationInner(Portal portal, boolean doCompensate) {
        Vector3d cameraPos = PixelCuller.client.field_71460_t.func_215316_n().func_216785_c();
        Vector3d planeNormal = portal.getContentDirection();
        double correction = doCompensate ? portal.destination.func_178788_d(cameraPos).func_72430_b(portal.getContentDirection()) / 150.0 : 0.0;
        Vector3d portalPos = portal.destination.func_178788_d(planeNormal.func_186678_a(correction)).func_178788_d(cameraPos);
        double c = planeNormal.func_186678_a(-1.0).func_72430_b(portalPos);
        return new double[]{planeNormal.field_72450_a, planeNormal.field_72448_b, planeNormal.field_72449_c, c};
    }

    private static double[] getClipEquationOuter(Portal portal) {
        Vector3d planeNormal = portal.getNormal();
        Vector3d portalPos = portal.func_213303_ch().func_178788_d(PixelCuller.client.field_71460_t.func_215316_n().func_216785_c());
        double c = planeNormal.func_186678_a(-1.0).func_72430_b(portalPos);
        return new double[]{planeNormal.field_72450_a, planeNormal.field_72448_b, planeNormal.field_72449_c, c};
    }

    public static double[] getActiveCullingPlaneEquation() {
        return activeClipPlaneEquation;
    }

    static {
        isCullingEnabled = false;
    }
}

