/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.SodiumInterface;
import com.qouteall.immersive_portals.block_manipulation.BlockManipulationClient;
import com.qouteall.immersive_portals.ducks.IEGameRenderer;
import com.qouteall.immersive_portals.ducks.IEMinecraftClient;
import com.qouteall.immersive_portals.ducks.IEParticleManager;
import com.qouteall.immersive_portals.ducks.IEPlayerListEntry;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.ducks.IEWorldRendererChunkInfo;
import com.qouteall.immersive_portals.render.context_management.DimensionRenderHelper;
import com.qouteall.immersive_portals.render.context_management.FogRendererContext;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderDimensionRedirect;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MyGameRenderer {
    public static Minecraft client = Minecraft.func_71410_x();

    public static void renderWorldNew(RenderInfo renderInfo, Consumer<Runnable> invokeWrapper) {
        RenderInfo.pushRenderInfo(renderInfo);
        MyGameRenderer.switchAndRenderTheWorld(renderInfo.world, renderInfo.cameraPos, renderInfo.cameraPos, invokeWrapper);
        RenderInfo.popRenderInfo();
    }

    private static void switchAndRenderTheWorld(ClientWorld newWorld, Vector3d thisTickCameraPos, Vector3d lastTickCameraPos, Consumer<Runnable> invokeWrapper) {
        MyGameRenderer.resetGlStates();
        Entity cameraEntity = MyGameRenderer.client.field_175622_Z;
        Vector3d oldEyePos = McHelper.getEyePos(cameraEntity);
        Vector3d oldLastTickEyePos = McHelper.getLastTickEyePos(cameraEntity);
        RegistryKey oldEntityDimension = cameraEntity.field_70170_p.func_234923_W_();
        ClientWorld oldEntityWorld = (ClientWorld)cameraEntity.field_70170_p;
        RegistryKey newDimension = newWorld.func_234923_W_();
        McHelper.setEyePos(cameraEntity, thisTickCameraPos, lastTickCameraPos);
        cameraEntity.field_70170_p = newWorld;
        WorldRenderer worldRenderer = CGlobal.clientWorldLoader.getWorldRenderer((RegistryKey<World>)newDimension);
        CHelper.checkGlError();
        float tickDelta = RenderStates.tickDelta;
        if (CGlobal.useHackedChunkRenderDispatcher) {
            ((IEWorldRenderer)worldRenderer).getBuiltChunkStorage().func_178163_a(cameraEntity.func_226277_ct_(), cameraEntity.func_226281_cx_());
        }
        if (Global.looseVisibleChunkIteration) {
            MyGameRenderer.client.field_175612_E = false;
        }
        IEGameRenderer ieGameRenderer = (IEGameRenderer)MyGameRenderer.client.field_71460_t;
        DimensionRenderHelper helper = CGlobal.clientWorldLoader.getDimensionRenderHelper(RenderDimensionRedirect.getRedirectedDimension((RegistryKey<World>)newDimension));
        NetworkPlayerInfo playerListEntry = CHelper.getClientPlayerListEntry();
        ActiveRenderInfo newCamera = new ActiveRenderInfo();
        WorldRenderer oldWorldRenderer = MyGameRenderer.client.field_71438_f;
        LightTexture oldLightmap = MyGameRenderer.client.field_71460_t.func_228384_l_();
        GameType oldGameMode = playerListEntry.func_178848_b();
        boolean oldNoClip = MyGameRenderer.client.field_71439_g.field_70145_X;
        boolean oldDoRenderHand = ieGameRenderer.getDoRenderHand();
        OFInterface.createNewRenderInfosNormal.accept(worldRenderer);
        ObjectList oldVisibleChunks = ((IEWorldRenderer)oldWorldRenderer).getVisibleChunks();
        RayTraceResult oldCrosshairTarget = MyGameRenderer.client.field_71476_x;
        ActiveRenderInfo oldCamera = MyGameRenderer.client.field_71460_t.func_215316_n();
        ShaderGroup oldTransparencyShader = ((IEWorldRenderer)oldWorldRenderer).portal_getTransparencyShader();
        ShaderGroup newTransparencyShader = ((IEWorldRenderer)worldRenderer).portal_getTransparencyShader();
        ((IEWorldRenderer)oldWorldRenderer).setVisibleChunks((ObjectList)new ObjectArrayList());
        ((IEMinecraftClient)client).setWorldRenderer(worldRenderer);
        MyGameRenderer.client.field_71441_e = newWorld;
        ieGameRenderer.setLightmapTextureManager(helper.lightmapTexture);
        TileEntityRendererDispatcher.field_147556_a.field_147550_f = newWorld;
        ((IEPlayerListEntry)playerListEntry).setGameMode(GameType.SPECTATOR);
        MyGameRenderer.client.field_71439_g.field_70145_X = true;
        ieGameRenderer.setDoRenderHand(false);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227626_N_();
        FogRendererContext.swappingManager.pushSwapping(RenderDimensionRedirect.getRedirectedDimension((RegistryKey<World>)newDimension));
        ((IEParticleManager)MyGameRenderer.client.field_71452_i).mySetWorld(newWorld);
        if (BlockManipulationClient.remotePointedDim == newDimension) {
            MyGameRenderer.client.field_71476_x = BlockManipulationClient.remoteHitResult;
        }
        ieGameRenderer.setCamera(newCamera);
        Object newSodiumContext = SodiumInterface.createNewRenderingContext.apply(worldRenderer);
        Object oldSodiumContext = SodiumInterface.switchRenderingContext.apply(worldRenderer, newSodiumContext);
        ((IEWorldRenderer)oldWorldRenderer).portal_setTransparencyShader(null);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(null);
        if (!RenderStates.isDimensionRendered((RegistryKey<World>)newDimension)) {
            helper.lightmapTexture.func_205106_a(0.0f);
        }
        invokeWrapper.accept(() -> {
            client.func_213239_aq().func_76320_a("render_portal_content");
            MyGameRenderer.client.field_71460_t.func_228378_a_(tickDelta, Util.func_211178_c(), new MatrixStack());
            client.func_213239_aq().func_76319_b();
        });
        SodiumInterface.switchRenderingContext.apply(worldRenderer, oldSodiumContext);
        ((IEMinecraftClient)client).setWorldRenderer(oldWorldRenderer);
        MyGameRenderer.client.field_71441_e = oldEntityWorld;
        ieGameRenderer.setLightmapTextureManager(oldLightmap);
        TileEntityRendererDispatcher.field_147556_a.field_147550_f = oldEntityWorld;
        ((IEPlayerListEntry)playerListEntry).setGameMode(oldGameMode);
        MyGameRenderer.client.field_71439_g.field_70145_X = oldNoClip;
        ieGameRenderer.setDoRenderHand(oldDoRenderHand);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227627_O_();
        ((IEParticleManager)MyGameRenderer.client.field_71452_i).mySetWorld(oldEntityWorld);
        MyGameRenderer.client.field_71476_x = oldCrosshairTarget;
        ieGameRenderer.setCamera(oldCamera);
        ((IEWorldRenderer)oldWorldRenderer).portal_setTransparencyShader(oldTransparencyShader);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(newTransparencyShader);
        FogRendererContext.swappingManager.popSwapping();
        ((IEWorldRenderer)oldWorldRenderer).setVisibleChunks(oldVisibleChunks);
        if (Global.looseVisibleChunkIteration) {
            MyGameRenderer.client.field_175612_E = true;
        }
        client.func_175598_ae().func_229088_a_((World)MyGameRenderer.client.field_71441_e, oldCamera, MyGameRenderer.client.field_147125_j);
        CHelper.checkGlError();
        cameraEntity.field_70170_p = oldEntityWorld;
        McHelper.setEyePos(cameraEntity, oldEyePos, oldLastTickEyePos);
        MyGameRenderer.resetGlStates();
    }

    public static void resetGlStates() {
        GlStateManager.func_227700_d_();
        GlStateManager.func_227771_z_();
        GlStateManager.func_227737_l_();
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        MyGameRenderer.client.field_71460_t.func_228385_m_().func_229203_b_();
    }

    public static void renderPlayerItself(Runnable doRenderEntity) {
        EntityRendererManager entityRenderDispatcher = ((IEWorldRenderer)MyGameRenderer.client.field_71438_f).getEntityRenderDispatcher();
        NetworkPlayerInfo playerListEntry = CHelper.getClientPlayerListEntry();
        GameType originalGameMode = RenderStates.originalGameMode;
        Entity player = MyGameRenderer.client.field_175622_Z;
        assert (player != null);
        Vector3d oldPos = player.func_213303_ch();
        Vector3d oldLastTickPos = McHelper.lastTickPosOf(player);
        GameType oldGameMode = playerListEntry.func_178848_b();
        McHelper.setPosAndLastTickPos(player, RenderStates.originalPlayerPos, RenderStates.originalPlayerLastTickPos);
        ((IEPlayerListEntry)playerListEntry).setGameMode(originalGameMode);
        doRenderEntity.run();
        McHelper.setPosAndLastTickPos(player, oldPos, oldLastTickPos);
        ((IEPlayerListEntry)playerListEntry).setGameMode(oldGameMode);
    }

    public static void resetFogState() {
        if (OFInterface.isFogDisabled.getAsBoolean()) {
            return;
        }
        if (OFInterface.isShaders.getAsBoolean()) {
            return;
        }
        MyGameRenderer.forceResetFogState();
    }

    public static void forceResetFogState() {
        ActiveRenderInfo camera = MyGameRenderer.client.field_71460_t.func_215316_n();
        float g = MyGameRenderer.client.field_71460_t.func_205001_m();
        Vector3d cameraPos = camera.func_216785_c();
        double d = cameraPos.func_82615_a();
        double e = cameraPos.func_82617_b();
        double f = cameraPos.func_82616_c();
        boolean bl2 = MyGameRenderer.client.field_71441_e.func_239132_a_().func_230493_a_(MathHelper.func_76128_c((double)d), MathHelper.func_76128_c((double)e)) || MyGameRenderer.client.field_71456_v.func_184046_j().func_184056_f();
        FogRenderer.func_228372_a_((ActiveRenderInfo)camera, (FogRenderer.FogType)FogRenderer.FogType.FOG_TERRAIN, (float)Math.max(g - 16.0f, 32.0f), (boolean)bl2);
        FogRenderer.func_228373_b_();
    }

    public static void updateFogColor() {
        FogRenderer.func_228371_a_((ActiveRenderInfo)MyGameRenderer.client.field_71460_t.func_215316_n(), (float)RenderStates.tickDelta, (ClientWorld)MyGameRenderer.client.field_71441_e, (int)MyGameRenderer.client.field_71474_y.field_151451_c, (float)MyGameRenderer.client.field_71460_t.func_205002_d(RenderStates.tickDelta));
    }

    public static void resetDiffuseLighting(MatrixStack matrixStack) {
        RenderHelper.func_237533_a_((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
    }

    public static void pruneVisibleChunksInFastGraphics(ObjectList<?> visibleChunks) {
        int renderDistance = MyGameRenderer.client.field_71474_y.field_151451_c;
        Vector3d cameraPos = MyGameRenderer.client.field_71460_t.func_215316_n().func_216785_c();
        double range = renderDistance * 16 / 3 * (renderDistance * 16 / 3);
        Predicate<ChunkRenderDispatcher.ChunkRender> builtChunkPredicate = builtChunk -> {
            Vector3d center = builtChunk.field_178591_c.func_189972_c();
            return center.func_72436_e(cameraPos) > range;
        };
        Helper.removeIf(visibleChunks, obj -> builtChunkPredicate.test(((IEWorldRendererChunkInfo)obj).getBuiltChunk()));
    }

    public static void doPruneVisibleChunks(ObjectList<?> visibleChunks) {
        if (!PortalRendering.isRendering() || CGlobal.renderFewerInFastGraphic) {
            // empty if block
        }
    }

    public static void renderSkyFor(RegistryKey<World> dimension, MatrixStack matrixStack, float tickDelta) {
        MyGameRenderer.client.field_71438_f.func_228424_a_(matrixStack, tickDelta);
    }
}

