/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.my_util.ObjectBuffer;
import com.qouteall.immersive_portals.optifine_compatibility.OFBuiltChunkNeighborFix;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class MyBuiltChunkStorage
extends ViewFrustum {
    private ChunkRenderDispatcher factory;
    private Map<BlockPos, ChunkRenderDispatcher.ChunkRender> builtChunkMap = new HashMap<BlockPos, ChunkRenderDispatcher.ChunkRender>();
    private Map<ChunkPos, Preset> presets = new HashMap<ChunkPos, Preset>();
    private boolean shouldUpdateMainPresetNeighbor = true;
    private ObjectBuffer<ChunkRenderDispatcher.ChunkRender> builtChunkBuffer;

    public MyBuiltChunkStorage(ChunkRenderDispatcher chunkBuilder_1, World world_1, int int_1, WorldRenderer worldRenderer_1) {
        super(chunkBuilder_1, world_1, int_1, worldRenderer_1);
        this.factory = chunkBuilder_1;
        ModMain.postClientTickSignal.connectWithWeakRef(this, MyBuiltChunkStorage::tick);
        int cacheSize = this.field_178165_d * this.field_178168_c * this.field_178166_e;
        if (Global.cacheGlBuffer) {
            cacheSize /= 10;
        }
        this.builtChunkBuffer = new ObjectBuffer<ChunkRenderDispatcher.ChunkRender>(cacheSize, () -> new ChunkRenderDispatcher.ChunkRender(this.factory), ChunkRenderDispatcher.ChunkRender::func_178566_a);
        ModMain.preRenderSignal.connectWithWeakRef(this, this_ -> {
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("reserve");
            this_.builtChunkBuffer.reserveObjects(this.field_178165_d * this.field_178168_c * this.field_178166_e / 100);
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        });
    }

    protected void func_228789_a_(ChunkRenderDispatcher chunkBuilder_1) {
    }

    public void func_178160_a() {
        this.getAllActiveBuiltChunks().forEach(ChunkRenderDispatcher.ChunkRender::func_178566_a);
        this.builtChunkMap.clear();
        this.presets.clear();
        this.builtChunkBuffer.destroyAll();
    }

    public void func_178163_a(double playerX, double playerZ) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("built_chunk_storage");
        ChunkPos cameraChunkPos = new ChunkPos(MathHelper.func_76137_a((int)((int)playerX), (int)16), MathHelper.func_76137_a((int)((int)playerZ), (int)16));
        Preset preset = this.presets.computeIfAbsent(cameraChunkPos, whatever -> this.myCreatePreset(playerX, playerZ));
        preset.lastActiveTime = System.nanoTime();
        this.field_178164_f = preset.data;
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("neighbor");
        this.manageNeighbor(preset);
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private void manageNeighbor(Preset preset) {
        boolean isRenderingPortal = PortalRendering.isRendering();
        if (!isRenderingPortal && this.shouldUpdateMainPresetNeighbor) {
            this.shouldUpdateMainPresetNeighbor = false;
            OFBuiltChunkNeighborFix.updateNeighbor(this, preset.data);
            preset.isNeighborUpdated = true;
        }
        if (!preset.isNeighborUpdated) {
            OFBuiltChunkNeighborFix.updateNeighbor(this, preset.data);
            preset.isNeighborUpdated = true;
            if (isRenderingPortal) {
                this.shouldUpdateMainPresetNeighbor = true;
            }
        }
    }

    public void func_217628_a(int cx, int cy, int cz, boolean isImportant) {
        ChunkRenderDispatcher.ChunkRender builtChunk = this.provideBuiltChunk(new BlockPos(cx * 16, cy * 16, cz * 16));
        builtChunk.func_178575_a(isImportant);
    }

    private Preset myCreatePreset(double playerXCoord, double playerZCoord) {
        ChunkRenderDispatcher.ChunkRender[] chunks = new ChunkRenderDispatcher.ChunkRender[this.field_178165_d * this.field_178168_c * this.field_178166_e];
        int int_1 = MathHelper.func_76128_c((double)playerXCoord);
        int int_2 = MathHelper.func_76128_c((double)playerZCoord);
        for (int cx = 0; cx < this.field_178165_d; ++cx) {
            int int_4 = this.field_178165_d * 16;
            int int_5 = int_1 - 8 - int_4 / 2;
            int px = int_5 + Math.floorMod(cx * 16 - int_5, int_4);
            for (int cz = 0; cz < this.field_178166_e; ++cz) {
                int int_8 = this.field_178166_e * 16;
                int int_9 = int_2 - 8 - int_8 / 2;
                int pz = int_9 + Math.floorMod(cz * 16 - int_9, int_8);
                for (int cy = 0; cy < this.field_178168_c; ++cy) {
                    int py = cy * 16;
                    int index = this.getChunkIndex(cx, cy, cz);
                    Validate.isTrue((px % 16 == 0 ? 1 : 0) != 0);
                    Validate.isTrue((py % 16 == 0 ? 1 : 0) != 0);
                    Validate.isTrue((pz % 16 == 0 ? 1 : 0) != 0);
                    chunks[index] = this.provideBuiltChunk(new BlockPos(px, py, pz));
                }
            }
        }
        return new Preset(chunks, false);
    }

    private int getChunkIndex(int int_1, int int_2, int int_3) {
        return (int_3 * this.field_178168_c + int_2) * this.field_178165_d + int_1;
    }

    private static BlockPos getBasePos(BlockPos blockPos) {
        return new BlockPos(MathHelper.func_76137_a((int)blockPos.func_177958_n(), (int)16) * 16, MathHelper.func_76137_a((int)MathHelper.func_76125_a((int)blockPos.func_177956_o(), (int)0, (int)255), (int)16) * 16, MathHelper.func_76137_a((int)blockPos.func_177952_p(), (int)16) * 16);
    }

    public ChunkRenderDispatcher.ChunkRender provideBuiltChunk(BlockPos blockPos) {
        return this.provideBuiltChunkWithAlignedPos(MyBuiltChunkStorage.getBasePos(blockPos));
    }

    private ChunkRenderDispatcher.ChunkRender provideBuiltChunkWithAlignedPos(BlockPos basePos) {
        assert (basePos.func_177958_n() % 16 == 0);
        assert (basePos.func_177956_o() % 16 == 0);
        assert (basePos.func_177952_p() % 16 == 0);
        if (basePos.func_177956_o() < 0 || basePos.func_177956_o() >= 256) {
            return null;
        }
        return this.builtChunkMap.computeIfAbsent(basePos.func_185334_h(), whatever -> {
            ChunkRenderDispatcher.ChunkRender builtChunk = this.builtChunkBuffer.takeObject();
            builtChunk.func_189562_a(basePos.func_177958_n(), basePos.func_177956_o(), basePos.func_177952_p());
            return builtChunk;
        });
    }

    private void tick() {
        ClientWorld worldClient = Minecraft.func_71410_x().field_71441_e;
        if (worldClient != null && worldClient.func_82737_E() % 213L == 66L) {
            this.purge();
        }
    }

    private void purge() {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("my_built_chunk_storage_purge");
        long currentTime = System.nanoTime();
        this.presets.entrySet().removeIf(entry -> {
            Preset preset = (Preset)entry.getValue();
            if (preset.data == this.field_178164_f) {
                return false;
            }
            return currentTime - preset.lastActiveTime > Helper.secondToNano(20.0);
        });
        Set<ChunkRenderDispatcher.ChunkRender> activeBuiltChunks = this.getAllActiveBuiltChunks();
        List<ChunkRenderDispatcher.ChunkRender> chunksToDelete = this.builtChunkMap.values().stream().filter(builtChunk -> !activeBuiltChunks.contains(builtChunk)).collect(Collectors.toList());
        chunksToDelete.forEach(builtChunk -> {
            this.builtChunkBuffer.returnObject((ChunkRenderDispatcher.ChunkRender)builtChunk);
            ChunkRenderDispatcher.ChunkRender removed = this.builtChunkMap.remove(builtChunk.func_178568_j());
            if (removed == null) {
                Helper.err("Chunk Renderer Abnormal " + builtChunk.func_178568_j());
            }
        });
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private Set<ChunkRenderDispatcher.ChunkRender> getAllActiveBuiltChunks() {
        Stream chunksFromPresets = this.presets.values().stream().flatMap(preset -> Arrays.stream(preset.data));
        Stream result = this.field_178164_f == null ? chunksFromPresets : Streams.concat((Stream[])new Stream[]{Arrays.stream(this.field_178164_f), chunksFromPresets});
        return result.collect(Collectors.toSet());
    }

    public int getManagedChunkNum() {
        return this.builtChunkMap.size();
    }

    public ChunkRenderDispatcher.ChunkRender myGetRenderChunkRaw(BlockPos pos, ChunkRenderDispatcher.ChunkRender[] chunks) {
        int i = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        int j = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
        int k = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
        if (j >= 0 && j < this.field_178168_c) {
            i = MathHelper.func_180184_b((int)i, (int)this.field_178165_d);
            k = MathHelper.func_180184_b((int)k, (int)this.field_178166_e);
            return chunks[this.getChunkIndex(i, j, k)];
        }
        return null;
    }

    public String getDebugString() {
        return String.format("All:%s Needs Rebuild:%s", this.builtChunkMap.size(), this.builtChunkMap.values().stream().filter(builtChunk -> builtChunk.func_178569_m()).count());
    }

    public static class Preset {
        public ChunkRenderDispatcher.ChunkRender[] data;
        public long lastActiveTime;
        public boolean isNeighborUpdated;

        public Preset(ChunkRenderDispatcher.ChunkRender[] data, boolean isNeighborUpdated) {
            this.data = data;
            this.isNeighborUpdated = isNeighborUpdated;
        }
    }
}

