/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FrustumCuller {
    private BoxPredicate canDetermineInvisibleFunc;
    private static final BoxPredicate nonePredicate = (minX, minY, minZ, maxX, maxY, maxZ) -> false;

    public void update(double cameraX, double cameraY, double cameraZ) {
        this.canDetermineInvisibleFunc = this.getCanDetermineInvisibleFunc(cameraX, cameraY, cameraZ);
    }

    public boolean canDetermineInvisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.canDetermineInvisibleFunc.test(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private BoxPredicate getCanDetermineInvisibleFunc(double cameraX, double cameraY, double cameraZ) {
        if (!CGlobal.doUseAdvancedFrustumCulling) {
            return nonePredicate;
        }
        if (PortalRendering.isRendering()) {
            Portal portal = PortalRendering.getRenderingPortal();
            Vector3d portalOriginInLocalCoordinate = portal.destination.func_72441_c(-cameraX, -cameraY, -cameraZ);
            Vector3d[] downLeftUpRightPlaneNormals = this.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, portal.getFourVerticesLocalRotated(0.0));
            Vector3d downPlane = downLeftUpRightPlaneNormals[0];
            Vector3d leftPlane = downLeftUpRightPlaneNormals[1];
            Vector3d upPlane = downLeftUpRightPlaneNormals[2];
            Vector3d rightPlane = downLeftUpRightPlaneNormals[3];
            return (minX, minY, minZ, maxX, maxY, maxZ) -> FrustumCuller.isFullyOutsideFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
        }
        if (!CGlobal.useSuperAdvancedFrustumCulling) {
            return nonePredicate;
        }
        Portal portal = FrustumCuller.getCurrentNearestVisibleCullablePortal();
        if (portal != null) {
            Vector3d portalOrigin = portal.func_213303_ch();
            Vector3d portalOriginInLocalCoordinate = portalOrigin.func_72441_c(-cameraX, -cameraY, -cameraZ);
            Vector3d[] downLeftUpRightPlaneNormals = this.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, portal.getFourVerticesLocalCullable(0.0));
            Vector3d downPlane = downLeftUpRightPlaneNormals[0];
            Vector3d leftPlane = downLeftUpRightPlaneNormals[1];
            Vector3d upPlane = downLeftUpRightPlaneNormals[2];
            Vector3d rightPlane = downLeftUpRightPlaneNormals[3];
            Vector3d nearPlanePosInLocalCoordinate = portalOriginInLocalCoordinate;
            Vector3d nearPlaneNormal = portal.getNormal().func_186678_a(-1.0);
            return (minX, minY, minZ, maxX, maxY, maxZ) -> {
                boolean isBehindNearPlane;
                boolean bl = isBehindNearPlane = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, nearPlaneNormal.field_72450_a, nearPlaneNormal.field_72448_b, nearPlaneNormal.field_72449_c, nearPlanePosInLocalCoordinate.field_72450_a, nearPlanePosInLocalCoordinate.field_72448_b, nearPlanePosInLocalCoordinate.field_72449_c) == BatchTestResult.all_true;
                if (!isBehindNearPlane) {
                    return false;
                }
                boolean fullyInFrustum = FrustumCuller.isFullyInFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
                return fullyInFrustum;
            };
        }
        return nonePredicate;
    }

    public Vector3d[] getDownLeftUpRightPlaneNormals(Vector3d portalOriginInLocalCoordinate, Vector3d[] fourVertices) {
        Vector3d[] relativeVertices = new Vector3d[]{fourVertices[0].func_178787_e(portalOriginInLocalCoordinate), fourVertices[1].func_178787_e(portalOriginInLocalCoordinate), fourVertices[2].func_178787_e(portalOriginInLocalCoordinate), fourVertices[3].func_178787_e(portalOriginInLocalCoordinate)};
        return new Vector3d[]{relativeVertices[0].func_72431_c(relativeVertices[1]), relativeVertices[1].func_72431_c(relativeVertices[3]), relativeVertices[3].func_72431_c(relativeVertices[2]), relativeVertices[2].func_72431_c(relativeVertices[0])};
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double planeNormalX, double planeNormalY, double planeNormalZ, double planePosX, double planePosY, double planePosZ) {
        double p2z;
        double p1z;
        double p2y;
        double p1y;
        double p2x;
        double p1x;
        if (planeNormalX > 0.0) {
            p1x = minX;
            p2x = maxX;
        } else {
            p1x = maxX;
            p2x = minX;
        }
        if (planeNormalY > 0.0) {
            p1y = minY;
            p2y = maxY;
        } else {
            p1y = maxY;
            p2y = minY;
        }
        if (planeNormalZ > 0.0) {
            p1z = minZ;
            p2z = maxZ;
        } else {
            p1z = maxZ;
            p2z = minZ;
        }
        boolean r1 = FrustumCuller.isInFrontOf(p1x - planePosX, p1y - planePosY, p1z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        boolean r2 = FrustumCuller.isInFrontOf(p2x - planePosX, p2y - planePosY, p2z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        if (r1 && r2) {
            return BatchTestResult.all_true;
        }
        if (!r1 && !r2) {
            return BatchTestResult.all_false;
        }
        return BatchTestResult.both;
    }

    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vector3d planeNormal) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, planeNormal.field_72450_a, planeNormal.field_72448_b, planeNormal.field_72449_c, 0.0, 0.0, 0.0);
    }

    private static boolean isInFrontOf(double x, double y, double z, Vector3d planeNormal) {
        return x * planeNormal.field_72450_a + y * planeNormal.field_72448_b + z * planeNormal.field_72449_c >= 0.0;
    }

    private static boolean isInFrontOf(double x, double y, double z, double planeNormalX, double planeNormalY, double planeNormalZ) {
        return x * planeNormalX + y * planeNormalY + z * planeNormalZ >= 0.0;
    }

    private static boolean isFullyOutsideFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vector3d leftPlane, Vector3d rightPlane, Vector3d upPlane, Vector3d downPlane) {
        BatchTestResult left = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane);
        BatchTestResult right = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane);
        if (left == BatchTestResult.all_false && right == BatchTestResult.all_true) {
            return true;
        }
        if (left == BatchTestResult.all_true && right == BatchTestResult.all_false) {
            return true;
        }
        BatchTestResult up = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane);
        BatchTestResult down = FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane);
        if (up == BatchTestResult.all_false && down == BatchTestResult.all_true) {
            return true;
        }
        return up == BatchTestResult.all_true && down == BatchTestResult.all_false;
    }

    private static boolean isFullyInFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Vector3d leftPlane, Vector3d rightPlane, Vector3d upPlane, Vector3d downPlane) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, leftPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, rightPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, upPlane) == BatchTestResult.all_true && FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, downPlane) == BatchTestResult.all_true;
    }

    private static Portal getCurrentNearestVisibleCullablePortal() {
        Vector3d cameraPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        return CHelper.getClientNearbyPortals(16.0).filter(portal -> portal.isInFrontOfPortal(cameraPos)).filter(Portal::isCullable).min(Comparator.comparingDouble(portal -> portal.getDistanceToNearestPointInPortal(cameraPos))).orElse(null);
    }

    private static enum BatchTestResult {
        all_true,
        all_false,
        both;

    }

    public static interface BoxPredicate {
        public boolean test(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

