/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.ducks.IEEntity;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.optifine_compatibility.ShaderCullingManager;
import com.qouteall.immersive_portals.portal.Mirror;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyGameRenderer;
import com.qouteall.immersive_portals.render.PixelCuller;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrossPortalEntityRenderer {
    private static final Minecraft client = Minecraft.func_71410_x();
    private static final WeakHashMap<Entity, Object> collidedEntities = new WeakHashMap();
    public static boolean isRendering = false;

    public static void init() {
        ModMain.postClientTickSignal.connect(CrossPortalEntityRenderer::onClientTick);
    }

    public static void cleanUp() {
        collidedEntities.clear();
    }

    private static void onClientTick() {
        collidedEntities.entrySet().removeIf(entry -> ((Entity)entry.getKey()).field_70128_L || ((IEEntity)entry.getKey()).getCollidingPortal() == null);
    }

    public static void onEntityTickClient(Entity entity) {
        if (entity instanceof Portal) {
            return;
        }
        Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
        if (collidingPortal != null) {
            collidedEntities.put(entity, null);
        }
    }

    public static void onBeginRenderingEntities(MatrixStack matrixStack) {
        if (PortalRendering.isRendering()) {
            PixelCuller.updateCullingPlaneInner(matrixStack, PortalRendering.getRenderingPortal(), false);
            PixelCuller.startCulling();
        }
    }

    public static void onEndRenderingEntities(MatrixStack matrixStack) {
        PixelCuller.endCulling();
        CrossPortalEntityRenderer.renderEntityProjections(matrixStack);
    }

    public static void beforeRenderingEntity(Entity entity, MatrixStack matrixStack) {
        if (!Global.correctCrossPortalEntityRendering) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (collidingPortal == null) {
                return;
            }
            client.func_228019_au_().func_228487_b_().func_228461_a_();
            PixelCuller.updateCullingPlaneOuter(matrixStack, collidingPortal);
            PixelCuller.startCulling();
            if (OFInterface.isShaders.getAsBoolean()) {
                ShaderCullingManager.update();
            }
        }
    }

    public static void afterRenderingEntity(Entity entity) {
        if (!Global.correctCrossPortalEntityRendering) {
            return;
        }
        if (!PortalRendering.isRendering() && collidedEntities.containsKey(entity)) {
            client.func_228019_au_().func_228487_b_().func_228461_a_();
            PixelCuller.endCulling();
        }
    }

    private static void renderEntityProjections(MatrixStack matrixStack) {
        if (!Global.correctCrossPortalEntityRendering) {
            return;
        }
        collidedEntities.keySet().forEach(entity -> {
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (collidingPortal == null) {
                return;
            }
            if (collidingPortal instanceof Mirror) {
                return;
            }
            if (collidingPortal.rotation != null) {
                return;
            }
            if (collidingPortal.hasScaling()) {
                return;
            }
            RegistryKey<World> projectionDimension = collidingPortal.dimensionTo;
            if (CrossPortalEntityRenderer.client.field_71441_e.func_234923_W_() == projectionDimension) {
                CrossPortalEntityRenderer.renderProjectedEntity(entity, collidingPortal, matrixStack);
            }
        });
    }

    public static boolean hasIntersection(Vector3d outerPlanePos, Vector3d outerPlaneNormal, Vector3d entityPos, Vector3d collidingPortalNormal) {
        return entityPos.func_178788_d(outerPlanePos).func_72430_b(outerPlaneNormal) > 0.01 && outerPlanePos.func_178788_d(entityPos).func_72430_b(collidingPortalNormal) > 0.01;
    }

    private static void renderProjectedEntity(Entity entity, Portal collidingPortal, MatrixStack matrixStack) {
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            if (!Portal.isFlippedPortal(renderingPortal, collidingPortal)) {
                boolean isHidden;
                Vector3d cameraPos = CrossPortalEntityRenderer.client.field_71460_t.func_215316_n().func_216785_c();
                boolean bl = isHidden = cameraPos.func_178788_d(collidingPortal.destination).func_72430_b(collidingPortal.getContentDirection()) < 0.0;
                if (renderingPortal == collidingPortal || !isHidden) {
                    CrossPortalEntityRenderer.renderEntityRegardingPlayer(entity, collidingPortal, matrixStack);
                }
            }
        } else {
            PixelCuller.updateCullingPlaneInner(matrixStack, collidingPortal, false);
            PixelCuller.startCulling();
            CrossPortalEntityRenderer.renderEntityRegardingPlayer(entity, collidingPortal, matrixStack);
            PixelCuller.endCulling();
        }
    }

    private static void renderEntityRegardingPlayer(Entity entity, Portal transformingPortal, MatrixStack matrixStack) {
        if (entity instanceof ClientPlayerEntity) {
            MyGameRenderer.renderPlayerItself(() -> CrossPortalEntityRenderer.renderEntity(entity, transformingPortal, matrixStack));
        } else {
            CrossPortalEntityRenderer.renderEntity(entity, transformingPortal, matrixStack);
        }
    }

    private static void renderEntity(Entity entity, Portal transformingPortal, MatrixStack matrixStack) {
        Portal renderingPortal;
        Vector3d cameraPos = CrossPortalEntityRenderer.client.field_71460_t.func_215316_n().func_216785_c();
        ClientWorld newWorld = CGlobal.clientWorldLoader.getWorld(transformingPortal.dimensionTo);
        Vector3d oldEyePos = McHelper.getEyePos(entity);
        Vector3d oldLastTickEyePos = McHelper.getLastTickEyePos(entity);
        World oldWorld = entity.field_70170_p;
        Vector3d newEyePos = transformingPortal.transformPoint(oldEyePos);
        if (PortalRendering.isRendering() && !(renderingPortal = PortalRendering.getRenderingPortal()).isInside(newEyePos, -3.0)) {
            return;
        }
        if (entity instanceof ClientPlayerEntity) {
            double valve;
            if (!Global.renderYourselfInPortal) {
                return;
            }
            double dis = newEyePos.func_72438_d(cameraPos);
            if (dis < (valve = 0.5 + McHelper.lastTickPosOf(entity).func_72438_d(entity.func_213303_ch()))) {
                return;
            }
        }
        McHelper.setEyePos(entity, newEyePos, transformingPortal.transformPoint(oldLastTickEyePos));
        entity.field_70170_p = newWorld;
        isRendering = true;
        OFInterface.updateEntityTypeForShader.accept(entity);
        IRenderTypeBuffer.Impl consumers = client.func_228019_au_().func_228487_b_();
        ((IEWorldRenderer)CrossPortalEntityRenderer.client.field_71438_f).myRenderEntity(entity, cameraPos.field_72450_a, cameraPos.field_72448_b, cameraPos.field_72449_c, RenderStates.tickDelta, matrixStack, (IRenderTypeBuffer)consumers);
        consumers.func_228461_a_();
        isRendering = false;
        McHelper.setEyePos(entity, oldEyePos, oldLastTickEyePos);
        entity.field_70170_p = oldWorld;
    }

    public static boolean shouldRenderPlayerItself() {
        if (!Global.renderYourselfInPortal) {
            return false;
        }
        if (!PortalRendering.isRendering()) {
            return false;
        }
        return CrossPortalEntityRenderer.client.field_175622_Z.field_70170_p.func_234923_W_() == RenderStates.originalPlayerDimension;
    }

    public static boolean shouldRenderEntityNow(Entity entity) {
        if (OFInterface.isShadowPass.getAsBoolean()) {
            return true;
        }
        if (PortalRendering.isRendering()) {
            if (entity instanceof ClientPlayerEntity) {
                return CrossPortalEntityRenderer.shouldRenderPlayerItself();
            }
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
            if (collidingPortal != null && !Portal.isReversePortal(collidingPortal, renderingPortal)) {
                boolean isHidden;
                Vector3d cameraPos = PortalRenderer.client.field_71460_t.func_215316_n().func_216785_c();
                boolean bl = isHidden = cameraPos.func_178788_d(collidingPortal.func_213303_ch()).func_72430_b(collidingPortal.getNormal()) < 0.0;
                if (isHidden) {
                    return false;
                }
            }
            return renderingPortal.isInside(entity.func_174824_e(RenderStates.tickDelta), -0.01);
        }
        return true;
    }
}

