/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.nether_portal;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalGeneration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NetherPortalMatcher {
    public static final int maxFrameSize = 40;
    public static final IntBox heightLimitOverworld = new IntBox(new BlockPos(Integer.MIN_VALUE, 2, Integer.MIN_VALUE), new BlockPos(Integer.MAX_VALUE, 254, Integer.MAX_VALUE));
    public static final IntBox heightLimitNether = new IntBox(new BlockPos(Integer.MIN_VALUE, 2, Integer.MIN_VALUE), new BlockPos(Integer.MAX_VALUE, 126, Integer.MAX_VALUE));

    @Deprecated
    public static Stream<BlockPos> fromNearToFarWithinHeightLimit(BlockPos searchingCenter, int maxRadius, IntBox heightLimit) {
        return IntStream.range(0, maxRadius).boxed().flatMap(r -> new IntBox(new BlockPos(-r.intValue(), -r.intValue(), -r.intValue()), new BlockPos(r.intValue(), r.intValue(), r.intValue())).getMoved((Vector3i)searchingCenter).forSixSurfaces(stream -> stream.map(box -> IntBox.getIntersect(box, heightLimit)).filter(Objects::nonNull)));
    }

    @Deprecated
    public static IntBox getHeightLimit(World world) {
        return new IntBox(new BlockPos(Integer.MIN_VALUE, 2, Integer.MIN_VALUE), new BlockPos(Integer.MAX_VALUE, world.func_234938_ad_() - 2, Integer.MAX_VALUE));
    }

    @Deprecated
    public static Stream<BlockPos> forOneDirection(BlockPos startPos, Direction facing, int limit) {
        return IntStream.range(0, limit).mapToObj(num -> startPos.func_177971_a((Vector3i)Helper.scale(facing.func_176730_m(), num)));
    }

    @Deprecated
    private static IntBox detectStick(IWorld world, BlockPos center, Direction.Axis axis, Predicate<BlockPos> predicate, int minLength) {
        BlockPos lowExtremity = NetherPortalMatcher.detectStickForOneDirection(center, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis), predicate);
        if (lowExtremity == null) {
            return null;
        }
        BlockPos highExtremity = NetherPortalMatcher.detectStickForOneDirection(center, Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), predicate);
        if (highExtremity == null) {
            return null;
        }
        int stickLength = Math.abs(Helper.getCoordinate((Vector3i)lowExtremity, axis) - Helper.getCoordinate((Vector3i)highExtremity, axis));
        if (stickLength < minLength) {
            return null;
        }
        return new IntBox(lowExtremity, highExtremity);
    }

    @Deprecated
    private static BlockPos detectStickForOneDirection(BlockPos startPos, Direction facing, Predicate<BlockPos> predicate) {
        return Helper.getLastSatisfying(NetherPortalMatcher.forOneDirection(startPos, facing, 40), predicate);
    }

    private static boolean isAir(IWorld world, BlockPos pos) {
        return world.func_175623_d(pos);
    }

    public static boolean isAirOrFire(IWorld world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab;
    }

    public static boolean isAirOrFire(BlockState blockState) {
        return blockState.func_196958_f() || blockState.func_177230_c() == Blocks.field_150480_ab;
    }

    static IntBox findVerticalPortalPlacement(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int findingRadius) {
        IntBox airCube = NetherPortalMatcher.getAirCubeOnSolidGround(areaSize.func_177982_a(7, 0, 7), world, searchingCenter, 8, true);
        if (airCube == null) {
            Helper.log("Cannot Find Portal Placement on Solid Ground");
            airCube = NetherPortalMatcher.getAirCubeOnSolidGround(areaSize.func_177982_a(5, 0, 5), world, searchingCenter, 8, false);
        }
        if (airCube == null) {
            Helper.log("Cannot Find Portal Placement on Ground");
            return null;
        }
        if (world.func_180495_p(airCube.l.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150353_l) {
            Helper.log("Generated Portal On Lava Lake");
            return NetherPortalMatcher.levitateBox(world, airCube.getSubBoxInCenter(areaSize), 40);
        }
        Helper.log("Generated Portal On Ground");
        return NetherPortalMatcher.pushDownBox(world, airCube.getSubBoxInCenter(areaSize));
    }

    private static boolean isLavaLake(IWorld world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150353_l && world.func_180495_p(blockPos.func_177982_a(5, 0, 5)).func_177230_c() == Blocks.field_150353_l && world.func_180495_p(blockPos.func_177982_a(-5, 0, -5)).func_177230_c() == Blocks.field_150353_l;
    }

    private static IntBox getAirCubeOnGround(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int findingRadius, Predicate<BlockPos> groundBlockLimit) {
        return NetherPortalGeneration.fromNearToFarColumned((ServerWorld)world, searchingCenter.func_177958_n(), searchingCenter.func_177952_p(), findingRadius).filter(blockPos -> NetherPortalMatcher.isAirOnGround(world, blockPos)).filter(blockPos -> groundBlockLimit.test(blockPos.func_177982_a(0, -1, 0))).map(basePoint -> IntBox.getBoxByBasePointAndSize(areaSize, basePoint.func_177973_b(new Vector3i(-areaSize.func_177958_n() / 2, 0, -areaSize.func_177952_p() / 2)))).filter(box -> NetherPortalMatcher.isAirCubeMediumPlace(world, box)).findFirst().orElse(null);
    }

    private static IntBox getAirCubeOnSolidGround(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int findingRadius, boolean solidGround) {
        return NetherPortalGeneration.fromNearToFarColumned((ServerWorld)world, searchingCenter.func_177958_n(), searchingCenter.func_177952_p(), findingRadius).filter(blockPos -> NetherPortalMatcher.isAirOnGround(world, blockPos)).filter(blockPos -> solidGround ? NetherPortalMatcher.isAirOnGround(world, blockPos.func_177982_a(areaSize.func_177958_n() - 1, 0, areaSize.func_177952_p() - 1)) : true).map(basePoint -> IntBox.getBoxByBasePointAndSize(areaSize, basePoint)).filter(box -> NetherPortalMatcher.isAirCubeMediumPlace(world, box)).findFirst().orElse(null);
    }

    static IntBox findHorizontalPortalPlacement(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int findingRadius) {
        IntBox result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 30, 8);
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 10, 8);
        }
        if (result == null) {
            result = NetherPortalMatcher.findHorizontalPortalPlacementWithVerticalSpaceReserved(areaSize, world, searchingCenter, 1, 8);
        }
        return result;
    }

    private static IntBox findHorizontalPortalPlacementWithVerticalSpaceReserved(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int verticalSpaceReserve, int findingRadius) {
        BlockPos growVertically = new BlockPos(areaSize.func_177958_n(), verticalSpaceReserve, areaSize.func_177952_p());
        IntBox foundCubeArea = NetherPortalMatcher.findCubeAirAreaAtAnywhere(growVertically, world, searchingCenter, findingRadius);
        if (foundCubeArea == null) {
            return null;
        }
        return foundCubeArea.getSubBoxInCenter(areaSize);
    }

    private static boolean isAirOnGround(IWorld world, BlockPos blockPos) {
        if (world.func_175623_d(blockPos)) {
            BlockPos belowPos = blockPos.func_177982_a(0, -1, 0);
            return !world.func_175623_d(belowPos);
        }
        return false;
    }

    static IntBox findCubeAirAreaAtAnywhere(BlockPos areaSize, IWorld world, BlockPos searchingCenter, int findingRadius) {
        return NetherPortalGeneration.fromNearToFarColumned((ServerWorld)world, searchingCenter.func_177958_n(), searchingCenter.func_177952_p(), findingRadius).map(basePoint -> IntBox.getBoxByBasePointAndSize(areaSize, basePoint)).filter(box -> NetherPortalMatcher.isAirCubeMediumPlace(world, box)).findFirst().orElse(null);
    }

    public static boolean isAirCubeMediumPlace(IWorld world, IntBox box) {
        if (box.h.func_177956_o() + 5 >= ((World)world).func_234938_ad_()) {
            return false;
        }
        if (box.l.func_177956_o() - 5 <= 0) {
            return false;
        }
        return NetherPortalMatcher.isAllAir(world, box);
    }

    public static boolean isAllAir(IWorld world, IntBox box) {
        boolean roughTest = Arrays.stream(box.getEightVertices()).allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
        if (!roughTest) {
            return false;
        }
        return box.stream().allMatch(blockPos -> NetherPortalMatcher.isAir(world, blockPos));
    }

    public static IntBox levitateBox(IWorld world, IntBox airCube, int maxOffset) {
        Integer maxUpShift = Helper.getLastSatisfying(IntStream.range(1, maxOffset * 3 / 2).boxed(), upShift -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new Vector3i(0, upShift.intValue(), 0))));
        if (maxUpShift == null) {
            maxUpShift = 0;
        }
        return airCube.getMoved(new Vector3i(0, maxUpShift * 2 / 3, 0));
    }

    public static IntBox pushDownBox(IWorld world, IntBox airCube) {
        Integer downShift = Helper.getLastSatisfying(IntStream.range(0, 40).boxed(), i -> NetherPortalMatcher.isAirCubeMediumPlace(world, airCube.getMoved(new Vector3i(0, -i.intValue(), 0))));
        if (downShift == null) {
            downShift = 0;
        }
        return airCube.getMoved(new Vector3i(0, -downShift.intValue(), 0));
    }
}

