/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.nether_portal;

import com.google.common.collect.Streams;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.my_util.LimitedLogger;
import com.qouteall.immersive_portals.portal.LoadingIndicatorEntity;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalPlaceholderBlock;
import com.qouteall.immersive_portals.portal.custom_portal_gen.PortalGenInfo;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import com.qouteall.immersive_portals.portal.nether_portal.BreakablePortalEntity;
import com.qouteall.immersive_portals.portal.nether_portal.FrameSearching;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalEntity;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalMatcher;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;

public class NetherPortalGeneration {
    public static final int randomShiftFactor = 20;
    private static final LimitedLogger limitedLogger = new LimitedLogger(300);

    public static BlockPos getRandomShift() {
        Random rand = new Random();
        return new BlockPos((rand.nextDouble() * 2.0 - 1.0) * 20.0, (rand.nextDouble() * 2.0 - 1.0) * 20.0, (rand.nextDouble() * 2.0 - 1.0) * 20.0);
    }

    public static IntBox findAirCubePlacement(ServerWorld toWorld, BlockPos mappedPosInOtherDimension, Direction.Axis axis, BlockPos neededAreaSize, int findingRadius) {
        IntBox foundAirCube;
        IntBox intBox = foundAirCube = axis == Direction.Axis.Y ? NetherPortalMatcher.findHorizontalPortalPlacement(neededAreaSize, (IWorld)toWorld, mappedPosInOtherDimension, findingRadius) : NetherPortalMatcher.findVerticalPortalPlacement(neededAreaSize, (IWorld)toWorld, mappedPosInOtherDimension, findingRadius);
        if (foundAirCube == null) {
            Helper.log("Cannot find normal portal placement");
            foundAirCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(neededAreaSize, (IWorld)toWorld, mappedPosInOtherDimension, 10);
            if (foundAirCube != null) {
                foundAirCube = NetherPortalMatcher.levitateBox((IWorld)toWorld, foundAirCube, 50);
            }
        }
        if (foundAirCube == null) {
            Helper.log("Cannot find air cube within 10 blocks");
            foundAirCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(neededAreaSize, (IWorld)toWorld, mappedPosInOtherDimension, 16);
        }
        if (foundAirCube == null) {
            Helper.err("Cannot find air cube within 16 blocks? Force placed portal. It will occupy normal blocks.");
            foundAirCube = IntBox.getBoxByBasePointAndSize(neededAreaSize, mappedPosInOtherDimension);
        }
        return foundAirCube;
    }

    public static RegistryKey<World> getDestinationDimension(RegistryKey<World> fromDimension) {
        if (fromDimension == World.field_234919_h_) {
            return World.field_234918_g_;
        }
        if (fromDimension == World.field_234920_i_) {
            return null;
        }
        return World.field_234919_h_;
    }

    public static BlockPos mapPosition(BlockPos pos, RegistryKey<World> dimensionFrom, RegistryKey<World> dimensionTo) {
        if (dimensionFrom == World.field_234918_g_ && dimensionTo == World.field_234919_h_) {
            return new BlockPos((double)Math.round((double)pos.func_177958_n() / 8.0), (double)pos.func_177956_o(), (double)Math.round((double)pos.func_177952_p() / 8.0));
        }
        if (dimensionFrom == World.field_234919_h_ && dimensionTo == World.field_234918_g_) {
            return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o(), pos.func_177952_p() * 8);
        }
        return pos;
    }

    public static void setPortalContentBlock(ServerWorld world, BlockPos pos, Direction.Axis normalAxis) {
        world.func_180501_a(pos, (BlockState)PortalPlaceholderBlock.instance.func_176223_P().func_206870_a(PortalPlaceholderBlock.AXIS, (Comparable)normalAxis), 3);
    }

    public static BreakablePortalEntity[] generateBreakablePortalEntitiesAndPlaceholder(PortalGenInfo info, EntityType<? extends BreakablePortalEntity> entityType) {
        ServerWorld fromWorld = McHelper.getServer().func_71218_a(info.from);
        ServerWorld toWorld = McHelper.getServer().func_71218_a(info.to);
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, info.fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, info.toShape);
        BreakablePortalEntity[] portalArray = new BreakablePortalEntity[]{(BreakablePortalEntity)entityType.func_200721_a((World)fromWorld), (BreakablePortalEntity)entityType.func_200721_a((World)fromWorld), (BreakablePortalEntity)entityType.func_200721_a((World)toWorld), (BreakablePortalEntity)entityType.func_200721_a((World)toWorld)};
        info.fromShape.initPortalPosAxisShape(portalArray[0], false);
        info.fromShape.initPortalPosAxisShape(portalArray[1], true);
        info.toShape.initPortalPosAxisShape(portalArray[2], false);
        info.toShape.initPortalPosAxisShape(portalArray[3], true);
        portalArray[0].dimensionTo = info.to;
        portalArray[1].dimensionTo = info.to;
        portalArray[2].dimensionTo = info.from;
        portalArray[3].dimensionTo = info.from;
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)info.toShape.innerAreaBox.l.func_177973_b((Vector3i)info.fromShape.innerAreaBox.l));
        portalArray[0].destination = portalArray[0].func_213303_ch().func_178787_e(offset);
        portalArray[1].destination = portalArray[1].func_213303_ch().func_178787_e(offset);
        portalArray[2].destination = portalArray[2].func_213303_ch().func_178788_d(offset);
        portalArray[3].destination = portalArray[3].func_213303_ch().func_178788_d(offset);
        portalArray[0].blockPortalShape = info.fromShape;
        portalArray[1].blockPortalShape = info.fromShape;
        portalArray[2].blockPortalShape = info.toShape;
        portalArray[3].blockPortalShape = info.toShape;
        portalArray[0].reversePortalId = portalArray[2].func_110124_au();
        portalArray[1].reversePortalId = portalArray[3].func_110124_au();
        portalArray[2].reversePortalId = portalArray[0].func_110124_au();
        portalArray[3].reversePortalId = portalArray[1].func_110124_au();
        fromWorld.func_217376_c((Entity)portalArray[0]);
        fromWorld.func_217376_c((Entity)portalArray[1]);
        toWorld.func_217376_c((Entity)portalArray[2]);
        toWorld.func_217376_c((Entity)portalArray[3]);
        return portalArray;
    }

    public static boolean onFireLitOnObsidian(ServerWorld fromWorld, BlockPos firePos) {
        BlockPortalShape thisSideShape;
        RegistryKey fromDimension = fromWorld.func_234923_W_();
        RegistryKey<World> toDimension = NetherPortalGeneration.getDestinationDimension((RegistryKey<World>)fromDimension);
        if (toDimension == null) {
            return false;
        }
        ServerWorld toWorld = McHelper.getServer().func_71218_a(toDimension);
        int searchingRadius = Global.netherPortalFindingRadius;
        if (Global.reversibleNetherPortalLinking && fromDimension == World.field_234918_g_) {
            searchingRadius /= 8;
        }
        return (thisSideShape = NetherPortalGeneration.triggerGeneratingPortal(fromWorld, firePos, toWorld, searchingRadius, searchingRadius - 10, fromPos1 -> NetherPortalGeneration.mapPosition(fromPos1, (RegistryKey<World>)fromWorld.func_234923_W_(), (RegistryKey<World>)toWorld.func_234923_W_()), NetherPortalMatcher::isAirOrFire, O_O::isObsidian, AbstractBlock.AbstractBlockState::func_196958_f, O_O::isObsidian, shape -> NetherPortalGeneration.embodyNewFrame(toWorld, shape, Blocks.field_150343_Z.func_176223_P()), info -> NetherPortalGeneration.generateBreakablePortalEntitiesAndPlaceholder(info, NetherPortalEntity.entityType))) != null;
    }

    public static boolean activatePortalHelper(ServerWorld fromWorld, BlockPos firePos) {
        Helper.SimpleBox<Object> thisSideShape = new Helper.SimpleBox<Object>(null);
        thisSideShape.obj = NetherPortalGeneration.triggerGeneratingPortal(fromWorld, firePos, fromWorld, Global.netherPortalFindingRadius, Global.netherPortalFindingRadius, fromPos1 -> NetherPortalGeneration.getRandomShift().func_177971_a((Vector3i)fromPos1), NetherPortalMatcher::isAirOrFire, blockState -> blockState.func_177230_c() == ModMain.portalHelperBlock, AbstractBlock.AbstractBlockState::func_196958_f, blockState -> blockState.func_177230_c() == ModMain.portalHelperBlock, toShape -> NetherPortalGeneration.embodyNewFrame(fromWorld, toShape, ModMain.portalHelperBlock.func_176223_P()), info -> {
            NetherPortalGeneration.generateHelperPortalEntities(info);
            info.fromShape.frameAreaWithCorner.forEach(blockPos -> {
                if (fromWorld.func_180495_p(blockPos).func_177230_c() == ModMain.portalHelperBlock) {
                    fromWorld.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
            });
        });
        return thisSideShape.obj != null;
    }

    public static BlockPortalShape triggerGeneratingPortal(ServerWorld fromWorld, BlockPos startingPos, ServerWorld toWorld, int existingFrameSearchingRadius, int airCubeSearchingRadius, Function<BlockPos, BlockPos> positionMapping, Predicate<BlockState> thisSideAreaPredicate, Predicate<BlockState> thisSideFramePredicate, Predicate<BlockState> otherSideAreaPredicate, Predicate<BlockState> otherSideFramePredicate, Consumer<BlockPortalShape> newFrameGenerateFunc, Consumer<PortalGenInfo> portalEntityGeneratingFunc) {
        if (!NetherPortalGeneration.checkPortalGeneration(fromWorld, startingPos)) {
            return null;
        }
        if (!thisSideAreaPredicate.test(fromWorld.func_180495_p(startingPos))) {
            return null;
        }
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startingPos, thisSideAreaPredicate, thisSideFramePredicate);
        if (fromShape == null) {
            return null;
        }
        BlockPos toPos = positionMapping.apply(fromShape.innerAreaBox.getCenter());
        if (NetherPortalGeneration.isOtherGenerationRunning(fromWorld, fromShape.innerAreaBox.getCenterVec())) {
            return null;
        }
        Helper.log(fromShape.totalAreaBox);
        NetherPortalGeneration.startGeneratingPortal(fromWorld, toWorld, fromShape, fromShape, toPos, existingFrameSearchingRadius, otherSideAreaPredicate, otherSideFramePredicate, newFrameGenerateFunc, portalEntityGeneratingFunc, () -> {
            IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, fromShape.axis, fromShape.totalAreaBox.getSize(), airCubeSearchingRadius);
            Helper.log("Found Placement " + airCubePlacement);
            boolean checkAirCube = airCubePlacement.fastStream().allMatch(b -> toWorld.func_180495_p(b).func_196958_f());
            if (!checkAirCube) {
                Helper.err("Invalid portal placement");
                airCubePlacement = airCubePlacement.getMoved(BlockPos.field_177959_e.func_177967_a(Direction.UP, airCubePlacement.getSize().func_177956_o()));
            }
            if (!fromShape.totalAreaBox.getSize().equals((Object)airCubePlacement.getSize())) {
                Helper.err("Portal placement size abnormal");
            }
            BlockPortalShape toShape = fromShape.getShapeWithMovedAnchor(airCubePlacement.l.func_177973_b((Vector3i)fromShape.totalAreaBox.l).func_177971_a((Vector3i)fromShape.anchor));
            return toShape;
        }, () -> fromShape.isPortalIntact(blockPos -> thisSideAreaPredicate.test(fromWorld.func_180495_p(blockPos)), blockPos -> thisSideFramePredicate.test(fromWorld.func_180495_p(blockPos))), s -> fromWorld != toWorld || fromShape.anchor != s.anchor);
        return fromShape;
    }

    public static void startGeneratingPortal(ServerWorld fromWorld, ServerWorld toWorld, BlockPortalShape fromShape, BlockPortalShape templateToShape, BlockPos toPos, int existingFrameSearchingRadius, Predicate<BlockState> otherSideAreaPredicate, Predicate<BlockState> otherSideFramePredicate, Consumer<BlockPortalShape> newFrameGenerateFunc, Consumer<PortalGenInfo> portalEntityGeneratingFunc, Supplier<BlockPortalShape> newFramePlacer, BooleanSupplier portalIntegrityChecker, Predicate<BlockPortalShape> foundShapePredicate) {
        boolean shouldSkip;
        RegistryKey fromDimension = fromWorld.func_234923_W_();
        RegistryKey toDimension = toWorld.func_234923_W_();
        Vector3d indicatorPos = fromShape.innerAreaBox.getCenterVec();
        LoadingIndicatorEntity indicatorEntity = (LoadingIndicatorEntity)LoadingIndicatorEntity.entityType.func_200721_a((World)fromWorld);
        indicatorEntity.isValid = true;
        indicatorEntity.portalShape = fromShape;
        indicatorEntity.func_70107_b(indicatorPos.field_72450_a, indicatorPos.field_72448_b, indicatorPos.field_72449_c);
        fromWorld.func_217376_c((Entity)indicatorEntity);
        Runnable onGenerateNewFrame = () -> {
            indicatorEntity.inform((ITextComponent)new TranslationTextComponent("imm_ptl.generating_new_frame"));
            BlockPortalShape placedShape = (BlockPortalShape)newFramePlacer.get();
            if (placedShape != null) {
                newFrameGenerateFunc.accept(placedShape);
                PortalGenInfo info = new PortalGenInfo((RegistryKey<World>)fromDimension, (RegistryKey<World>)toWorld.func_234923_W_(), fromShape, placedShape);
                portalEntityGeneratingFunc.accept(info);
                O_O.postPortalSpawnEventForge(info);
            }
        };
        boolean bl = shouldSkip = !McHelper.getIEStorage((RegistryKey<World>)toDimension).portal_isChunkGenerated(new ChunkPos(toPos));
        if (shouldSkip) {
            Helper.log("Skip Portal Frame Searching Because The Region is not Generated");
            onGenerateNewFrame.run();
            indicatorEntity.func_70106_y();
            return;
        }
        int loaderRadius = Math.floorDiv(existingFrameSearchingRadius, 16) + 1;
        ChunkVisibilityManager.ChunkLoader chunkLoader = new ChunkVisibilityManager.ChunkLoader(new DimensionalChunkPos((RegistryKey<World>)toDimension, new ChunkPos(toPos)), loaderRadius);
        NewChunkTrackingGraph.addAdditionalChunkLoader(chunkLoader);
        Runnable finalizer = () -> {
            indicatorEntity.func_70106_y();
            NewChunkTrackingGraph.removeAdditionalChunkLoader(chunkLoader);
        };
        ModMain.serverTaskList.addTask(() -> {
            boolean isPortalIntact = portalIntegrityChecker.getAsBoolean();
            if (!isPortalIntact) {
                finalizer.run();
                return true;
            }
            int[] loadedChunkNum = new int[]{0};
            chunkLoader.foreachChunkPos((dim, x, z, dist) -> {
                Chunk chunk = McHelper.getServerChunkIfPresent((RegistryKey<World>)dim, x, z);
                if (chunk != null) {
                    loadedChunkNum[0] = loadedChunkNum[0] + 1;
                }
            });
            int allChunksNeedsLoading = (loaderRadius * 2 + 1) * (loaderRadius * 2 + 1);
            if (allChunksNeedsLoading > loadedChunkNum[0]) {
                indicatorEntity.inform((ITextComponent)new TranslationTextComponent("imm_ptl.loading_chunks", new Object[]{loadedChunkNum[0], allChunksNeedsLoading}));
                return false;
            }
            WorldGenRegion chunkRegion = chunkLoader.createChunkRegion();
            indicatorEntity.inform((ITextComponent)new TranslationTextComponent("imm_ptl.searching_for_frame"));
            FrameSearching.startSearchingPortalFrameAsync(chunkRegion, loaderRadius, toPos, templateToShape, otherSideAreaPredicate, otherSideFramePredicate, foundShapePredicate, shape -> {
                PortalGenInfo info = new PortalGenInfo((RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension, fromShape, (BlockPortalShape)shape);
                portalEntityGeneratingFunc.accept(info);
                finalizer.run();
            }, () -> {
                onGenerateNewFrame.run();
                finalizer.run();
            });
            return true;
        });
    }

    public static boolean isOtherGenerationRunning(ServerWorld fromWorld, Vector3d indicatorPos) {
        boolean isOtherGenerationRunning = McHelper.getEntitiesNearby((World)fromWorld, indicatorPos, LoadingIndicatorEntity.class, 1.0).findAny().isPresent();
        if (isOtherGenerationRunning) {
            Helper.log("Aborted Portal Generation Because Another Generation is Running Nearby");
            return true;
        }
        return false;
    }

    public static boolean checkPortalGeneration(ServerWorld fromWorld, BlockPos startingPos) {
        if (!fromWorld.func_175667_e(startingPos)) {
            Helper.log("Cancel Portal Generation Because Chunk Not Loaded");
            return false;
        }
        limitedLogger.log(String.format("Portal Generation Attempted %s %s %s %s", fromWorld.func_234923_W_().func_240901_a_(), startingPos.func_177958_n(), startingPos.func_177956_o(), startingPos.func_177952_p()));
        return true;
    }

    public static BlockPortalShape findFrameShape(ServerWorld fromWorld, BlockPos startingPos, Predicate<BlockState> thisSideAreaPredicate, Predicate<BlockState> thisSideFramePredicate) {
        return Arrays.stream(Direction.Axis.values()).map(axis -> BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, pos -> thisSideAreaPredicate.test(fromWorld.func_180495_p(pos)), pos -> thisSideFramePredicate.test(fromWorld.func_180495_p(pos)))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Stream<BlockPos> blockPosStreamNaive(ServerWorld toWorld, int x, int z, int raidus) {
        Stream blockPosStream = BlockPos.func_218281_b((BlockPos)new BlockPos(x - raidus, 3, z - raidus), (BlockPos)new BlockPos(x + raidus, toWorld.func_234938_ad_() - 3, z + raidus));
        return blockPosStream;
    }

    public static void embodyNewFrame(ServerWorld toWorld, BlockPortalShape toShape, BlockState frameBlockState) {
        toShape.frameAreaWithCorner.forEach(blockPos -> toWorld.func_175656_a(blockPos, frameBlockState));
    }

    public static void fillInPlaceHolderBlocks(ServerWorld world, BlockPortalShape blockPortalShape) {
        blockPortalShape.area.forEach(blockPos -> NetherPortalGeneration.setPortalContentBlock(world, blockPos, blockPortalShape.axis));
    }

    private static void generateHelperPortalEntities(PortalGenInfo info) {
        ServerWorld fromWorld1 = McHelper.getServer().func_71218_a(info.from);
        ServerWorld toWorld = McHelper.getServer().func_71218_a(info.to);
        Portal[] portalArray = new Portal[]{(Portal)Portal.entityType.func_200721_a((World)fromWorld1), (Portal)Portal.entityType.func_200721_a((World)fromWorld1), (Portal)Portal.entityType.func_200721_a((World)toWorld), (Portal)Portal.entityType.func_200721_a((World)toWorld)};
        info.fromShape.initPortalPosAxisShape(portalArray[0], false);
        info.fromShape.initPortalPosAxisShape(portalArray[1], true);
        info.toShape.initPortalPosAxisShape(portalArray[2], false);
        info.toShape.initPortalPosAxisShape(portalArray[3], true);
        portalArray[0].dimensionTo = info.to;
        portalArray[1].dimensionTo = info.to;
        portalArray[2].dimensionTo = info.from;
        portalArray[3].dimensionTo = info.from;
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)info.toShape.innerAreaBox.l.func_177973_b((Vector3i)info.fromShape.innerAreaBox.l));
        portalArray[0].destination = portalArray[0].func_213303_ch().func_178787_e(offset);
        portalArray[1].destination = portalArray[1].func_213303_ch().func_178787_e(offset);
        portalArray[2].destination = portalArray[2].func_213303_ch().func_178788_d(offset);
        portalArray[3].destination = portalArray[3].func_213303_ch().func_178788_d(offset);
        fromWorld1.func_217376_c((Entity)portalArray[0]);
        fromWorld1.func_217376_c((Entity)portalArray[1]);
        toWorld.func_217376_c((Entity)portalArray[2]);
        toWorld.func_217376_c((Entity)portalArray[3]);
    }

    public static Stream<BlockPos> fromNearToFarColumned(ServerWorld world, int x, int z, int range) {
        if (range < 0) {
            range = 5;
        }
        if (Global.blameOpenJdk) {
            return NetherPortalGeneration.blockPosStreamNaive(world, x, z, range);
        }
        int height = world.func_234938_ad_();
        BlockPos.Mutable temp0 = new BlockPos.Mutable();
        BlockPos.Mutable temp2 = new BlockPos.Mutable();
        BlockPos.Mutable temp1 = new BlockPos.Mutable();
        return IntStream.range(0, range).boxed().flatMap(layer -> Streams.concat((Stream[])new Stream[]{IntStream.range(0, layer * 2 + 1).mapToObj(i -> new BlockPos(layer.intValue(), 0, i - layer)), IntStream.range(0, layer * 2 + 1).mapToObj(i -> new BlockPos(-layer.intValue(), 0, i - layer)), IntStream.range(0, layer * 2 - 1).mapToObj(i -> new BlockPos(i - layer + 1, 0, layer.intValue())), IntStream.range(0, layer * 2 - 1).mapToObj(i -> new BlockPos(i - layer + 1, 0, -layer.intValue()))}).map(columnPos_ -> new BlockPos(columnPos_.func_177958_n() + x, 0, columnPos_.func_177952_p() + z)).flatMap(columnPos_ -> IntStream.range(3, height - 3).mapToObj(y -> new BlockPos(columnPos_.func_177958_n(), y, columnPos_.func_177952_p()))));
    }
}

