/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.nether_portal;

import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;

public class FrameSearching {
    public static void startSearchingPortalFrameAsync(WorldGenRegion region, int regionRadius, BlockPos centerPoint, BlockPortalShape templateShape, Predicate<BlockState> areaPredicate, Predicate<BlockState> framePredicate, Predicate<BlockPortalShape> resultPredicate, Consumer<BlockPortalShape> onFound, Runnable onNotFound) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                BlockPortalShape result = FrameSearching.searchPortalFrame(region, regionRadius, centerPoint, templateShape, areaPredicate, framePredicate, resultPredicate);
                McHelper.getServer().execute(() -> {
                    if (result != null) {
                        onFound.accept(result);
                    } else {
                        onNotFound.run();
                    }
                });
            }
            catch (Throwable oops) {
                oops.printStackTrace();
                onNotFound.run();
            }
        }, Util.func_215072_e());
    }

    private static BlockPortalShape searchPortalFrame(WorldGenRegion region, int regionRadius, BlockPos centerPoint, BlockPortalShape templateShape, Predicate<BlockState> areaPredicate, Predicate<BlockState> framePredicate, Predicate<BlockPortalShape> resultPredicate) {
        ArrayList<IChunk> chunks = FrameSearching.getChunksFromNearToFar(region, centerPoint, regionRadius);
        BlockPos.Mutable temp = new BlockPos.Mutable();
        BlockPos.Mutable temp1 = new BlockPos.Mutable();
        for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
            IChunk chunk = chunks.get(chunkIndex);
            ChunkSection[] sectionArray = chunk.func_76587_i();
            for (int sectionY = 0; sectionY < sectionArray.length; ++sectionY) {
                ChunkSection chunkSection = sectionArray[sectionY];
                if (chunkSection == null) continue;
                for (int localY = 0; localY < 16; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            BlockState blockState = chunkSection.func_177485_a(localX, localY, localZ);
                            if (!framePredicate.test(blockState)) continue;
                            int worldX = localX + chunk.func_76632_l().func_180334_c();
                            int worldY = localY + sectionY * 16;
                            int worldZ = localZ + chunk.func_76632_l().func_180333_d();
                            temp.func_181079_c(worldX, worldY, worldZ);
                            BlockPortalShape result = templateShape.matchShapeWithMovedFirstFramePos(pos -> areaPredicate.test(region.func_180495_p(pos)), pos -> framePredicate.test(region.func_180495_p(pos)), (BlockPos)temp, temp1);
                            if (result == null || !resultPredicate.test(result)) continue;
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static ArrayList<IChunk> getChunksFromNearToFar(WorldGenRegion region, BlockPos centerPoint, int regionRadius) {
        ArrayList<IChunk> chunks = new ArrayList<IChunk>();
        int searchedRadius = regionRadius - 1;
        int centerX = region.func_201679_a();
        int centerZ = region.func_201680_b();
        for (int x = centerX - searchedRadius; x <= centerX + searchedRadius; ++x) {
            for (int z = centerZ - searchedRadius; z <= centerZ + searchedRadius; ++z) {
                chunks.add(region.func_212866_a_(x, z));
            }
        }
        chunks.sort(Comparator.comparingDouble(chunk -> chunk.func_76632_l().func_206849_h().func_177951_i((Vector3i)centerPoint)));
        return chunks;
    }
}

