/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.nether_portal;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalPlaceholderBlock;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;

public abstract class BreakablePortalEntity
extends Portal {
    public BlockPortalShape blockPortalShape;
    public UUID reversePortalId;
    public boolean unbreakable = false;
    private boolean isNotified = true;
    private boolean shouldBreakPortal = false;

    public BreakablePortalEntity(EntityType<?> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    @Override
    public boolean isPortalValid() {
        if (this.field_70170_p.field_72995_K) {
            return super.isPortalValid();
        }
        return super.isPortalValid() && this.blockPortalShape != null && this.reversePortalId != null;
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundTag) {
        super.func_70037_a(compoundTag);
        if (compoundTag.func_74764_b("netherPortalShape")) {
            this.blockPortalShape = new BlockPortalShape(compoundTag.func_74775_l("netherPortalShape"));
        }
        this.reversePortalId = Helper.getUuid(compoundTag, "reversePortalId");
        this.unbreakable = compoundTag.func_74767_n("unbreakable");
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundTag) {
        super.func_213281_b(compoundTag);
        if (this.blockPortalShape != null) {
            compoundTag.func_218657_a("netherPortalShape", (INBT)this.blockPortalShape.toTag());
        }
        Helper.putUuid(compoundTag, "reversePortalId", this.reversePortalId);
        compoundTag.func_74757_a("unbreakable", this.unbreakable);
    }

    private void breakPortalOnThisSide() {
        this.blockPortalShape.area.forEach(blockPos -> {
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == PortalPlaceholderBlock.instance) {
                this.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
        });
        this.func_70106_y();
        Helper.log("Broke " + (Object)((Object)this));
    }

    public void notifyPlaceholderUpdate() {
        this.isNotified = true;
    }

    private BreakablePortalEntity getReversePortal() {
        ServerWorld world = this.func_184102_h().func_71218_a(this.dimensionTo);
        Entity entity = world.func_217461_a(this.reversePortalId);
        if (entity instanceof BreakablePortalEntity) {
            return (BreakablePortalEntity)entity;
        }
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.addSoundAndParticle();
        } else if (!this.unbreakable) {
            if (this.isNotified || this.field_70170_p.func_82737_E() % 233L == (long)(this.func_145782_y() % 233)) {
                this.isNotified = false;
                this.checkPortalIntegrity();
            }
            if (this.shouldBreakPortal) {
                this.breakPortalOnThisSide();
            }
        }
    }

    private void checkPortalIntegrity() {
        Validate.isTrue((!this.field_70170_p.field_72995_K ? 1 : 0) != 0);
        if (!this.isPortalValid()) {
            this.func_70106_y();
            return;
        }
        if (!this.isPortalIntactOnThisSide()) {
            this.markShouldBreak();
        } else if (!this.isPortalPaired()) {
            Helper.err("Break portal because of abnormal pairing");
            this.markShouldBreak();
        }
    }

    protected abstract boolean isPortalIntactOnThisSide();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void addSoundAndParticle();

    public boolean isPortalPaired() {
        Validate.isTrue((!this.field_70170_p.func_201670_d() ? 1 : 0) != 0);
        List<BreakablePortalEntity> reversePortal = McHelper.findEntitiesByBox(BreakablePortalEntity.class, this.getDestinationWorld(), new AxisAlignedBB(new BlockPos(this.destination)), 10.0, e -> e.func_213303_ch().func_72436_e(this.destination) < 0.01 && e.getContentDirection().func_72430_b(this.getNormal()) > 0.6);
        return reversePortal.size() <= 1;
    }

    public void markShouldBreak() {
        this.shouldBreakPortal = true;
        BreakablePortalEntity reversePortal = this.getReversePortal();
        if (reversePortal != null) {
            reversePortal.shouldBreakPortal = true;
        } else {
            ModMain.serverTaskList.addTask(() -> {
                BreakablePortalEntity reversePortal1 = this.getReversePortal();
                if (reversePortal1 != null) {
                    reversePortal1.shouldBreakPortal = true;
                }
                return true;
            });
        }
    }
}

