/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.nether_portal;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.GeometryPortalShape;
import com.qouteall.immersive_portals.portal.Portal;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.Validate;

public class BlockPortalShape {
    public BlockPos anchor;
    public Set<BlockPos> area;
    public IntBox innerAreaBox;
    public IntBox totalAreaBox;
    public Direction.Axis axis;
    public Set<BlockPos> frameAreaWithoutCorner;
    public Set<BlockPos> frameAreaWithCorner;
    private BlockPos firstFramePos;

    public BlockPortalShape(Set<BlockPos> area, Direction.Axis axis) {
        this.area = area;
        this.axis = axis;
        this.calcAnchor();
        this.calcFrameArea();
        this.calcAreaBox();
    }

    public BlockPortalShape(CompoundNBT tag) {
        this(BlockPortalShape.readArea(tag.func_150295_c("poses", 3)), Direction.Axis.values()[tag.func_74762_e("axis")]);
    }

    private static Set<BlockPos> readArea(ListNBT list) {
        int size = list.size();
        Validate.isTrue((size % 3 == 0 ? 1 : 0) != 0);
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int i = 0; i < size / 3; ++i) {
            result.add(new BlockPos(list.func_186858_c(i * 3 + 0), list.func_186858_c(i * 3 + 1), list.func_186858_c(i * 3 + 2)));
        }
        return result;
    }

    public CompoundNBT toTag() {
        CompoundNBT data = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.area.forEach(blockPos -> {
            list.add(list.size(), (INBT)IntNBT.func_229692_a_((int)blockPos.func_177958_n()));
            list.add(list.size(), (INBT)IntNBT.func_229692_a_((int)blockPos.func_177956_o()));
            list.add(list.size(), (INBT)IntNBT.func_229692_a_((int)blockPos.func_177952_p()));
        });
        data.func_218657_a("poses", (INBT)list);
        data.func_74768_a("axis", this.axis.ordinal());
        return data;
    }

    public void calcAnchor() {
        this.anchor = this.area.stream().min(Comparator.comparingInt(Vector3i::func_177958_n).thenComparingInt(Vector3i::func_177956_o).thenComparingInt(Vector3i::func_177952_p)).get();
        Validate.notNull((Object)this.anchor);
    }

    public void calcAreaBox() {
        this.innerAreaBox = Helper.reduce(new IntBox(this.anchor, this.anchor), this.area.stream(), IntBox::getExpanded);
        this.totalAreaBox = Helper.reduce(new IntBox(this.anchor, this.anchor), this.frameAreaWithoutCorner.stream(), IntBox::getExpanded);
    }

    public void calcFrameArea() {
        Direction[] directions = Helper.getAnotherFourDirections(this.axis);
        this.frameAreaWithoutCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.func_177971_a(directions[0].func_176730_m()), blockPos.func_177971_a(directions[1].func_176730_m()), blockPos.func_177971_a(directions[2].func_176730_m()), blockPos.func_177971_a(directions[3].func_176730_m()))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        BlockPos[] cornerOffsets = new BlockPos[]{new BlockPos(directions[0].func_176730_m()).func_177971_a(directions[1].func_176730_m()), new BlockPos(directions[1].func_176730_m()).func_177971_a(directions[2].func_176730_m()), new BlockPos(directions[2].func_176730_m()).func_177971_a(directions[3].func_176730_m()), new BlockPos(directions[3].func_176730_m()).func_177971_a(directions[0].func_176730_m())};
        this.frameAreaWithCorner = this.area.stream().flatMap(blockPos -> Stream.of(blockPos.func_177971_a((Vector3i)cornerOffsets[0]), blockPos.func_177971_a((Vector3i)cornerOffsets[1]), blockPos.func_177971_a((Vector3i)cornerOffsets[2]), blockPos.func_177971_a((Vector3i)cornerOffsets[3]))).filter(blockPos -> !this.area.contains(blockPos)).collect(Collectors.toSet());
        this.frameAreaWithCorner.addAll(this.frameAreaWithoutCorner);
        this.firstFramePos = this.frameAreaWithoutCorner.iterator().next();
    }

    public static BlockPortalShape findArea(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        if (!isAir.test(startingPos)) {
            return null;
        }
        return BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, isAir, isObsidian);
    }

    public static BlockPortalShape findShapeWithoutRegardingStartingPos(BlockPos startingPos, Direction.Axis axis, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian) {
        startingPos = startingPos.func_185334_h();
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        area.add(startingPos);
        Direction[] directions = Helper.getAnotherFourDirections(axis);
        boolean isNormalFrame = BlockPortalShape.findAreaBreadthFirst(startingPos, isAir, isObsidian, directions, area, startingPos);
        if (!isNormalFrame) {
            return null;
        }
        return new BlockPortalShape(area, axis);
    }

    private static boolean findAreaBreadthFirst(BlockPos startingPos, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, Direction[] directions, Set<BlockPos> foundArea, BlockPos initialPos) {
        ArrayDeque<BlockPos> newlyAdded = new ArrayDeque<BlockPos>();
        newlyAdded.addLast(startingPos);
        while (!newlyAdded.isEmpty()) {
            if (foundArea.size() > 400) {
                return false;
            }
            BlockPos last = (BlockPos)newlyAdded.pollFirst();
            for (Direction direction : directions) {
                BlockPos curr = last.func_177972_a(direction).func_185334_h();
                if (foundArea.contains(curr)) continue;
                if (isAir.test(curr)) {
                    newlyAdded.addLast(curr);
                    foundArea.add(curr);
                    continue;
                }
                if (isObsidian.test(curr)) continue;
                return false;
            }
            BlockPos delta = initialPos.func_177973_b((Vector3i)startingPos);
            if (Math.abs(delta.func_177958_n()) <= 20 && Math.abs(delta.func_177956_o()) <= 20 && Math.abs(delta.func_177952_p()) <= 20) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    private static boolean findAreaRecursively(BlockPos currPos, Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, Direction[] directions, Set<BlockPos> foundArea, BlockPos initialPos) {
        if (foundArea.size() > 400) {
            return false;
        }
        BlockPos delta = initialPos.func_177973_b((Vector3i)currPos);
        if (Math.abs(delta.func_177958_n()) > 20 || Math.abs(delta.func_177956_o()) > 20 || Math.abs(delta.func_177952_p()) > 20) {
            return false;
        }
        for (Direction direction : directions) {
            BlockPos newPos = currPos.func_177971_a(direction.func_176730_m());
            if (foundArea.contains(newPos)) continue;
            if (isAir.test(newPos)) {
                foundArea.add(newPos.func_185334_h());
                boolean shouldContinue = BlockPortalShape.findAreaRecursively(newPos, isAir, isObsidian, directions, foundArea, initialPos);
                if (shouldContinue) continue;
                return false;
            }
            if (isObsidian.test(newPos)) continue;
            return false;
        }
        return true;
    }

    public BlockPortalShape matchShape(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.Mutable temp) {
        if (!isAir.test(newAnchor)) {
            return null;
        }
        boolean testFrame = this.testFrameWithoutCorner(isObsidian, newAnchor, temp);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.func_181079_c(blockPos.func_177958_n() - this.anchor.func_177958_n() + newAnchor.func_177958_n(), blockPos.func_177956_o() - this.anchor.func_177956_o() + newAnchor.func_177956_o(), blockPos.func_177952_p() - this.anchor.func_177952_p() + newAnchor.func_177952_p())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        return this.getShapeWithMovedAnchor(newAnchor);
    }

    private boolean testFrameWithoutCorner(Predicate<BlockPos> isObsidian, BlockPos newAnchor, BlockPos.Mutable temp) {
        Function<BlockPos, BlockPos.Mutable> mapper = blockPos -> temp.func_181079_c(blockPos.func_177958_n() - this.anchor.func_177958_n() + newAnchor.func_177958_n(), blockPos.func_177956_o() - this.anchor.func_177956_o() + newAnchor.func_177956_o(), blockPos.func_177952_p() - this.anchor.func_177952_p() + newAnchor.func_177952_p());
        if (!isObsidian.test((BlockPos)mapper.apply(this.firstFramePos))) {
            return false;
        }
        return this.frameAreaWithoutCorner.stream().map(mapper).allMatch(isObsidian);
    }

    public BlockPortalShape getShapeWithMovedAnchor(BlockPos newAnchor) {
        BlockPos offset = newAnchor.func_177973_b((Vector3i)this.anchor);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.func_177971_a((Vector3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public boolean isFrameIntact(Predicate<BlockPos> isObsidian) {
        return this.frameAreaWithoutCorner.stream().allMatch(isObsidian::test);
    }

    public boolean isPortalIntact(Predicate<BlockPos> isPortalBlock, Predicate<BlockPos> isObsidian) {
        return this.isFrameIntact(isObsidian) && this.area.stream().allMatch(isPortalBlock);
    }

    public void initPortalPosAxisShape(Portal portal, boolean doInvert) {
        Direction hDirection;
        Direction wDirection;
        Vector3d center = this.innerAreaBox.getCenterVec();
        portal.func_70107_b(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        IntBox rectanglePart = Helper.expandRectangle(this.anchor, blockPos -> this.area.contains(blockPos), this.axis);
        Direction[] anotherFourDirections = Helper.getAnotherFourDirections(this.axis);
        if (doInvert) {
            wDirection = anotherFourDirections[0];
            hDirection = anotherFourDirections[1];
        } else {
            wDirection = anotherFourDirections[1];
            hDirection = anotherFourDirections[0];
        }
        portal.axisW = Vector3d.func_237491_b_((Vector3i)wDirection.func_176730_m());
        portal.axisH = Vector3d.func_237491_b_((Vector3i)hDirection.func_176730_m());
        portal.width = Helper.getCoordinate((Vector3i)this.innerAreaBox.getSize(), wDirection.func_176740_k());
        portal.height = Helper.getCoordinate((Vector3i)this.innerAreaBox.getSize(), hDirection.func_176740_k());
        GeometryPortalShape shape = new GeometryPortalShape();
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).func_176730_m()).func_186678_a(0.5);
        Stream.concat(this.area.stream().filter(blockPos -> !rectanglePart.contains((BlockPos)blockPos)).map(blockPos -> new IntBox((BlockPos)blockPos, (BlockPos)blockPos)), Stream.of(rectanglePart)).forEach(part -> {
            Vector3d p1 = Vector3d.func_237491_b_((Vector3i)part.l).func_178787_e(offset);
            Vector3d p2 = Vector3d.func_237491_b_((Vector3i)part.h).func_72441_c(1.0, 1.0, 1.0).func_178787_e(offset);
            double p1LocalX = p1.func_178788_d(center).func_72430_b(portal.axisW);
            double p1LocalY = p1.func_178788_d(center).func_72430_b(portal.axisH);
            double p2LocalX = p2.func_178788_d(center).func_72430_b(portal.axisW);
            double p2LocalY = p2.func_178788_d(center).func_72430_b(portal.axisH);
            shape.addTriangleForRectangle(p1LocalX, p1LocalY, p2LocalX, p2LocalY);
        });
        portal.specialShape = shape;
        Vector3d p1 = Vector3d.func_237491_b_((Vector3i)rectanglePart.l).func_178787_e(offset);
        Vector3d p2 = Vector3d.func_237491_b_((Vector3i)rectanglePart.h).func_72441_c(1.0, 1.0, 1.0).func_178787_e(offset);
        double p1LocalX = p1.func_178788_d(center).func_72430_b(portal.axisW);
        double p1LocalY = p1.func_178788_d(center).func_72430_b(portal.axisH);
        double p2LocalX = p2.func_178788_d(center).func_72430_b(portal.axisW);
        double p2LocalY = p2.func_178788_d(center).func_72430_b(portal.axisH);
        portal.initCullableRange(p1LocalX, p2LocalX, p1LocalY, p2LocalY);
    }

    public BlockPortalShape matchShapeWithMovedFirstFramePos(Predicate<BlockPos> isAir, Predicate<BlockPos> isObsidian, BlockPos newFirstObsidianPos, BlockPos.Mutable temp) {
        boolean testFrame = this.frameAreaWithoutCorner.stream().map(blockPos1 -> temp.func_181079_c(blockPos1.func_177958_n() - this.firstFramePos.func_177958_n() + newFirstObsidianPos.func_177958_n(), blockPos1.func_177956_o() - this.firstFramePos.func_177956_o() + newFirstObsidianPos.func_177956_o(), blockPos1.func_177952_p() - this.firstFramePos.func_177952_p() + newFirstObsidianPos.func_177952_p())).allMatch(isObsidian);
        if (!testFrame) {
            return null;
        }
        boolean testAir = this.area.stream().map(blockPos -> temp.func_181079_c(blockPos.func_177958_n() - this.firstFramePos.func_177958_n() + newFirstObsidianPos.func_177958_n(), blockPos.func_177956_o() - this.firstFramePos.func_177956_o() + newFirstObsidianPos.func_177956_o(), blockPos.func_177952_p() - this.firstFramePos.func_177952_p() + newFirstObsidianPos.func_177952_p())).allMatch(isAir);
        if (!testAir) {
            return null;
        }
        BlockPos offset = newFirstObsidianPos.func_177973_b((Vector3i)this.firstFramePos);
        return new BlockPortalShape(this.area.stream().map(blockPos -> blockPos.func_177971_a((Vector3i)offset)).collect(Collectors.toSet()), this.axis);
    }

    public static boolean isSquareShape(BlockPortalShape shape, int length) {
        Tuple<Direction.Axis, Direction.Axis> xs;
        BlockPos areaSize = shape.innerAreaBox.getSize();
        return Helper.getCoordinate((Vector3i)areaSize, (Direction.Axis)(xs = Helper.getAnotherTwoAxis(shape.axis)).func_76341_a()) == length && Helper.getCoordinate((Vector3i)areaSize, (Direction.Axis)xs.func_76340_b()) == length && shape.area.size() == length * length;
    }

    public static BlockPortalShape getSquareShapeTemplate(Direction.Axis axis, int length) {
        Tuple<Direction, Direction> perpendicularDirections = Helper.getPerpendicularDirections(Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        HashSet<BlockPos> area = new HashSet<BlockPos>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                area.add(BlockPos.field_177992_a.func_177967_a((Direction)perpendicularDirections.func_76341_a(), i).func_177967_a((Direction)perpendicularDirections.func_76340_b(), j));
            }
        }
        return new BlockPortalShape(area, axis);
    }

    public BlockPortalShape getShapeWithMovedTotalAreaBox(IntBox newTotalAreaBox) {
        Validate.isTrue((boolean)this.totalAreaBox.getSize().equals((Object)newTotalAreaBox.getSize()));
        return this.getShapeWithMovedAnchor(newTotalAreaBox.l.func_177973_b((Vector3i)this.totalAreaBox.l).func_177971_a((Vector3i)this.anchor));
    }
}

