/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.global_portals;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldWrappingPortal
extends GlobalTrackedPortal {
    public static EntityType<WorldWrappingPortal> entityType;
    public boolean isInward = true;
    public int zoneId = -1;

    public WorldWrappingPortal(EntityType<?> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundTag) {
        super.func_70037_a(compoundTag);
        if (compoundTag.func_74764_b("isInward")) {
            this.isInward = compoundTag.func_74767_n("isInward");
        }
        if (compoundTag.func_74764_b("zoneId")) {
            this.zoneId = compoundTag.func_74762_e("zoneId");
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundTag) {
        super.func_213281_b(compoundTag);
        compoundTag.func_74757_a("isInward", this.isInward);
        compoundTag.func_74768_a("zoneId", this.zoneId);
    }

    private static WorldWrappingPortal createWrappingPortal(ServerWorld serverWorld, AxisAlignedBB area, Direction direction, int zoneId, boolean isInward) {
        WorldWrappingPortal portal = (WorldWrappingPortal)entityType.func_200721_a((World)serverWorld);
        portal.isInward = isInward;
        portal.zoneId = zoneId;
        WorldWrappingPortal.initWrappingPortal(serverWorld, area, direction, isInward, portal);
        return portal;
    }

    public static void initWrappingPortal(ServerWorld serverWorld, AxisAlignedBB area, Direction direction, boolean isInward, Portal portal) {
        Vector3d areaSize = Helper.getBoxSize(area);
        Tuple<Direction, Direction> axises = Helper.getPerpendicularDirections(isInward ? direction : direction.func_176734_d());
        AxisAlignedBB boxSurface = Helper.getBoxSurfaceInversed(area, direction);
        Vector3d center = boxSurface.func_189972_c();
        AxisAlignedBB oppositeSurface = Helper.getBoxSurfaceInversed(area, direction.func_176734_d());
        Vector3d destination = oppositeSurface.func_189972_c();
        portal.func_70107_b(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        portal.destination = destination;
        portal.axisW = Vector3d.func_237491_b_((Vector3i)((Direction)axises.func_76341_a()).func_176730_m());
        portal.axisH = Vector3d.func_237491_b_((Vector3i)((Direction)axises.func_76340_b()).func_176730_m());
        portal.width = Helper.getCoordinate(areaSize, ((Direction)axises.func_76341_a()).func_176740_k());
        portal.height = Helper.getCoordinate(areaSize, ((Direction)axises.func_76340_b()).func_176740_k());
        portal.dimensionTo = serverWorld.func_234923_W_();
    }

    public static List<WrappingZone> getWrappingZones(ServerWorld world) {
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        ArrayList<WrappingZone> result = new ArrayList<WrappingZone>();
        gps.data.stream().filter(portal -> portal instanceof WorldWrappingPortal).map(portal -> (WorldWrappingPortal)((Object)portal)).collect(Collectors.groupingBy(portal -> portal.zoneId)).forEach((zoneId, portals) -> result.add(new WrappingZone(world, ((WorldWrappingPortal)((Object)((Object)portals.get((int)0)))).isInward, (int)zoneId, (List<WorldWrappingPortal>)portals)));
        return result;
    }

    public static int getAvailableId(List<WrappingZone> zones) {
        return zones.stream().max(Comparator.comparingInt(z -> z.id)).map(z -> z.id + 1).orElse(1);
    }

    public static void invokeAddWrappingZone(ServerWorld world, int x1, int z1, int x2, int z2, boolean isInward, Consumer<ITextComponent> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        for (WrappingZone zone : wrappingZones) {
            if (zone.isValid()) continue;
            feedbackSender.accept((ITextComponent)new TranslationTextComponent("imm_ptl.removed_invalid_wrapping_portals", new Object[]{Helper.myToString(zone.portals.stream())}));
            zone.removeFromWorld();
        }
        int availableId = WorldWrappingPortal.getAvailableId(wrappingZones);
        AxisAlignedBB box = new IntBox(new BlockPos(x1, 0, z1), new BlockPos(x2, 255, z2)).toRealNumberBox();
        WorldWrappingPortal p1 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.NORTH, availableId, isInward);
        WorldWrappingPortal p2 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.SOUTH, availableId, isInward);
        WorldWrappingPortal p3 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.WEST, availableId, isInward);
        WorldWrappingPortal p4 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.EAST, availableId, isInward);
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        gps.data.add(p1);
        gps.data.add(p2);
        gps.data.add(p3);
        gps.data.add(p4);
        gps.onDataChanged();
    }

    public static void invokeViewWrappingZones(ServerWorld world, Consumer<ITextComponent> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        wrappingZones.forEach(wrappingZone -> feedbackSender.accept((ITextComponent)new StringTextComponent(wrappingZone.toString())));
    }

    public static void invokeRemoveWrappingZone(ServerWorld world, Vector3d playerPos, Consumer<ITextComponent> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(z -> z.getArea().func_72318_a(playerPos)).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((ITextComponent)new TranslationTextComponent("imm_ptl.removed_portal", new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((ITextComponent)new TranslationTextComponent("imm_ptl.not_in_wrapping_zone"));
        }
    }

    public static void invokeRemoveWrappingZone(ServerWorld world, int zoneId, Consumer<ITextComponent> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((ITextComponent)new TranslationTextComponent("imm_ptl.removed_portal", new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((ITextComponent)new TranslationTextComponent("imm_ptl.cannot_find_zone"));
        }
    }

    public static class WrappingZone {
        public ServerWorld world;
        public boolean isInwardZone;
        public int id;
        public List<WorldWrappingPortal> portals;

        public WrappingZone(ServerWorld world, boolean isInwardZone, int id, List<WorldWrappingPortal> portals) {
            this.world = world;
            this.isInwardZone = isInwardZone;
            this.id = id;
            this.portals = portals;
        }

        public boolean isValid() {
            return this.portals.size() == 4 && this.portals.get((int)0).isInward == this.isInwardZone && this.portals.get((int)1).isInward == this.isInwardZone && this.portals.get((int)2).isInward == this.isInwardZone && this.portals.get((int)3).isInward == this.isInwardZone;
        }

        public void removeFromWorld() {
            GlobalPortalStorage gps = GlobalPortalStorage.get(this.world);
            this.portals.forEach(worldWrappingPortal -> gps.data.remove(worldWrappingPortal));
            gps.onDataChanged();
        }

        public AxisAlignedBB getArea() {
            return this.portals.stream().map(Portal::getThinAreaBox).reduce(AxisAlignedBB::func_111270_a).orElse(null);
        }

        public IntBox getIntArea() {
            AxisAlignedBB floatBox = this.getArea();
            return new IntBox(new BlockPos((double)Math.round(floatBox.field_72340_a), 0.0, (double)Math.round(floatBox.field_72339_c)), new BlockPos((double)(Math.round(floatBox.field_72336_d) - 1L), 256.0, (double)(Math.round(floatBox.field_72334_f) - 1L)));
        }

        public IntBox getBorderBox() {
            if (!this.isInwardZone) {
                return this.getIntArea();
            }
            AxisAlignedBB floatBox = this.getArea();
            return new IntBox(new BlockPos((double)(Math.round(floatBox.field_72340_a) - 1L), 0.0, (double)(Math.round(floatBox.field_72339_c) - 1L)), new BlockPos((double)Math.round(floatBox.field_72336_d), 256.0, (double)Math.round(floatBox.field_72334_f)));
        }

        public String toString() {
            AxisAlignedBB area = this.getArea();
            return String.format("[%d] %s %s %s ~ %s %s\n", this.id, this.isInwardZone ? "inward" : "outward", area.field_72340_a, area.field_72339_c, area.field_72336_d, area.field_72334_f);
        }
    }
}

