/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.global_portals;

import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.portal.global_portals.GlobalPortalStorage;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.util.function.Predicate;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class VerticalConnectingPortal
extends GlobalTrackedPortal {
    public static EntityType<VerticalConnectingPortal> entityType;

    private static Predicate<GlobalTrackedPortal> getPredicate(ConnectorType connectorType) {
        switch (connectorType) {
            case floor: {
                return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().field_72448_b > 0.0;
            }
        }
        return portal -> portal instanceof VerticalConnectingPortal && portal.getNormal().field_72448_b < 0.0;
    }

    public VerticalConnectingPortal(EntityType<?> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    public static void connect(RegistryKey<World> from, ConnectorType connectorType, RegistryKey<World> to) {
        int upY = connectorType == ConnectorType.ceil ? VerticalConnectingPortal.getHeight(from) : VerticalConnectingPortal.getHeight(to);
        VerticalConnectingPortal.connect(from, connectorType, to, 0, upY);
    }

    public static void connect(RegistryKey<World> from, ConnectorType connectorType, RegistryKey<World> to, int downY, int upY) {
        VerticalConnectingPortal.removeConnectingPortal(connectorType, from);
        ServerWorld fromWorld = McHelper.getServer().func_71218_a(from);
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(fromWorld, connectorType, McHelper.getServer().func_71218_a(to), downY, upY);
        GlobalPortalStorage storage = GlobalPortalStorage.get(fromWorld);
        storage.data.add(connectingPortal);
        storage.onDataChanged();
    }

    public static void connectMutually(RegistryKey<World> up, RegistryKey<World> down, int downY, int upY) {
        VerticalConnectingPortal.connect(up, ConnectorType.floor, down, downY, upY);
        VerticalConnectingPortal.connect(down, ConnectorType.ceil, up, downY, upY);
    }

    private static VerticalConnectingPortal createConnectingPortal(ServerWorld fromWorld, ConnectorType connectorType, ServerWorld toWorld, int downY, int upY) {
        VerticalConnectingPortal verticalConnectingPortal = new VerticalConnectingPortal(entityType, (World)fromWorld);
        switch (connectorType) {
            case floor: {
                verticalConnectingPortal.func_70107_b(0.0, downY, 0.0);
                verticalConnectingPortal.destination = new Vector3d(0.0, (double)upY, 0.0);
                verticalConnectingPortal.axisW = new Vector3d(0.0, 0.0, 1.0);
                verticalConnectingPortal.axisH = new Vector3d(1.0, 0.0, 0.0);
                break;
            }
            case ceil: {
                verticalConnectingPortal.func_70107_b(0.0, upY, 0.0);
                verticalConnectingPortal.destination = new Vector3d(0.0, (double)downY, 0.0);
                verticalConnectingPortal.axisW = new Vector3d(1.0, 0.0, 0.0);
                verticalConnectingPortal.axisH = new Vector3d(0.0, 0.0, 1.0);
            }
        }
        verticalConnectingPortal.dimensionTo = toWorld.func_234923_W_();
        verticalConnectingPortal.width = 2.3333333333E10;
        verticalConnectingPortal.height = 2.3333333333E10;
        return verticalConnectingPortal;
    }

    public static void removeConnectingPortal(ConnectorType connectorType, RegistryKey<World> dimension) {
        VerticalConnectingPortal.removeConnectingPortal(VerticalConnectingPortal.getPredicate(connectorType), dimension);
    }

    private static void removeConnectingPortal(Predicate<GlobalTrackedPortal> predicate, RegistryKey<World> dimension) {
        ServerWorld endWorld = McHelper.getServer().func_71218_a(dimension);
        GlobalPortalStorage storage = GlobalPortalStorage.get(endWorld);
        storage.data.removeIf(portal -> portal instanceof VerticalConnectingPortal && predicate.test((GlobalTrackedPortal)((Object)portal)));
        storage.onDataChanged();
    }

    public static VerticalConnectingPortal getConnectingPortal(World world, ConnectorType type) {
        return McHelper.getGlobalPortals(world).stream().filter(VerticalConnectingPortal.getPredicate(type)).findFirst().orElse(null);
    }

    public static int getHeight(RegistryKey<World> dim) {
        return McHelper.getServer().func_71218_a(dim).func_234938_ad_();
    }

    public static enum ConnectorType {
        ceil,
        floor;

    }
}

