/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.global_portals;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.lang3.Validate;

public class GlobalPortalStorage
extends WorldSavedData {
    public List<GlobalTrackedPortal> data;
    public WeakReference<ServerWorld> world;
    private int version = 1;

    public static void init() {
        ModMain.postServerTickSignal.connect(() -> McHelper.getServer().func_212370_w().forEach(world1 -> GlobalPortalStorage.get(world1).upgradeDataIfNecessary()));
    }

    public GlobalPortalStorage(String string_1, ServerWorld world_) {
        super(string_1);
        this.world = new WeakReference<ServerWorld>(world_);
        this.data = new ArrayList<GlobalTrackedPortal>();
    }

    public static void onPlayerLoggedIn(ServerPlayerEntity player) {
        McHelper.getServer().func_212370_w().forEach(world -> {
            GlobalPortalStorage storage = GlobalPortalStorage.get(world);
            if (!storage.data.isEmpty()) {
                player.field_71135_a.func_147359_a(MyNetwork.createGlobalPortalUpdate(storage));
            }
        });
        NewChunkTrackingGraph.updateForPlayer(player);
    }

    public void onDataChanged() {
        this.func_76186_a(true);
        IPacket packet = MyNetwork.createGlobalPortalUpdate(this);
        McHelper.getCopiedPlayerList().forEach(player -> player.field_71135_a.func_147359_a(packet));
    }

    public void func_76184_a(CompoundNBT tag) {
        ServerWorld currWorld = (ServerWorld)this.world.get();
        Validate.notNull((Object)currWorld);
        List<GlobalTrackedPortal> newData = GlobalPortalStorage.getPortalsFromTag(tag, (World)currWorld);
        if (tag.func_74764_b("version")) {
            this.version = tag.func_74762_e("version");
        }
        this.data = newData;
        this.clearAbnormalPortals();
    }

    public static List<GlobalTrackedPortal> getPortalsFromTag(CompoundNBT tag, World currWorld) {
        ListNBT listTag = tag.func_150295_c("data", 10);
        ArrayList<GlobalTrackedPortal> newData = new ArrayList<GlobalTrackedPortal>();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundNBT compoundTag = listTag.func_150305_b(i);
            GlobalTrackedPortal e = GlobalPortalStorage.readPortalFromTag(currWorld, compoundTag);
            if (e != null) {
                newData.add(e);
                continue;
            }
            Helper.err("error reading portal" + compoundTag);
        }
        return newData;
    }

    public static GlobalTrackedPortal readPortalFromTag(World currWorld, CompoundNBT compoundTag) {
        ResourceLocation entityId = new ResourceLocation(compoundTag.func_74779_i("entity_type"));
        EntityType entityType = (EntityType)Registry.field_212629_r.func_82594_a(entityId);
        Entity e = entityType.func_200721_a(currWorld);
        e.func_70020_e(compoundTag);
        if (!(e instanceof GlobalTrackedPortal)) {
            return null;
        }
        return (GlobalTrackedPortal)e;
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        if (this.data == null) {
            return tag;
        }
        ListNBT listTag = new ListNBT();
        ServerWorld currWorld = (ServerWorld)this.world.get();
        Validate.notNull((Object)currWorld);
        for (GlobalTrackedPortal portal : this.data) {
            Validate.isTrue((portal.field_70170_p == currWorld ? 1 : 0) != 0);
            CompoundNBT portalTag = new CompoundNBT();
            portal.func_189511_e(portalTag);
            portalTag.func_74778_a("entity_type", EntityType.func_200718_a((EntityType)portal.func_200600_R()).toString());
            listTag.add((Object)portalTag);
        }
        tag.func_218657_a("data", (INBT)listTag);
        tag.func_74768_a("version", this.version);
        return tag;
    }

    public static GlobalPortalStorage get(ServerWorld world) {
        return (GlobalPortalStorage)world.func_217481_x().func_215752_a(() -> new GlobalPortalStorage("global_portal", world), "global_portal");
    }

    public void upgradeDataIfNecessary() {
        if (this.version <= 1) {
            GlobalPortalStorage.upgradeData((ServerWorld)this.world.get());
            this.version = 2;
            this.func_76186_a(true);
        }
    }

    public void clearAbnormalPortals() {
        this.data.removeIf(e -> {
            RegistryKey dimensionTo = e.dimensionTo;
            if (McHelper.getServer().func_71218_a(dimensionTo) == null) {
                Helper.err("Missing Dimension for global portal " + dimensionTo.func_240901_a_());
                return true;
            }
            return false;
        });
    }

    private static void upgradeData(ServerWorld world) {
    }
}

