/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.global_portals;

import com.google.common.base.Supplier;
import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.global_portals.WorldWrappingPortal;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class BorderBarrierFiller {
    private static final WeakHashMap<ServerPlayerEntity, Object> warnedPlayers = new WeakHashMap();

    public static void onCommandExecuted(ServerPlayerEntity player) {
        ServerWorld world = (ServerWorld)player.field_70170_p;
        Vector3d playerPos = player.func_213303_ch();
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.getArea().func_72318_a(playerPos)).findFirst().orElse(null);
        if (zone == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("imm_ptl.clear_border_warning"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    public static void onCommandExecuted(ServerPlayerEntity player, int zoneId) {
        ServerWorld world = (ServerWorld)player.field_70170_p;
        List<WorldWrappingPortal.WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WorldWrappingPortal.WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("imm_ptl.cannot_find_zone"), false);
            return;
        }
        BorderBarrierFiller.doInvoke(player, world, zone);
    }

    private static void doInvoke(ServerPlayerEntity player, ServerWorld world, WorldWrappingPortal.WrappingZone zone) {
        IntBox borderBox = zone.getBorderBox();
        boolean warned = warnedPlayers.containsKey(player);
        if (!warned) {
            warnedPlayers.put(player, null);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("imm_ptl.clear_border_warning"), false);
        } else {
            warnedPlayers.remove(player);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("imm_ptl.start_clearing_border"), false);
            BorderBarrierFiller.startFillingBorder(world, borderBox, l -> player.func_146105_b(l, false));
        }
    }

    private static void startFillingBorder(ServerWorld world, IntBox borderBox, Consumer<ITextComponent> informer) {
        Supplier xStream = () -> IntStream.range(borderBox.l.func_177958_n(), borderBox.h.func_177958_n() + 1);
        Supplier zStream = () -> IntStream.range(borderBox.l.func_177952_p(), borderBox.h.func_177952_p() + 1);
        BlockPos.Mutable temp = new BlockPos.Mutable();
        BlockPos.Mutable temp1 = new BlockPos.Mutable();
        Stream stream = Streams.concat((Stream[])new Stream[]{((IntStream)xStream.get()).mapToObj(x -> temp.func_181079_c(x, 0, borderBox.l.func_177952_p())), ((IntStream)xStream.get()).mapToObj(x -> temp.func_181079_c(x, 0, borderBox.h.func_177952_p())), ((IntStream)zStream.get()).mapToObj(z -> temp.func_181079_c(borderBox.l.func_177958_n(), 0, z)), ((IntStream)zStream.get()).mapToObj(z -> temp.func_181079_c(borderBox.h.func_177958_n(), 0, z))});
        BlockPos size = borderBox.getSize();
        int totalColumns = size.func_177958_n() * 2 + size.func_177952_p() * 2;
        McHelper.performSplittedFindingTaskOnServer(stream, pos -> {
            for (int y = 0; y < 256; ++y) {
                temp1.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p());
                world.func_175656_a((BlockPos)temp1, Blocks.field_150350_a.func_176223_P());
            }
            return false;
        }, columns -> {
            double progress = (double)columns / (double)totalColumns;
            informer.accept((ITextComponent)new StringTextComponent(Integer.toString((int)(progress * 100.0)) + "%"));
            return true;
        }, e -> {}, () -> informer.accept((ITextComponent)new TranslationTextComponent("imm_ptl.finished")), () -> {});
    }
}

