/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.extension;

import com.qouteall.immersive_portals.portal.Portal;
import java.util.WeakHashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PortalExtension {
    public double motionAffinity = 0.0;
    public boolean adjustPositionAfterTeleport = false;
    private WeakHashMap<ServerPlayerEntity, PlayerPortalVisibility> playerLoadStatus;

    public void readFromNbt(CompoundNBT compoundTag) {
        if (compoundTag.func_74764_b("motionAffinity")) {
            this.motionAffinity = compoundTag.func_74769_h("motionAffinity");
        }
        if (compoundTag.func_74764_b("adjustPositionAfterTeleport")) {
            this.adjustPositionAfterTeleport = compoundTag.func_74767_n("adjustPositionAfterTeleport");
        }
    }

    public void writeToNbt(CompoundNBT compoundTag) {
        if (this.motionAffinity != 0.0) {
            compoundTag.func_74780_a("motionAffinity", this.motionAffinity);
        }
        compoundTag.func_74757_a("adjustPositionAfterTeleport", this.adjustPositionAfterTeleport);
    }

    public void tick(Portal portal) {
        if (portal.field_70170_p.func_201670_d()) {
            this.tickClient(portal);
        } else {
            if (this.playerLoadStatus == null) {
                this.playerLoadStatus = new WeakHashMap();
            }
            this.playerLoadStatus.entrySet().removeIf(e -> ((ServerPlayerEntity)e.getKey()).field_70128_L);
            if (portal.field_70170_p.func_82737_E() % 20L == 1L) {
                for (PlayerPortalVisibility value : this.playerLoadStatus.values()) {
                    value.updateEverySecond();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(Portal portal) {
    }

    public int refreshAndGetLoadDistanceCap(Portal portal, ServerPlayerEntity player, int currentCap) {
        if (this.playerLoadStatus == null) {
            this.playerLoadStatus = new WeakHashMap();
        }
        PlayerPortalVisibility rec = this.playerLoadStatus.computeIfAbsent(player, k -> new PlayerPortalVisibility());
        int dropTimeout = 80;
        long worldTime = portal.field_70170_p.func_82737_E();
        long timePassed = Math.abs(worldTime - rec.lastVisibleTime);
        if (timePassed > 80L) {
            rec.targetCap = currentCap;
            rec.currentCap = 0.0;
        } else {
            rec.targetCap = timePassed == 0L ? Math.max(rec.targetCap, currentCap) : currentCap;
        }
        rec.lastVisibleTime = portal.field_70170_p.func_82737_E();
        return (int)Math.round(rec.currentCap);
    }

    private static class PlayerPortalVisibility {
        public long lastVisibleTime = 0L;
        public double currentCap = 0.0;
        public int targetCap = 0;

        private PlayerPortalVisibility() {
        }

        public void updateEverySecond() {
            double currentCapSq = this.currentCap * this.currentCap;
            double targetCapSq = this.targetCap * this.targetCap;
            currentCapSq = currentCapSq < targetCapSq ? Math.min(currentCapSq + targetCapSq / 12.0, targetCapSq) : Math.max(currentCapSq - targetCapSq / 12.0, targetCapSq);
            this.currentCap = Math.sqrt(currentCapSq);
        }
    }
}

