/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import com.qouteall.immersive_portals.portal.custom_portal_gen.PortalGenInfo;
import com.qouteall.immersive_portals.portal.custom_portal_gen.form.NetherPortalLikeForm;
import com.qouteall.immersive_portals.portal.custom_portal_gen.form.PortalGenForm;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import com.qouteall.immersive_portals.portal.nether_portal.BreakablePortalEntity;
import com.qouteall.immersive_portals.portal.nether_portal.GeneralBreakablePortal;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalGeneration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScalingSquareForm
extends NetherPortalLikeForm {
    public static final Codec<ScalingSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("from_frame_block").forGetter(o -> o.fromFrameBlock), (App)Registry.field_212618_g.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)Registry.field_212618_g.fieldOf("to_frame_block").forGetter(o -> o.toFrameBlock), (App)Codec.INT.fieldOf("from_length").forGetter(o -> o.fromLength), (App)Codec.INT.fieldOf("to_length").forGetter(o -> o.toLength), (App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound)).apply((Applicative)instance, instance.stable(ScalingSquareForm::new)));
    public final Block fromFrameBlock;
    public final Block areaBlock;
    public final Block toFrameBlock;
    public final int fromLength;
    public final int toLength;

    public ScalingSquareForm(Block fromFrameBlock, Block areaBlock, Block toFrameBlock, int fromLength, int toLength, boolean generateFrameIfNotFound) {
        super(generateFrameIfNotFound);
        this.fromFrameBlock = fromFrameBlock;
        this.areaBlock = areaBlock;
        this.toFrameBlock = toFrameBlock;
        this.fromLength = fromLength;
        this.toLength = toLength;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new ScalingSquareForm(this.toFrameBlock, this.areaBlock, this.fromFrameBlock, this.toLength, this.fromLength, this.generateFrameIfNotFound);
    }

    @Override
    @Nullable
    public BlockPortalShape checkAndGetTemplateToShape(ServerWorld world, BlockPortalShape fromShape) {
        boolean isSquareShape = BlockPortalShape.isSquareShape(fromShape, this.fromLength);
        if (!isSquareShape) {
            return null;
        }
        return BlockPortalShape.getSquareShapeTemplate(fromShape.axis, this.toLength);
    }

    @Override
    public void generateNewFrame(ServerWorld fromWorld, BlockPortalShape fromShape, ServerWorld toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithCorner) {
            toWorld.func_175656_a(blockPos, this.toFrameBlock.func_176223_P());
        }
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return s -> s.func_177230_c() == this.toFrameBlock;
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return s -> s.func_177230_c() == this.fromFrameBlock;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return s -> s.func_177230_c() == this.areaBlock;
    }

    @Override
    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        ServerWorld fromWorld = McHelper.getServer().func_71218_a(info.from);
        ServerWorld toWorld = McHelper.getServer().func_71218_a(info.to);
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, info.fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, info.toShape);
        EntityType<GeneralBreakablePortal> entityType = GeneralBreakablePortal.entityType;
        GeneralBreakablePortal f1 = (GeneralBreakablePortal)entityType.func_200721_a((World)fromWorld);
        info.fromShape.initPortalPosAxisShape(f1, false);
        f1.dimensionTo = info.to;
        f1.destination = info.toShape.innerAreaBox.getCenterVec();
        f1.scaling = (double)this.toLength / (double)this.fromLength;
        GeneralBreakablePortal f2 = PortalManipulation.createFlippedPortal(f1, entityType);
        GeneralBreakablePortal t1 = PortalManipulation.createReversePortal(f1, entityType);
        GeneralBreakablePortal t2 = PortalManipulation.createFlippedPortal(t1, entityType);
        f1.blockPortalShape = info.fromShape;
        f2.blockPortalShape = info.fromShape;
        t1.blockPortalShape = info.toShape;
        t2.blockPortalShape = info.toShape;
        f1.reversePortalId = t1.func_110124_au();
        t1.reversePortalId = f1.func_110124_au();
        f2.reversePortalId = t2.func_110124_au();
        t2.reversePortalId = f2.func_110124_au();
        fromWorld.func_217376_c((Entity)f1);
        fromWorld.func_217376_c((Entity)f2);
        toWorld.func_217376_c((Entity)t1);
        toWorld.func_217376_c((Entity)t2);
        return new BreakablePortalEntity[]{f1, f2, t1, t2};
    }
}

