/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen.form;

import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.custom_portal_gen.CustomPortalGeneration;
import com.qouteall.immersive_portals.portal.custom_portal_gen.PortalGenInfo;
import com.qouteall.immersive_portals.portal.custom_portal_gen.form.PortalGenForm;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import com.qouteall.immersive_portals.portal.nether_portal.BreakablePortalEntity;
import com.qouteall.immersive_portals.portal.nether_portal.GeneralBreakablePortal;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalGeneration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public abstract class NetherPortalLikeForm
extends PortalGenForm {
    public final boolean generateFrameIfNotFound;

    public NetherPortalLikeForm(boolean generateFrameIfNotFound) {
        this.generateFrameIfNotFound = generateFrameIfNotFound;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerWorld fromWorld, BlockPos startingPos, ServerWorld toWorld) {
        if (!NetherPortalGeneration.checkPortalGeneration(fromWorld, startingPos)) {
            return false;
        }
        Predicate<BlockState> areaPredicate = this.getAreaPredicate();
        Predicate<BlockState> thisSideFramePredicate = this.getThisSideFramePredicate();
        Predicate<BlockState> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startingPos, areaPredicate, thisSideFramePredicate);
        if (fromShape == null) {
            return false;
        }
        if (NetherPortalGeneration.isOtherGenerationRunning(fromWorld, fromShape.innerAreaBox.getCenterVec())) {
            return false;
        }
        if (this.generateFrameIfNotFound) {
            for (BlockPos areaPos : fromShape.area) {
                fromWorld.func_175656_a(areaPos, Blocks.field_150350_a.func_176223_P());
            }
        }
        BlockPos toPos = cpg.mapPosition(fromShape.innerAreaBox.getCenter());
        BlockPortalShape templateToShape = this.checkAndGetTemplateToShape(fromWorld, fromShape);
        if (templateToShape == null) {
            return false;
        }
        NetherPortalGeneration.startGeneratingPortal(fromWorld, toWorld, fromShape, templateToShape, toPos, 128, areaPredicate, otherSideFramePredicate, toShape -> this.generateNewFrame(fromWorld, fromShape, toWorld, (BlockPortalShape)toShape), info -> {
            BreakablePortalEntity[] result;
            for (BreakablePortalEntity portal : result = this.generatePortalEntitiesAndPlaceholder((PortalGenInfo)info)) {
                cpg.onPortalGenerated(portal);
            }
        }, () -> {
            if (!this.generateFrameIfNotFound) {
                return null;
            }
            BlockPortalShape toShape = this.getNewPortalPlacement(toWorld, toPos, templateToShape);
            return toShape;
        }, () -> fromShape.frameAreaWithoutCorner.stream().allMatch(bp -> !fromWorld.func_175623_d(bp)), s -> fromWorld != toWorld || fromShape.anchor != s.anchor);
        return true;
    }

    protected BlockPortalShape getNewPortalPlacement(ServerWorld toWorld, BlockPos toPos, BlockPortalShape templateToShape) {
        IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, templateToShape.axis, templateToShape.totalAreaBox.getSize(), 128);
        return templateToShape.getShapeWithMovedAnchor(airCubePlacement.l.func_177973_b((Vector3i)templateToShape.totalAreaBox.l).func_177971_a((Vector3i)templateToShape.anchor));
    }

    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        return NetherPortalGeneration.generateBreakablePortalEntitiesAndPlaceholder(info, GeneralBreakablePortal.entityType);
    }

    @Nullable
    public BlockPortalShape checkAndGetTemplateToShape(ServerWorld world, BlockPortalShape fromShape) {
        return fromShape;
    }

    public abstract void generateNewFrame(ServerWorld var1, BlockPortalShape var2, ServerWorld var3, BlockPortalShape var4);

    public abstract Predicate<BlockState> getOtherSideFramePredicate();

    public abstract Predicate<BlockState> getThisSideFramePredicate();

    public abstract Predicate<BlockState> getAreaPredicate();
}

