/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import com.qouteall.immersive_portals.portal.PortalPlaceholderBlock;
import com.qouteall.immersive_portals.portal.custom_portal_gen.CustomPortalGeneration;
import com.qouteall.immersive_portals.portal.custom_portal_gen.SimpleBlockPredicate;
import com.qouteall.immersive_portals.portal.custom_portal_gen.form.PortalGenForm;
import com.qouteall.immersive_portals.portal.nether_portal.BlockPortalShape;
import com.qouteall.immersive_portals.portal.nether_portal.GeneralBreakablePortal;
import com.qouteall.immersive_portals.portal.nether_portal.NetherPortalGeneration;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FlippingFloorSquareForm
extends PortalGenForm {
    public static final ListCodec<Block> blockListCodec = new ListCodec((Codec)Registry.field_212618_g);
    public static final Codec<FlippingFloorSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("length").forGetter(o -> o.length), (App)SimpleBlockPredicate.codec.fieldOf("frame_block").forGetter(o -> o.frameBlock), (App)SimpleBlockPredicate.codec.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.codec.optionalFieldOf("up_frame_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.upFrameBlock), (App)SimpleBlockPredicate.codec.optionalFieldOf("bottom_block", (Object)SimpleBlockPredicate.pass).forGetter(o -> o.bottomBlock)).apply((Applicative)instance, instance.stable(FlippingFloorSquareForm::new)));
    public final int length;
    public final SimpleBlockPredicate frameBlock;
    public final SimpleBlockPredicate areaBlock;
    public final SimpleBlockPredicate upFrameBlock;
    public final SimpleBlockPredicate bottomBlock;

    public FlippingFloorSquareForm(int length, SimpleBlockPredicate frameBlock, SimpleBlockPredicate areaBlock, SimpleBlockPredicate upFrameBlock, SimpleBlockPredicate bottomBlock) {
        this.length = length;
        this.frameBlock = frameBlock;
        this.areaBlock = areaBlock;
        this.upFrameBlock = upFrameBlock;
        this.bottomBlock = bottomBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerWorld fromWorld, BlockPos startingPos, ServerWorld toWorld) {
        GeneralBreakablePortal[] portals;
        SimpleBlockPredicate areaPredicate = this.areaBlock;
        SimpleBlockPredicate framePredicate = this.frameBlock;
        SimpleBlockPredicate bottomPredicate = this.bottomBlock;
        if (!areaPredicate.test(fromWorld.func_180495_p(startingPos))) {
            return false;
        }
        if (!bottomPredicate.test(fromWorld.func_180495_p(startingPos.func_177977_b()))) {
            return false;
        }
        BlockPortalShape fromShape = BlockPortalShape.findArea(startingPos, Direction.Axis.Y, blockPos -> areaPredicate.test(fromWorld.func_180495_p(blockPos)), blockPos -> framePredicate.test(fromWorld.func_180495_p(blockPos)));
        if (fromShape == null) {
            return false;
        }
        if (!this.checkFromShape(fromWorld, fromShape)) {
            return false;
        }
        BlockPos areaSize = fromShape.innerAreaBox.getSize();
        BlockPos toPos = cpg.mapPosition(fromShape.innerAreaBox.l);
        IntBox placingBox = FlippingFloorSquareForm.findPortalPlacement(toWorld, areaSize, toPos);
        BlockPos offset = placingBox.l.func_177973_b((Vector3i)fromShape.innerAreaBox.l);
        BlockPortalShape toShape = fromShape.getShapeWithMovedAnchor(fromShape.anchor.func_177971_a((Vector3i)offset));
        fromShape.frameAreaWithoutCorner.forEach(fromWorldPos -> {
            BlockPos toWorldPos = fromWorldPos.func_177971_a((Vector3i)offset);
            toWorld.func_175656_a(toWorldPos, fromWorld.func_180495_p(fromWorldPos));
            toWorld.func_175656_a(toWorldPos.func_177984_a(), fromWorld.func_180495_p(fromWorldPos.func_177984_a()));
        });
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, toShape);
        for (GeneralBreakablePortal portal : portals = FlippingFloorSquareForm.createPortals(fromWorld, toWorld, fromShape, toShape)) {
            cpg.onPortalGenerated(portal);
        }
        return true;
    }

    public boolean checkFromShape(ServerWorld fromWorld, BlockPortalShape fromShape) {
        boolean areaSizeTest = BlockPortalShape.isSquareShape(fromShape, this.length);
        if (!areaSizeTest) {
            return false;
        }
        return fromShape.frameAreaWithoutCorner.stream().allMatch(blockPos -> this.upFrameBlock.test(fromWorld.func_180495_p(blockPos.func_177984_a()))) && fromShape.area.stream().allMatch(blockPos -> this.bottomBlock.test(fromWorld.func_180495_p(blockPos.func_177977_b())));
    }

    public static IntBox findPortalPlacement(ServerWorld toWorld, BlockPos areaSize, BlockPos toPos) {
        return IntStream.range(toPos.func_177958_n() - 8, toPos.func_177958_n() + 8).boxed().flatMap(x -> IntStream.range(toPos.func_177952_p() - 8, toPos.func_177952_p() + 8).boxed().flatMap(z -> IntStream.range(5, toWorld.func_234938_ad_() - 5).map(y -> toWorld.func_234938_ad_() - y).mapToObj(y -> new BlockPos(x.intValue(), y, z.intValue())))).map(blockPos -> IntBox.getBoxByBasePointAndSize(areaSize, blockPos)).filter(intBox -> intBox.stream().allMatch(pos -> {
            BlockState blockState = toWorld.func_180495_p(pos);
            return !blockState.func_200015_d((IBlockReader)toWorld, pos) && blockState.func_177230_c() != PortalPlaceholderBlock.instance && blockState.func_204520_s().func_206888_e();
        })).filter(intBox -> intBox.getSurfaceLayer(Direction.DOWN).getMoved(Direction.DOWN.func_176730_m()).stream().allMatch(blockPos -> {
            BlockState blockState = toWorld.func_180495_p(blockPos);
            return !blockState.func_196958_f() && blockState.func_177230_c() != PortalPlaceholderBlock.instance;
        })).findFirst().orElseGet(() -> IntBox.getBoxByBasePointAndSize(areaSize, toPos)).getMoved(Direction.DOWN.func_176730_m());
    }

    public static GeneralBreakablePortal[] createPortals(ServerWorld fromWorld, ServerWorld toWorld, BlockPortalShape fromShape, BlockPortalShape toShape) {
        GeneralBreakablePortal pa = (GeneralBreakablePortal)GeneralBreakablePortal.entityType.func_200721_a((World)fromWorld);
        fromShape.initPortalPosAxisShape(pa, true);
        pa.destination = toShape.innerAreaBox.getCenterVec();
        pa.dimensionTo = toWorld.func_234923_W_();
        pa.rotation = new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 180.0f, true);
        GeneralBreakablePortal pb = PortalManipulation.createReversePortal(pa, GeneralBreakablePortal.entityType);
        pa.blockPortalShape = fromShape;
        pb.blockPortalShape = toShape;
        pa.reversePortalId = pb.func_110124_au();
        pb.reversePortalId = pa.func_110124_au();
        pa.extension.motionAffinity = 0.1;
        pb.extension.motionAffinity = 0.1;
        McHelper.spawnServerEntityToUnloadedArea(pa);
        McHelper.spawnServerEntityToUnloadedArea(pb);
        return new GeneralBreakablePortal[]{pa, pb};
    }
}

