/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.qouteall.immersive_portals.McHelper;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SimpleBlockPredicate
implements Predicate<BlockState> {
    public static final SimpleBlockPredicate pass = new SimpleBlockPredicate();
    private final ITag<Block> tag;
    private final Block block;
    public static final Codec<SimpleBlockPredicate> codec = Codec.STRING.comapFlatMap(SimpleBlockPredicate::deserialize, SimpleBlockPredicate::serialize);

    public SimpleBlockPredicate(ITag<Block> tag) {
        this.tag = tag;
        this.block = null;
    }

    public SimpleBlockPredicate(Block block) {
        this.block = block;
        this.tag = null;
    }

    private SimpleBlockPredicate() {
        this.tag = null;
        this.block = null;
    }

    @Override
    public boolean test(BlockState blockState) {
        if (this.tag != null) {
            return blockState.func_235714_a_(this.tag);
        }
        if (this.block != null) {
            return blockState.func_177230_c() == this.block;
        }
        return true;
    }

    private static DataResult<SimpleBlockPredicate> deserialize(String string) {
        MinecraftServer server = McHelper.getServer();
        if (server == null) {
            return DataResult.error((String)"[Immersive Portals] Simple block predicate should not be deserialized in client");
        }
        ITagCollectionSupplier tagManager = server.field_195576_ac.func_244358_d();
        ResourceLocation id = new ResourceLocation(string);
        ITag blockTag = tagManager.func_241835_a().func_199910_a(id);
        if (blockTag != null) {
            return DataResult.success((Object)new SimpleBlockPredicate((ITag<Block>)blockTag), (Lifecycle)Lifecycle.stable());
        }
        if (Registry.field_212618_g.func_148742_b().contains(id)) {
            Block block = (Block)Registry.field_212618_g.func_82594_a(id);
            return DataResult.success((Object)new SimpleBlockPredicate(block), (Lifecycle)Lifecycle.stable());
        }
        return DataResult.error((String)("Unknown block or block tag:" + string));
    }

    private static String serialize(SimpleBlockPredicate predicate) {
        MinecraftServer server = McHelper.getServer();
        if (server == null) {
            throw new RuntimeException("Simple block predicate should not be serialized in client");
        }
        if (predicate.block != null) {
            return Registry.field_212618_g.func_177774_c((Object)predicate.block).toString();
        }
        ITag<Block> tag = predicate.tag;
        ITagCollectionSupplier tagManager = server.field_195576_ac.func_244358_d();
        ResourceLocation id = tagManager.func_241835_a().func_232975_b_(tag);
        if (id == null) {
            throw new RuntimeException("Cannot get id from tag " + tag);
        }
        return id.toString();
    }
}

