/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;

public abstract class PortalGenTrigger {
    public static final Codec<PortalGenTrigger> triggerCodec;
    public static final Registry<Codec<? extends PortalGenTrigger>> codecRegistry;
    public static final Codec<UseItemTrigger> useItemTriggerCodec;
    public static final Codec<ThrowItemTrigger> throwItemTriggerCodec;
    public static final Codec<ConventionalDimensionChangeTrigger> conventionalDimensionChangeCodec;

    public abstract Codec<? extends PortalGenTrigger> getCodec();

    static {
        useItemTriggerCodec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212630_s.fieldOf("item").forGetter(o -> o.item), (App)Codec.BOOL.optionalFieldOf("consume", (Object)false).forGetter(o -> o.consume)).apply((Applicative)instance, instance.stable(UseItemTrigger::new)));
        throwItemTriggerCodec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212630_s.fieldOf("item").forGetter(o -> o.item)).apply((Applicative)instance, instance.stable(ThrowItemTrigger::new)));
        conventionalDimensionChangeCodec = Codec.unit(ConventionalDimensionChangeTrigger::new);
        codecRegistry = new SimpleRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_gen_trigger")), Lifecycle.stable());
        Registry.func_218322_a(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:use_item"), useItemTriggerCodec);
        Registry.func_218322_a(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:throw_item"), throwItemTriggerCodec);
        Registry.func_218322_a(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:conventional_dimension_change"), (Object)ConventionalDimensionChangeTrigger.conventionalDimensionChangeCodec);
        triggerCodec = codecRegistry.dispatchStable(PortalGenTrigger::getCodec, Function.identity());
    }

    public static class ConventionalDimensionChangeTrigger
    extends PortalGenTrigger {
        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return conventionalDimensionChangeCodec;
        }
    }

    public static class ThrowItemTrigger
    extends PortalGenTrigger {
        public final Item item;

        public ThrowItemTrigger(Item item) {
            this.item = item;
        }

        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return throwItemTriggerCodec;
        }
    }

    public static class UseItemTrigger
    extends PortalGenTrigger {
        public final Item item;
        public final boolean consume;

        public UseItemTrigger(Item item, boolean consume) {
            this.item = item;
            this.consume = consume;
        }

        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return useItemTriggerCodec;
        }
    }
}

