/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.custom_portal_gen.PortalGenTrigger;
import com.qouteall.immersive_portals.portal.custom_portal_gen.form.PortalGenForm;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CustomPortalGeneration {
    public static final RegistryKey<World> theSameDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("imm_ptl:the_same_dimension"));
    public static final Codec<List<RegistryKey<World>>> dimensionListCodec = new ListCodec(World.field_234917_f_);
    public static final Codec<List<String>> stringListCodec = new ListCodec((Codec)Codec.STRING);
    public static RegistryKey<Registry<Codec<CustomPortalGeneration>>> schemaRegistryKey = RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_gen_schema"));
    public static RegistryKey<Registry<CustomPortalGeneration>> registryRegistryKey = RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_generation"));
    public static final Codec<CustomPortalGeneration> codecV1 = RecordCodecBuilder.create(instance -> instance.group((App)dimensionListCodec.fieldOf("from").forGetter(o -> o.fromDimensions), (App)World.field_234917_f_.fieldOf("to").forGetter(o -> o.toDimension), (App)Codec.INT.optionalFieldOf("space_ratio_from", (Object)1).forGetter(o -> o.spaceRatioFrom), (App)Codec.INT.optionalFieldOf("space_ratio_to", (Object)1).forGetter(o -> o.spaceRatioTo), (App)Codec.BOOL.optionalFieldOf("reversible", (Object)true).forGetter(o -> o.reversible), (App)PortalGenForm.codec.fieldOf("form").forGetter(o -> o.form), (App)PortalGenTrigger.triggerCodec.fieldOf("trigger").forGetter(o -> o.trigger), (App)stringListCodec.optionalFieldOf("post_invoke_commands", Collections.emptyList()).forGetter(o -> o.postInvokeCommands)).apply((Applicative)instance, instance.stable(CustomPortalGeneration::new)));
    public static SimpleRegistry<Codec<CustomPortalGeneration>> schemaRegistry = (SimpleRegistry)Util.func_199748_a(() -> {
        SimpleRegistry registry = new SimpleRegistry(schemaRegistryKey, Lifecycle.stable());
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("imm_ptl:v1"), codecV1);
        return registry;
    });
    public static final MapCodec<CustomPortalGeneration> codec = schemaRegistry.dispatchMap("schema_version", e -> codecV1, Function.identity());
    public final List<RegistryKey<World>> fromDimensions;
    public final RegistryKey<World> toDimension;
    public final int spaceRatioFrom;
    public final int spaceRatioTo;
    public final boolean reversible;
    public final PortalGenForm form;
    public final PortalGenTrigger trigger;
    public final List<String> postInvokeCommands;

    public CustomPortalGeneration(List<RegistryKey<World>> fromDimensions, RegistryKey<World> toDimension, int spaceRatioFrom, int spaceRatioTo, boolean reversible, PortalGenForm form, PortalGenTrigger trigger, List<String> postInvokeCommands) {
        this.fromDimensions = fromDimensions;
        this.toDimension = toDimension;
        this.spaceRatioFrom = spaceRatioFrom;
        this.spaceRatioTo = spaceRatioTo;
        this.reversible = reversible;
        this.form = form;
        this.trigger = trigger;
        this.postInvokeCommands = postInvokeCommands;
    }

    public CustomPortalGeneration getReverse() {
        if (this.toDimension == theSameDimension) {
            return new CustomPortalGeneration(this.fromDimensions, theSameDimension, this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands);
        }
        if (this.fromDimensions.size() == 1) {
            return new CustomPortalGeneration(Lists.newArrayList((Object[])new RegistryKey[]{this.toDimension}), this.fromDimensions.get(0), this.spaceRatioTo, this.spaceRatioFrom, false, this.form.getReverse(), this.trigger, this.postInvokeCommands);
        }
        Helper.err("Cannot get reverse custom portal gen");
        return null;
    }

    public BlockPos mapPosition(BlockPos from) {
        return Helper.divide((Vector3i)Helper.scale((Vector3i)from, this.spaceRatioTo), this.spaceRatioFrom);
    }

    public boolean initAndCheck() {
        RegistryKey<World> toDimension = this.toDimension;
        if (toDimension != theSameDimension && McHelper.getServer().func_71218_a(toDimension) == null) {
            return false;
        }
        return this.form.initAndCheck();
    }

    public String toString() {
        return McHelper.serializeToJson(this, codec.codec());
    }

    public boolean perform(ServerWorld world, BlockPos startPos) {
        ServerWorld toWorld;
        if (!this.fromDimensions.contains(world.func_234923_W_())) {
            return false;
        }
        if (!world.func_175667_e(startPos)) {
            Helper.log("Skip custom portal generation because chunk not loaded");
            return false;
        }
        RegistryKey destDimension = this.toDimension;
        if (destDimension == theSameDimension) {
            destDimension = world.func_234923_W_();
        }
        if ((toWorld = McHelper.getServer().func_71218_a(destDimension)) == null) {
            Helper.err("Missing dimension " + destDimension.func_240901_a_());
            return false;
        }
        world.func_217381_Z().func_76320_a("custom_portal_gen_perform");
        boolean result = this.form.perform(this, world, startPos, toWorld);
        world.func_217381_Z().func_76319_b();
        return result;
    }

    public void onPortalGenerated(Portal portal) {
        if (this.postInvokeCommands.isEmpty()) {
            return;
        }
        CommandSource commandSource = portal.func_195051_bN().func_197033_a(4).func_197031_a();
        Commands commandManager = McHelper.getServer().func_195571_aL();
        for (String command : this.postInvokeCommands) {
            commandManager.func_197059_a(commandSource, command);
        }
    }
}

