/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal.custom_portal_gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.my_util.UCoordinate;
import com.qouteall.immersive_portals.portal.custom_portal_gen.CustomPortalGeneration;
import com.qouteall.immersive_portals.portal.custom_portal_gen.PortalGenTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class CustomPortalGenManagement {
    private static final Multimap<Item, CustomPortalGeneration> useItemGen = HashMultimap.create();
    private static final Multimap<Item, CustomPortalGeneration> throwItemGen = HashMultimap.create();
    private static final ArrayList<CustomPortalGeneration> convGen = new ArrayList();
    private static final Map<UUID, UCoordinate> posBeforeTravel = new HashMap<UUID, UCoordinate>();

    public static void onDatapackReload() {
        useItemGen.clear();
        throwItemGen.clear();
        convGen.clear();
        posBeforeTravel.clear();
        Helper.log("Loading custom portal gen");
        MinecraftServer server = McHelper.getServer();
        DynamicRegistries.Impl registryTracker = new DynamicRegistries.Impl();
        WorldSettingsImport registryOps = WorldSettingsImport.func_244335_a((DynamicOps)JsonOps.INSTANCE, (IResourceManager)server.field_195576_ac.func_240970_h_(), (DynamicRegistries.Impl)registryTracker);
        SimpleRegistry emptyRegistry = new SimpleRegistry(CustomPortalGeneration.registryRegistryKey, Lifecycle.stable());
        DataResult dataResult = registryOps.func_241797_a_(emptyRegistry, CustomPortalGeneration.registryRegistryKey, CustomPortalGeneration.codec.codec());
        SimpleRegistry result = dataResult.get().left().orElse(null);
        if (result == null) {
            DataResult.PartialResult r = (DataResult.PartialResult)dataResult.get().right().get();
            McHelper.sendMessageToFirstLoggedPlayer((ITextComponent)new StringTextComponent("Error when parsing custom portal generation\n" + r.message()));
            return;
        }
        result.func_239659_c_().forEach(entry -> {
            CustomPortalGeneration gen = (CustomPortalGeneration)entry.getValue();
            if (!gen.initAndCheck()) {
                Helper.log("Custom Portal Gen Is Not Activated " + gen.toString());
                return;
            }
            Helper.log("Loaded Custom Portal Gen " + ((RegistryKey)entry.getKey()).func_240901_a_() + " " + gen.toString());
            CustomPortalGenManagement.load(gen);
            if (gen.reversible) {
                CustomPortalGeneration reverse = gen.getReverse();
                if (gen.initAndCheck()) {
                    CustomPortalGenManagement.load(reverse);
                }
            }
        });
    }

    private static void load(CustomPortalGeneration gen) {
        PortalGenTrigger trigger = gen.trigger;
        if (trigger instanceof PortalGenTrigger.UseItemTrigger) {
            useItemGen.put((Object)((PortalGenTrigger.UseItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ThrowItemTrigger) {
            throwItemGen.put((Object)((PortalGenTrigger.ThrowItemTrigger)trigger).item, (Object)gen);
        } else if (trigger instanceof PortalGenTrigger.ConventionalDimensionChangeTrigger) {
            convGen.add(gen);
        }
    }

    public static void onItemUse(ItemUseContext context, ActionResultType actionResult) {
        if (context.func_195991_k().func_201670_d()) {
            return;
        }
        Item item = context.func_195996_i().func_77973_b();
        if (useItemGen.containsKey((Object)item)) {
            ModMain.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : useItemGen.get((Object)item)) {
                    boolean result = gen.perform((ServerWorld)context.func_195991_k(), context.func_195995_a().func_177972_a(context.func_196000_l()));
                    if (!result) continue;
                    if (!(gen.trigger instanceof PortalGenTrigger.UseItemTrigger)) break;
                    PortalGenTrigger.UseItemTrigger trigger = (PortalGenTrigger.UseItemTrigger)gen.trigger;
                    if (!trigger.consume) break;
                    context.func_195996_i().func_190918_g(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onItemTick(ItemEntity entity) {
        Item item;
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        if (entity.func_200214_m() == null) {
            return;
        }
        if (entity.func_174874_s() && throwItemGen.containsKey((Object)(item = entity.func_92059_d().func_77973_b()))) {
            ModMain.serverTaskList.addTask(() -> {
                for (CustomPortalGeneration gen : throwItemGen.get((Object)item)) {
                    boolean result = gen.perform((ServerWorld)entity.field_70170_p, entity.func_233580_cy_());
                    if (!result) continue;
                    entity.func_92059_d().func_190918_g(1);
                    break;
                }
                return true;
            });
        }
    }

    public static void onBeforeConventionalDimensionChange(ServerPlayerEntity player) {
        posBeforeTravel.put(player.func_110124_au(), new UCoordinate((Entity)player));
    }

    public static void onAfterConventionalDimensionChange(ServerPlayerEntity player) {
        UUID uuid = player.func_110124_au();
        if (posBeforeTravel.containsKey(uuid)) {
            UCoordinate startCoord = posBeforeTravel.get(uuid);
            posBeforeTravel.remove(uuid);
            ServerWorld startWorld = McHelper.getServerWorld(startCoord.dimension);
            BlockPos startPos = new BlockPos(startCoord.pos);
            for (CustomPortalGeneration gen : convGen) {
                IntBox box = new IntBox(startPos.func_177982_a(-1, -1, -1), startPos.func_177982_a(1, 1, 1));
                boolean succeeded = box.stream().anyMatch(pos -> gen.perform(startWorld, (BlockPos)pos));
                if (!succeeded) continue;
                return;
            }
        }
    }
}

