/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.my_util.RotationHelper;
import com.qouteall.immersive_portals.portal.GeometryPortalShape;
import com.qouteall.immersive_portals.portal.Portal;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PortalManipulation {
    public static void removeConnectedPortals(Portal portal, Consumer<Portal> removalInformer) {
        PortalManipulation.removeOverlappedPortals(portal.field_70170_p, portal.func_213303_ch(), portal.getNormal().func_186678_a(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        ServerWorld toWorld = McHelper.getServer().func_71218_a(portal.dimensionTo);
        PortalManipulation.removeOverlappedPortals((World)toWorld, portal.destination, portal.transformLocalVecNonScale(portal.getNormal().func_186678_a(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        PortalManipulation.removeOverlappedPortals((World)toWorld, portal.destination, portal.transformLocalVecNonScale(portal.getNormal()), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
    }

    public static Portal completeBiWayPortal(Portal portal, EntityType<? extends Portal> entityType) {
        Portal newPortal = PortalManipulation.createReversePortal(portal, entityType);
        McHelper.spawnServerEntityToUnloadedArea(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createReversePortal(Portal portal, EntityType<T> entityType) {
        ServerWorld world = McHelper.getServer().func_71218_a(portal.dimensionTo);
        Portal newPortal = (Portal)entityType.func_200721_a((World)world);
        newPortal.dimensionTo = portal.field_70170_p.func_234923_W_();
        newPortal.func_70107_b(portal.destination.field_72450_a, portal.destination.field_72448_b, portal.destination.field_72449_c);
        newPortal.destination = portal.func_213303_ch();
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width * portal.scaling;
        newPortal.height = portal.height * portal.scaling;
        newPortal.axisW = portal.axisW;
        newPortal.axisH = portal.axisH.func_186678_a(-1.0);
        if (portal.specialShape != null) {
            newPortal.specialShape = new GeometryPortalShape();
            PortalManipulation.initFlippedShape(newPortal, portal.specialShape, portal.scaling);
        }
        newPortal.initCullableRange(portal.cullableXStart * portal.scaling, portal.cullableXEnd * portal.scaling, -portal.cullableYStart * portal.scaling, -portal.cullableYEnd * portal.scaling);
        if (portal.rotation != null) {
            PortalManipulation.rotatePortalBody(newPortal, portal.rotation);
            newPortal.rotation = new Quaternion(portal.rotation);
            newPortal.rotation.func_195892_e();
        }
        newPortal.scaling = 1.0 / portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)((Object)newPortal);
    }

    public static void rotatePortalBody(Portal portal, Quaternion rotation) {
        portal.axisW = RotationHelper.getRotated(rotation, portal.axisW);
        portal.axisH = RotationHelper.getRotated(rotation, portal.axisH);
    }

    public static Portal completeBiFacedPortal(Portal portal, EntityType<Portal> entityType) {
        Portal newPortal = PortalManipulation.createFlippedPortal(portal, entityType);
        McHelper.spawnServerEntityToUnloadedArea(newPortal);
        return newPortal;
    }

    public static <T extends Portal> T createFlippedPortal(Portal portal, EntityType<T> entityType) {
        ServerWorld world = (ServerWorld)portal.field_70170_p;
        Portal newPortal = (Portal)entityType.func_200721_a((World)world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.func_70107_b(portal.func_226277_ct_(), portal.func_226278_cu_(), portal.func_226281_cx_());
        newPortal.destination = portal.destination;
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW;
        newPortal.axisH = portal.axisH.func_186678_a(-1.0);
        if (portal.specialShape != null) {
            newPortal.specialShape = new GeometryPortalShape();
            PortalManipulation.initFlippedShape(newPortal, portal.specialShape, 1.0);
        }
        newPortal.initCullableRange(portal.cullableXStart, portal.cullableXEnd, -portal.cullableYStart, -portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return (T)((Object)newPortal);
    }

    public static Portal copyPortal(Portal portal, EntityType<Portal> entityType) {
        ServerWorld world = (ServerWorld)portal.field_70170_p;
        Portal newPortal = (Portal)entityType.func_200721_a((World)world);
        newPortal.dimensionTo = portal.dimensionTo;
        newPortal.func_70107_b(portal.func_226277_ct_(), portal.func_226278_cu_(), portal.func_226281_cx_());
        newPortal.destination = portal.destination;
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = portal.axisW;
        newPortal.axisH = portal.axisH;
        newPortal.specialShape = portal.specialShape;
        newPortal.initCullableRange(portal.cullableXStart, portal.cullableXEnd, portal.cullableYStart, portal.cullableYEnd);
        newPortal.rotation = portal.rotation;
        newPortal.scaling = portal.scaling;
        PortalManipulation.copyAdditionalProperties(newPortal, portal);
        return newPortal;
    }

    private static void initFlippedShape(Portal newPortal, GeometryPortalShape specialShape, double scale) {
        newPortal.specialShape.triangles = specialShape.triangles.stream().map(triangle -> new GeometryPortalShape.TriangleInPlane(triangle.x1 * scale, -triangle.y1 * scale, triangle.x2 * scale, -triangle.y2 * scale, triangle.x3 * scale, -triangle.y3 * scale)).collect(Collectors.toList());
    }

    public static void completeBiWayBiFacedPortal(Portal portal, Consumer<Portal> removalInformer, Consumer<Portal> addingInformer, EntityType<Portal> entityType) {
        PortalManipulation.removeOverlappedPortals((World)((ServerWorld)portal.field_70170_p), portal.func_213303_ch(), portal.getNormal().func_186678_a(-1.0), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal oppositeFacedPortal = PortalManipulation.completeBiFacedPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((World)McHelper.getServer().func_71218_a(portal.dimensionTo), portal.destination, portal.transformLocalVecNonScale(portal.getNormal().func_186678_a(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r1 = PortalManipulation.completeBiWayPortal(portal, entityType);
        PortalManipulation.removeOverlappedPortals((World)McHelper.getServer().func_71218_a(oppositeFacedPortal.dimensionTo), oppositeFacedPortal.destination, oppositeFacedPortal.transformLocalVecNonScale(oppositeFacedPortal.getNormal().func_186678_a(-1.0)), p -> Objects.equals(p.specificPlayerId, portal.specificPlayerId), removalInformer);
        Portal r2 = PortalManipulation.completeBiWayPortal(oppositeFacedPortal, entityType);
        addingInformer.accept(oppositeFacedPortal);
        addingInformer.accept(r1);
        addingInformer.accept(r2);
    }

    public static void removeOverlappedPortals(World world, Vector3d pos, Vector3d normal, Predicate<Portal> predicate, Consumer<Portal> informer) {
        PortalManipulation.getPortalClutter(world, pos, normal, predicate).forEach(e -> {
            e.func_70106_y();
            informer.accept((Portal)((Object)e));
        });
    }

    public static List<Portal> getPortalClutter(World world, Vector3d pos, Vector3d normal, Predicate<Portal> predicate) {
        return world.func_175647_a(Portal.class, new AxisAlignedBB(pos.func_72441_c(0.5, 0.5, 0.5), pos.func_178786_a(0.5, 0.5, 0.5)), p -> p.getNormal().func_72430_b(normal) > 0.5 && predicate.test((Portal)((Object)p)));
    }

    public static <T extends Portal> T createOrthodoxPortal(EntityType<T> entityType, ServerWorld fromWorld, ServerWorld toWorld, Direction facing, AxisAlignedBB portalArea, Vector3d destination) {
        Portal portal = (Portal)entityType.func_200721_a((World)fromWorld);
        Tuple<Direction, Direction> directions = Helper.getPerpendicularDirections(facing);
        Vector3d areaSize = Helper.getBoxSize(portalArea);
        AxisAlignedBB boxSurface = Helper.getBoxSurface(portalArea, facing);
        Vector3d center = boxSurface.func_189972_c();
        portal.func_70107_b(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        portal.destination = destination;
        portal.axisW = Vector3d.func_237491_b_((Vector3i)((Direction)directions.func_76341_a()).func_176730_m());
        portal.axisH = Vector3d.func_237491_b_((Vector3i)((Direction)directions.func_76340_b()).func_176730_m());
        portal.width = Helper.getCoordinate(areaSize, ((Direction)directions.func_76341_a()).func_176740_k());
        portal.height = Helper.getCoordinate(areaSize, ((Direction)directions.func_76340_b()).func_176740_k());
        portal.dimensionTo = toWorld.func_234923_W_();
        return (T)((Object)portal);
    }

    public static void copyAdditionalProperties(Portal to, Portal from) {
        to.extension.motionAffinity = from.extension.motionAffinity;
        to.teleportable = from.teleportable;
        to.teleportChangesScale = from.teleportChangesScale;
        to.specificPlayerId = from.specificPlayerId;
        to.extension.adjustPositionAfterTeleport = from.extension.adjustPositionAfterTeleport;
    }
}

