/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import com.qouteall.immersive_portals.my_util.SignalArged;
import com.qouteall.immersive_portals.portal.GeometryPortalShape;
import com.qouteall.immersive_portals.portal.extension.PortalExtension;
import com.qouteall.immersive_portals.teleportation.CollisionHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Portal
extends Entity {
    public static EntityType<Portal> entityType;
    public double width = 0.0;
    public double height = 0.0;
    public Vector3d axisW;
    public Vector3d axisH;
    public RegistryKey<World> dimensionTo;
    public Vector3d destination;
    public boolean teleportable = true;
    @Nullable
    public UUID specificPlayerId;
    @Nullable
    public GeometryPortalShape specialShape;
    private AxisAlignedBB boundingBoxCache;
    private Vector3d normal;
    private Vector3d contentDirection;
    public double cullableXStart = 0.0;
    public double cullableXEnd = 0.0;
    public double cullableYStart = 0.0;
    public double cullableYEnd = 0.0;
    @Nullable
    public Quaternion rotation;
    public double scaling = 1.0;
    public boolean teleportChangesScale = true;
    private boolean interactable = true;
    public PortalExtension extension = new PortalExtension();
    public static final SignalArged<Portal> clientPortalTickSignal;
    public static final SignalArged<Portal> serverPortalTickSignal;

    public Portal(EntityType<?> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compoundTag) {
        this.width = compoundTag.func_74769_h("width");
        this.height = compoundTag.func_74769_h("height");
        this.axisW = Helper.getVec3d(compoundTag, "axisW").func_72432_b();
        this.axisH = Helper.getVec3d(compoundTag, "axisH").func_72432_b();
        this.dimensionTo = DimId.getWorldId(compoundTag, "dimensionTo", this.field_70170_p.field_72995_K);
        this.destination = Helper.getVec3d(compoundTag, "destination");
        if (compoundTag.func_74764_b("specificPlayer")) {
            this.specificPlayerId = Helper.getUuid(compoundTag, "specificPlayer");
        }
        if (compoundTag.func_74764_b("specialShape")) {
            this.specialShape = new GeometryPortalShape(compoundTag.func_150295_c("specialShape", 6));
            if (this.specialShape.triangles.isEmpty()) {
                this.specialShape = null;
            }
        }
        if (compoundTag.func_74764_b("teleportable")) {
            this.teleportable = compoundTag.func_74767_n("teleportable");
        }
        if (compoundTag.func_74764_b("cullableXStart")) {
            this.cullableXStart = compoundTag.func_74769_h("cullableXStart");
            this.cullableXEnd = compoundTag.func_74769_h("cullableXEnd");
            this.cullableYStart = compoundTag.func_74769_h("cullableYStart");
            this.cullableYEnd = compoundTag.func_74769_h("cullableYEnd");
        } else if (this.specialShape != null) {
            this.cullableXStart = 0.0;
            this.cullableXEnd = 0.0;
            this.cullableYStart = 0.0;
            this.cullableYEnd = 0.0;
        } else {
            this.initDefaultCullableRange();
        }
        if (compoundTag.func_74764_b("rotationA")) {
            this.rotation = new Quaternion(compoundTag.func_74760_g("rotationB"), compoundTag.func_74760_g("rotationC"), compoundTag.func_74760_g("rotationD"), compoundTag.func_74760_g("rotationA"));
        }
        if (compoundTag.func_74764_b("interactable")) {
            this.interactable = compoundTag.func_74767_n("interactable");
        }
        if (compoundTag.func_74764_b("scale")) {
            this.scaling = compoundTag.func_74769_h("scale");
        }
        if (compoundTag.func_74764_b("teleportChangesScale")) {
            this.teleportChangesScale = compoundTag.func_74767_n("teleportChangesScale");
        }
        this.extension = new PortalExtension();
        this.extension.readFromNbt(compoundTag);
    }

    protected void func_213281_b(CompoundNBT compoundTag) {
        compoundTag.func_74780_a("width", this.width);
        compoundTag.func_74780_a("height", this.height);
        Helper.putVec3d(compoundTag, "axisW", this.axisW);
        Helper.putVec3d(compoundTag, "axisH", this.axisH);
        DimId.putWorldId(compoundTag, "dimensionTo", this.dimensionTo);
        Helper.putVec3d(compoundTag, "destination", this.destination);
        if (this.specificPlayerId != null) {
            Helper.putUuid(compoundTag, "specificPlayer", this.specificPlayerId);
        }
        if (this.specialShape != null) {
            compoundTag.func_218657_a("specialShape", (INBT)this.specialShape.writeToTag());
        }
        compoundTag.func_74757_a("teleportable", this.teleportable);
        if (this.specialShape == null) {
            this.initDefaultCullableRange();
        }
        compoundTag.func_74780_a("cullableXStart", this.cullableXStart);
        compoundTag.func_74780_a("cullableXEnd", this.cullableXEnd);
        compoundTag.func_74780_a("cullableYStart", this.cullableYStart);
        compoundTag.func_74780_a("cullableYEnd", this.cullableYEnd);
        if (this.rotation != null) {
            compoundTag.func_74780_a("rotationA", (double)this.rotation.func_195894_d());
            compoundTag.func_74780_a("rotationB", (double)this.rotation.func_195889_a());
            compoundTag.func_74780_a("rotationC", (double)this.rotation.func_195891_b());
            compoundTag.func_74780_a("rotationD", (double)this.rotation.func_195893_c());
        }
        compoundTag.func_74757_a("interactable", this.interactable);
        compoundTag.func_74780_a("scale", this.scaling);
        compoundTag.func_74757_a("teleportChangesScale", this.teleportChangesScale);
        this.extension.writeToNbt(compoundTag);
    }

    public boolean isCullable() {
        if (this.specialShape == null) {
            this.initDefaultCullableRange();
        }
        return this.cullableXStart != this.cullableXEnd;
    }

    public boolean isTeleportable() {
        return this.teleportable;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    public void updateCache() {
        this.boundingBoxCache = null;
        this.normal = null;
        this.contentDirection = null;
        this.func_174813_aQ();
        this.getNormal();
        this.getContentDirection();
    }

    public void initDefaultCullableRange() {
        this.cullableXStart = -(this.width / 2.0);
        this.cullableXEnd = this.width / 2.0;
        this.cullableYStart = -(this.height / 2.0);
        this.cullableYEnd = this.height / 2.0;
    }

    public void initCullableRange(double cullableXStart, double cullableXEnd, double cullableYStart, double cullableYEnd) {
        this.cullableXStart = Math.min(cullableXStart, cullableXEnd);
        this.cullableXEnd = Math.max(cullableXStart, cullableXEnd);
        this.cullableYStart = Math.min(cullableYStart, cullableYEnd);
        this.cullableYEnd = Math.max(cullableYStart, cullableYEnd);
    }

    public IPacket<?> func_213297_N() {
        return MyNetwork.createStcSpawnEntity(this);
    }

    public boolean func_174827_a(ServerPlayerEntity spectator) {
        if (this.specificPlayerId == null) {
            return true;
        }
        return spectator.func_110124_au().equals(this.specificPlayerId);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            clientPortalTickSignal.emit(this);
        } else {
            if (!this.isPortalValid()) {
                Helper.log("removed invalid portal" + (Object)((Object)this));
                this.field_70128_L = true;
                return;
            }
            serverPortalTickSignal.emit(this);
        }
        this.extension.tick(this);
        CollisionHelper.notifyCollidingPortals(this);
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.axisW == null) {
            this.boundingBoxCache = null;
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.getPortalCollisionBox();
        }
        return this.boundingBoxCache;
    }

    public void func_174826_a(AxisAlignedBB boundingBox) {
        this.boundingBoxCache = null;
    }

    public void func_213315_a(MoverType type, Vector3d movement) {
    }

    public boolean isPortalValid() {
        ServerWorld destWorld;
        boolean valid;
        boolean bl = valid = this.dimensionTo != null && this.width != 0.0 && this.height != 0.0 && this.axisW != null && this.axisH != null && this.destination != null;
        if (valid && this.field_70170_p instanceof ServerWorld && (destWorld = McHelper.getServer().func_71218_a(this.dimensionTo)) == null) {
            Helper.err("Missing Dimension " + this.dimensionTo.func_240901_a_());
            return false;
        }
        return valid;
    }

    public boolean isInside(Vector3d entityPos, double valve) {
        double v = entityPos.func_178788_d(this.destination).func_72430_b(this.getContentDirection());
        return v > valve;
    }

    public void onEntityTeleportedOnServer(Entity entity) {
    }

    public String toString() {
        return String.format("%s{%s,%s,(%s %s %s %s)->(%s %s %s %s)%s%s}", ((Object)((Object)this)).getClass().getSimpleName(), this.func_145782_y(), Direction.func_210769_a((double)this.getNormal().field_72450_a, (double)this.getNormal().field_72448_b, (double)this.getNormal().field_72449_c), this.field_70170_p.func_234923_W_().func_240901_a_(), (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), this.dimensionTo.func_240901_a_(), (int)this.destination.field_72450_a, (int)this.destination.field_72448_b, (int)this.destination.field_72449_c, this.specificPlayerId != null ? ",specificAccessor:" + this.specificPlayerId.toString() : "", this.hasScaling() ? ",scale:" + this.scaling : "");
    }

    public boolean hasScaling() {
        return this.scaling != 1.0;
    }

    public Vector3d getNormal() {
        if (this.normal == null) {
            this.normal = this.axisW.func_72431_c(this.axisH).func_72432_b();
        }
        return this.normal;
    }

    public Vector3d getContentDirection() {
        if (this.contentDirection == null) {
            this.contentDirection = this.transformLocalVecNonScale(this.getNormal().func_186678_a(-1.0));
        }
        return this.contentDirection;
    }

    public double getDistanceToPlane(Vector3d pos) {
        return pos.func_178788_d(this.func_213303_ch()).func_72430_b(this.getNormal());
    }

    public boolean isInFrontOfPortal(Vector3d playerPos) {
        return this.getDistanceToPlane(playerPos) > 0.0;
    }

    public Vector3d getPointInPlane(double xInPlane, double yInPlane) {
        return this.func_213303_ch().func_178787_e(this.getPointInPlaneLocal(xInPlane, yInPlane));
    }

    public Vector3d getPointInPlaneLocal(double xInPlane, double yInPlane) {
        return this.axisW.func_186678_a(xInPlane).func_178787_e(this.axisH.func_186678_a(yInPlane));
    }

    public Vector3d getPointInPlaneLocalClamped(double xInPlane, double yInPlane) {
        return this.getPointInPlaneLocal(MathHelper.func_151237_a((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0)), MathHelper.func_151237_a((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0)));
    }

    public Vector3d[] getFourVerticesLocal(double shrinkFactor) {
        Vector3d[] vertices = new Vector3d[]{this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, this.height / 2.0 - shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, this.height / 2.0 - shrinkFactor)};
        return vertices;
    }

    public Vector3d[] getFourVerticesLocalRotated(double shrinkFactor) {
        Vector3d[] fourVerticesLocal = this.getFourVerticesLocal(shrinkFactor);
        fourVerticesLocal[0] = this.transformLocalVec(fourVerticesLocal[0]);
        fourVerticesLocal[1] = this.transformLocalVec(fourVerticesLocal[1]);
        fourVerticesLocal[2] = this.transformLocalVec(fourVerticesLocal[2]);
        fourVerticesLocal[3] = this.transformLocalVec(fourVerticesLocal[3]);
        return fourVerticesLocal;
    }

    public Vector3d[] getFourVerticesLocalCullable(double shrinkFactor) {
        Vector3d[] vertices = new Vector3d[]{this.getPointInPlaneLocal(this.cullableXEnd - shrinkFactor, this.cullableYStart + shrinkFactor), this.getPointInPlaneLocal(this.cullableXStart + shrinkFactor, this.cullableYStart + shrinkFactor), this.getPointInPlaneLocal(this.cullableXEnd - shrinkFactor, this.cullableYEnd - shrinkFactor), this.getPointInPlaneLocal(this.cullableXStart + shrinkFactor, this.cullableYEnd - shrinkFactor)};
        return vertices;
    }

    public final Vector3d transformPointRough(Vector3d pos) {
        Vector3d offset = this.destination.func_178788_d(this.func_213303_ch());
        return pos.func_178787_e(offset);
    }

    public Vector3d transformPoint(Vector3d pos) {
        Vector3d localPos = pos.func_178788_d(this.func_213303_ch());
        Vector3d result = this.transformLocalVec(localPos).func_178787_e(this.destination);
        return result;
    }

    public Vector3d transformLocalVecNonScale(Vector3d localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        Vector3f temp = new Vector3f(localVec);
        temp.func_214905_a(this.rotation);
        return new Vector3d(temp);
    }

    public Vector3d transformLocalVec(Vector3d localVec) {
        return this.transformLocalVecNonScale(localVec).func_186678_a(this.scaling);
    }

    @Deprecated
    public Vector3d untransformLocalVec(Vector3d localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        Vector3f temp = new Vector3f(localVec);
        Quaternion r = this.rotation.func_227068_g_();
        r.func_195892_e();
        temp.func_214905_a(r);
        return new Vector3d(temp);
    }

    @Deprecated
    public Vector3d untransformPoint(Vector3d point) {
        return this.func_213303_ch().func_178787_e(this.untransformLocalVec(point.func_178788_d(this.destination)));
    }

    public Vector3d scaleLocalVec(Vector3d localVec) {
        if (this.scaling == 1.0) {
            return localVec;
        }
        return localVec.func_186678_a(this.scaling);
    }

    public Vector3d getCullingPoint() {
        return this.destination;
    }

    private AxisAlignedBB getPortalCollisionBox() {
        return new AxisAlignedBB(this.getPointInPlane(this.width / 2.0, this.height / 2.0).func_178787_e(this.getNormal().func_186678_a(0.2)), this.getPointInPlane(-this.width / 2.0, -this.height / 2.0).func_178787_e(this.getNormal().func_186678_a(-0.2))).func_111270_a(new AxisAlignedBB(this.getPointInPlane(-this.width / 2.0, this.height / 2.0).func_178787_e(this.getNormal().func_186678_a(0.2)), this.getPointInPlane(this.width / 2.0, -this.height / 2.0).func_178787_e(this.getNormal().func_186678_a(-0.2))));
    }

    public AxisAlignedBB getThinAreaBox() {
        return new AxisAlignedBB(this.getPointInPlane(this.width / 2.0, this.height / 2.0), this.getPointInPlane(-this.width / 2.0, -this.height / 2.0));
    }

    public boolean isPointInPortalProjection(Vector3d pos) {
        boolean roughResult;
        Vector3d offset = pos.func_178788_d(this.func_213303_ch());
        double yInPlane = offset.func_72430_b(this.axisH);
        double xInPlane = offset.func_72430_b(this.axisW);
        boolean bl = roughResult = Math.abs(xInPlane) < this.width / 2.0 + 0.1 && Math.abs(yInPlane) < this.height / 2.0 + 0.1;
        if (roughResult && this.specialShape != null) {
            return this.specialShape.triangles.stream().anyMatch(triangle -> triangle.isPointInTriangle(xInPlane, yInPlane));
        }
        return roughResult;
    }

    public boolean isMovedThroughPortal(Vector3d lastTickPos, Vector3d pos) {
        return this.rayTrace(lastTickPos, pos) != null;
    }

    public Vector3d rayTrace(Vector3d from, Vector3d to) {
        double collidingT;
        double lastDistance = this.getDistanceToPlane(from);
        double nowDistance = this.getDistanceToPlane(to);
        if (!(lastDistance > 0.0) || !(nowDistance < 0.0)) {
            return null;
        }
        Vector3d lineOrigin = from;
        Vector3d lineDirection = to.func_178788_d(from).func_72432_b();
        Vector3d collidingPoint = lineOrigin.func_178787_e(lineDirection.func_186678_a(collidingT = Helper.getCollidingT(this.func_213303_ch(), this.normal, lineOrigin, lineDirection)));
        if (this.isPointInPortalProjection(collidingPoint)) {
            return collidingPoint;
        }
        return null;
    }

    public double getDistanceToNearestPointInPortal(Vector3d point) {
        double distanceToPlane = this.getDistanceToPlane(point);
        Vector3d posInPlane = point.func_178787_e(this.getNormal().func_186678_a(-distanceToPlane));
        Vector3d localPos = posInPlane.func_178788_d(this.func_213303_ch());
        double localX = localPos.func_72430_b(this.axisW);
        double localY = localPos.func_72430_b(this.axisH);
        double distanceToRect = Portal.getDistanceToRectangle(localX, localY, -(this.width / 2.0), -(this.height / 2.0), this.width / 2.0, this.height / 2.0);
        return Math.sqrt(distanceToPlane * distanceToPlane + distanceToRect * distanceToRect);
    }

    public static double getDistanceToRectangle(double pointX, double pointY, double rectAX, double rectAY, double rectBX, double rectBY) {
        assert (rectAX <= rectBX);
        assert (rectAY <= rectBY);
        double wx1 = rectAX - pointX;
        double wx2 = rectBX - pointX;
        double dx = wx1 * wx2 < 0.0 ? 0.0 : Math.min(Math.abs(wx1), Math.abs(wx2));
        double wy1 = rectAY - pointY;
        double wy2 = rectBY - pointY;
        double dy = wy1 * wy2 < 0.0 ? 0.0 : Math.min(Math.abs(wy1), Math.abs(wy2));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Vector3d getPointInPortalProjection(Vector3d pos) {
        Vector3d myPos = this.func_213303_ch();
        Vector3d offset = pos.func_178788_d(myPos);
        double yInPlane = offset.func_72430_b(this.axisH);
        double xInPlane = offset.func_72430_b(this.axisW);
        return myPos.func_178787_e(this.axisW.func_186678_a(xInPlane)).func_178787_e(this.axisH.func_186678_a(yInPlane));
    }

    public World getDestinationWorld() {
        return this.getDestinationWorld(this.field_70170_p.func_201670_d());
    }

    public World getDestinationWorld(boolean isClient) {
        if (isClient) {
            return CHelper.getClientWorld(this.dimensionTo);
        }
        return McHelper.getServer().func_71218_a(this.dimensionTo);
    }

    public static boolean isParallelPortal(Portal currPortal, Portal outerPortal) {
        if (currPortal.field_70170_p.func_234923_W_() != outerPortal.dimensionTo) {
            return false;
        }
        if (currPortal.dimensionTo != outerPortal.field_70170_p.func_234923_W_()) {
            return false;
        }
        if (currPortal.getNormal().func_72430_b(outerPortal.getContentDirection()) > -0.9) {
            return false;
        }
        return !outerPortal.isInside(currPortal.func_213303_ch(), 0.1);
    }

    public static boolean isReversePortal(Portal a, Portal b) {
        return a.dimensionTo == b.field_70170_p.func_234923_W_() && a.field_70170_p.func_234923_W_() == b.dimensionTo && a.func_213303_ch().func_72438_d(b.destination) < 1.0 && a.destination.func_72438_d(b.func_213303_ch()) < 1.0 && a.getNormal().func_72430_b(b.getContentDirection()) > 0.5;
    }

    public static boolean isFlippedPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.field_70170_p == b.field_70170_p && a.dimensionTo == b.dimensionTo && a.func_213303_ch().func_72438_d(b.func_213303_ch()) < 1.0 && a.destination.func_72438_d(b.destination) < 1.0 && a.getNormal().func_72430_b(b.getNormal()) < -0.5;
    }

    static {
        clientPortalTickSignal = new SignalArged();
        serverPortalTickSignal = new SignalArged();
    }
}

