/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.portal;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.Mirror;
import net.minecraft.block.Block;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BreakableMirror
extends Mirror {
    public static EntityType<BreakableMirror> entityType;
    public IntBox wallArea;
    public boolean unbreakable = false;

    public BreakableMirror(EntityType<?> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    @Override
    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.wallArea = new IntBox(new BlockPos(tag.func_74762_e("boxXL"), tag.func_74762_e("boxYL"), tag.func_74762_e("boxZL")), new BlockPos(tag.func_74762_e("boxXH"), tag.func_74762_e("boxYH"), tag.func_74762_e("boxZH")));
        if (tag.func_74764_b("unbreakable")) {
            this.unbreakable = tag.func_74767_n("unbreakable");
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("boxXL", this.wallArea.l.func_177958_n());
        tag.func_74768_a("boxYL", this.wallArea.l.func_177956_o());
        tag.func_74768_a("boxZL", this.wallArea.l.func_177952_p());
        tag.func_74768_a("boxXH", this.wallArea.h.func_177958_n());
        tag.func_74768_a("boxYH", this.wallArea.h.func_177956_o());
        tag.func_74768_a("boxZH", this.wallArea.h.func_177952_p());
        tag.func_74757_a("unbreakable", this.unbreakable);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.unbreakable && this.field_70170_p.func_82737_E() % 10L == (long)(this.func_145782_y() % 10)) {
            this.checkWallIntegrity();
        }
    }

    @Override
    public boolean isPortalValid() {
        return super.isPortalValid() && this.wallArea != null;
    }

    private void checkWallIntegrity() {
        boolean wallValid = this.wallArea.fastStream().allMatch(blockPos -> BreakableMirror.isGlass(this.field_70170_p, blockPos));
        if (!wallValid) {
            this.field_70128_L = true;
        }
    }

    public static boolean isGlass(World world, BlockPos blockPos) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        return block instanceof GlassBlock || block instanceof PaneBlock || block instanceof StainedGlassBlock;
    }

    private static boolean isGlassPane(World world, BlockPos blockPos) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        return block instanceof PaneBlock;
    }

    public static BreakableMirror createMirror(ServerWorld world, BlockPos glassPos, Direction facing) {
        if (!BreakableMirror.isGlass((World)world, glassPos)) {
            return null;
        }
        boolean isPane = BreakableMirror.isGlassPane((World)world, glassPos);
        if (facing.func_176740_k() == Direction.Axis.Y && isPane) {
            return null;
        }
        IntBox wallArea = Helper.expandRectangle(glassPos, blockPos -> BreakableMirror.isGlass((World)world, blockPos) && isPane == BreakableMirror.isGlassPane((World)world, blockPos), facing.func_176740_k());
        BreakableMirror breakableMirror = (BreakableMirror)entityType.func_200721_a((World)world);
        double distanceToCenter = isPane ? 0.0625 : 0.5;
        AxisAlignedBB wallBox = BreakableMirror.getWallBox(world, wallArea);
        Vector3d pos = Helper.getBoxSurfaceInversed(wallBox, facing.func_176734_d()).func_189972_c();
        pos = Helper.putCoordinate(pos, facing.func_176740_k(), Helper.getCoordinate(wallArea.getCenterVec().func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(distanceToCenter)), facing.func_176740_k()));
        breakableMirror.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        breakableMirror.destination = pos;
        breakableMirror.dimensionTo = world.func_234923_W_();
        Tuple<Direction, Direction> dirs = Helper.getPerpendicularDirections(facing);
        Vector3d boxSize = Helper.getBoxSize(wallBox);
        double width = Helper.getCoordinate(boxSize, ((Direction)dirs.func_76341_a()).func_176740_k());
        double height = Helper.getCoordinate(boxSize, ((Direction)dirs.func_76340_b()).func_176740_k());
        breakableMirror.axisW = Vector3d.func_237491_b_((Vector3i)((Direction)dirs.func_76341_a()).func_176730_m());
        breakableMirror.axisH = Vector3d.func_237491_b_((Vector3i)((Direction)dirs.func_76340_b()).func_176730_m());
        breakableMirror.width = width;
        breakableMirror.height = height;
        breakableMirror.wallArea = wallArea;
        BreakableMirror.breakIntersectedMirror(breakableMirror);
        world.func_217376_c((Entity)breakableMirror);
        return breakableMirror;
    }

    private static void breakIntersectedMirror(BreakableMirror newMirror) {
        McHelper.getEntitiesNearby(newMirror, BreakableMirror.class, 20.0).filter(mirror1 -> mirror1.getNormal().func_72430_b(newMirror.getNormal()) > 0.5).filter(mirror1 -> IntBox.getIntersect(mirror1.wallArea, newMirror.wallArea) != null).filter(mirror -> mirror != newMirror).forEach(Entity::func_70106_y);
    }

    private static AxisAlignedBB getWallBox(ServerWorld world, IntBox glassArea) {
        return glassArea.stream().map(blockPos -> world.func_180495_p(blockPos).func_196952_d((IBlockReader)world, blockPos).func_197752_a().func_191194_a(Vector3d.func_237491_b_((Vector3i)blockPos))).reduce(AxisAlignedBB::func_111270_a).orElse(null);
    }
}

