/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.optifine_compatibility.mixin_optifine;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import com.qouteall.immersive_portals.optifine_compatibility.ShaderCullingManager;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.uniform.CustomUniforms;
import net.optifine.shaders.uniform.ShaderUniforms;
import org.lwjgl.BufferUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Shaders.class}, remap=false)
public abstract class MixinShaders {
    @Shadow
    private static double previousCameraPositionX;
    @Shadow
    private static double previousCameraPositionY;
    @Shadow
    private static double previousCameraPositionZ;
    @Shadow
    private static double cameraPositionX;
    @Shadow
    private static double cameraPositionY;
    @Shadow
    private static double cameraPositionZ;
    @Shadow
    private static ClientWorld currentWorld;
    @Shadow
    private static IShaderPack shaderPack;
    @Shadow
    @Final
    private static ByteBuffer bigBuffer;
    private static boolean shouldModifyShaderCode;

    @Shadow
    private static void init() {
        throw new RuntimeException();
    }

    @Inject(method={"checkWorldChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onCheckWorldChanged(ClientWorld world, CallbackInfo ci) {
        if (CGlobal.clientWorldLoader.getIsLoadingFakedWorld()) {
            ci.cancel();
        }
    }

    @Inject(method={"uninit"}, at={@At(value="INVOKE_STRING", target="Lnet/optifine/shaders/SMCLog;info(Ljava/lang/String;)V", args={"ldc=Uninit"})})
    private static void onUninit(CallbackInfo ci) {
        OFGlobal.shaderContextManager.onShaderUninit();
    }

    @Inject(method={"storeConfig"}, at={@At(value="HEAD")})
    private static void onStoreConfig(CallbackInfo ci) {
        if (OFGlobal.shaderContextManager.isContextSwitched()) {
            Helper.err("Trying to store config when context switched");
            ci.cancel();
        }
    }

    @Inject(method={"loadShaderPack"}, at={@At(value="HEAD")})
    private static void onAboutToLoadShaderPack(CallbackInfo ci) {
        Minecraft client = Minecraft.func_71410_x();
        if (client.field_71438_f != null) {
            client.field_71438_f.func_72712_a();
        }
    }

    @Redirect(method={"beginRender"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/Shaders;init()V"))
    private static void redirectInitOnBeginRender() {
        try {
            MixinShaders.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Inject(method={"loadShaderPack"}, at={@At(value="TAIL")})
    private static void onShaderPackLoaded(CallbackInfo ci) {
        OFGlobal.shaderContextManager.updateTemplateContext();
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/uniform/ShaderUniforms;reset()V"))
    private static void redirectShaderUniformReset(ShaderUniforms shaderUniforms) {
        if (!OFGlobal.shaderContextManager.isContextSwitched()) {
            shaderUniforms.reset();
        }
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/optifine/shaders/uniform/CustomUniforms;reset()V"))
    private static void redirectCustomUniformReset(CustomUniforms customUniforms) {
        if (!OFGlobal.shaderContextManager.isContextSwitched()) {
            customUniforms.reset();
        }
    }

    @Inject(method={"createFragShader"}, at={@At(value="HEAD")})
    private static void onCreateFragShader(Program program, String filename, CallbackInfoReturnable<Integer> cir) {
        shouldModifyShaderCode = ShaderCullingManager.shouldModifyShaderCode(program);
    }

    @ModifyVariable(method={"createFragShader"}, at=@At(value="FIELD", target="Lnet/optifine/shaders/Shaders;saveFinalShaders:Z"))
    private static StringBuilder modifyFragShaderCode(StringBuilder shaderCode) {
        if (!shouldModifyShaderCode) {
            return shaderCode;
        }
        return ShaderCullingManager.modifyFragShaderCode(shaderCode);
    }

    @Inject(method={"useProgram"}, at={@At(value="TAIL")})
    private static void onLoadingUniforms(Program program, CallbackInfo ci) {
        if (ShaderCullingManager.shouldModifyShaderCode(program)) {
            ShaderCullingManager.loadUniforms();
        }
        OFGlobal.debugFunc.accept(program);
    }

    @Inject(method={"setCameraShadow"}, at={@At(value="HEAD")})
    private static void onSetCameraShadow(MatrixStack matrixStack, ActiveRenderInfo activeRenderInfo, float partialTicks, CallbackInfo ci) {
        Shaders.useProgram((Program)Shaders.ProgramShadow);
    }

    @Inject(method={"nextIntBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onNextIntBuffer(int size, CallbackInfoReturnable<IntBuffer> cir) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        if (buffer.capacity() <= pos + size * 4) {
            cir.setReturnValue((Object)BufferUtils.createIntBuffer((int)size));
            cir.cancel();
        }
    }

    @Redirect(method={"beginRender"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRendererManager;getPackedLight(Lnet/minecraft/entity/Entity;F)I", remap=true))
    private static int redirectGetLight(EntityRendererManager entityRenderDispatcher, Entity entity, float tickDelta) {
        if (PortalRendering.isRendering()) {
            return RenderStates.originalCameraLightPacked;
        }
        return entityRenderDispatcher.func_229085_a_(entity, tickDelta);
    }
}

