/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.optifine_compatibility;

import com.mojang.blaze3d.platform.GLX;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class UniformReport {
    private static IntBuffer sizeBuffer = (IntBuffer)GLX.make((Object)MemoryUtil.memAllocInt((int)1), p_209238_0_ -> LWJGLMemoryUntracker.func_197933_a((long)MemoryUtil.memAddress((IntBuffer)p_209238_0_)));
    private static IntBuffer dataTypeBuffer = (IntBuffer)GLX.make((Object)MemoryUtil.memAllocInt((int)1), p_209238_0_ -> LWJGLMemoryUntracker.func_197933_a((long)MemoryUtil.memAddress((IntBuffer)p_209238_0_)));

    public static void reportUniforms(int programId, Consumer<String> output) {
        int maxIndex = GL20.glGetProgrami((int)programId, (int)35718);
        List uniformInfos = IntStream.range(0, maxIndex).mapToObj(i -> {
            String name = GL20.glGetActiveUniform((int)programId, (int)i, (IntBuffer)sizeBuffer, (IntBuffer)dataTypeBuffer);
            CHelper.checkGlError();
            return new UniformInfo(programId, name, i, dataTypeBuffer.get(0));
        }).collect(Collectors.toList());
        uniformInfos.stream().forEach(uniformInfo -> uniformInfo.report(output));
    }

    public static void launchUniformReport(String[] programNames, Consumer<String> output) {
        Predicate<String> namePredicate = name -> Arrays.asList(programNames).contains(name);
        OFGlobal.debugFunc = program -> {
            String name = program.getName();
            if (namePredicate.test(name)) {
                UniformReport.reportUniforms(program.getId(), output);
                OFGlobal.debugFunc = p -> {};
            }
        };
    }

    public static class UniformInfo {
        public int programId;
        public String name;
        public int index;
        public int type;

        public UniformInfo(int programId, String name, int index, int type) {
            this.programId = programId;
            this.name = name;
            this.index = index;
            this.type = type;
        }

        public void report(Consumer<String> output) {
            this.reportValue(s -> output.accept(String.format("[%s] %s: %s", this.index, this.name, s)));
        }

        public void reportValue(Consumer<String> output) {
            try {
                switch (this.type) {
                    case 5126: {
                        float v = GL20.glGetUniformf((int)this.programId, (int)this.index);
                        output.accept(Float.toString(v));
                        break;
                    }
                    case 35664: {
                        float[] v = new float[2];
                        GL20.glGetUniformfv((int)this.programId, (int)this.index, (float[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    case 35665: {
                        float[] v = new float[3];
                        GL20.glGetUniformfv((int)this.programId, (int)this.index, (float[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    case 35666: {
                        float[] v = new float[4];
                        GL20.glGetUniformfv((int)this.programId, (int)this.index, (float[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    case 5124: {
                        int v = GL20.glGetUniformi((int)this.programId, (int)this.index);
                        output.accept(Integer.toString(v));
                        break;
                    }
                    case 35667: {
                        int[] v = new int[2];
                        GL20.glGetUniformiv((int)this.programId, (int)this.index, (int[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    case 35675: {
                        float[] v = new float[9];
                        GL20.glGetUniformfv((int)this.programId, (int)this.index, (float[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    case 35676: {
                        float[] v = new float[16];
                        GL20.glGetUniformfv((int)this.programId, (int)this.index, (float[])v);
                        output.accept(Arrays.toString(v));
                        break;
                    }
                    default: {
                        output.accept("Unknown " + this.type);
                        break;
                    }
                }
            }
            catch (Exception e) {
                output.accept(String.format("Error Reporting Uniform %s %s %s %s", this.name, this.index, this.type, e.toString()));
            }
        }
    }
}

