/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.optifine_compatibility;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import com.qouteall.immersive_portals.render.PixelCuller;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.optifine.shaders.Program;
import net.optifine.shaders.uniform.ShaderUniform1f;
import net.optifine.shaders.uniform.ShaderUniform3f;
import net.optifine.shaders.uniform.ShaderUniforms;
import org.apache.commons.io.IOUtils;

public class ShaderCullingManager {
    private static final Pattern pattern = Pattern.compile("void ( )*main( )*\\(( )*( )*\\)( )*(\n)*\\{");
    private static String toReplace;
    private static final ResourceLocation transformation;
    public static ShaderUniform3f uniform_equationXYZ;
    public static ShaderUniform1f uniform_equationW;
    public static boolean cullingEnabled;
    private static boolean initialized;

    private static void init() {
        initialized = true;
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_195551_G().func_199002_a(transformation).func_199027_b();
            toReplace = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            Helper.log("Loaded Shader Code Replacement");
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        ShaderUniforms shaderUniforms = OFGlobal.getShaderUniforms.get();
        uniform_equationXYZ = shaderUniforms.make3f("cullingEquationXYZ");
        uniform_equationW = shaderUniforms.make1f("cullingEquationW");
    }

    public static StringBuilder modifyFragShaderCode(StringBuilder rawCode) {
        if (!cullingEnabled) {
            return rawCode;
        }
        if (!initialized) {
            ShaderCullingManager.init();
        }
        if (toReplace == null) {
            throw new RuntimeException("Shader Code Modifier is not initialized");
        }
        StringBuilder uniformsDeclarationCode = ShaderCullingManager.getUniformsDeclarationCode(rawCode);
        Matcher matcher = pattern.matcher(rawCode);
        String result = matcher.replaceAll(uniformsDeclarationCode + toReplace);
        return new StringBuilder(result);
    }

    public static void update() {
        if (!initialized) {
            ShaderCullingManager.init();
        }
        if (PixelCuller.isCullingEnabled) {
            double[] equation = PixelCuller.getActiveCullingPlaneEquation();
            if (equation != null) {
                uniform_equationXYZ.setValue((float)equation[0], (float)equation[1], (float)equation[2]);
                uniform_equationW.setValue((float)equation[3]);
            } else {
                Helper.err("Culling Equation is Null?");
                uniform_equationXYZ.setValue(0.0f, 0.0f, 0.0f);
                uniform_equationW.setValue(2333.0f);
            }
        } else {
            uniform_equationXYZ.setValue(0.0f, 0.0f, 0.0f);
            uniform_equationW.setValue(2333.0f);
        }
    }

    @Deprecated
    public static void loadUniforms() {
        ShaderCullingManager.update();
    }

    public static boolean shouldModifyShaderCode(Program program) {
        String programName = program.getName();
        return programName.equals("gbuffers_textured") || programName.equals("gbuffers_textured_lit") || programName.equals("gbuffers_water") || programName.equals("gbuffers_terrain") || programName.equals("gbuffers_terrain_solid") || programName.equals("gbuffers_terrain_cutout_mip") || programName.equals("gbuffers_terrain_cutout") || programName.equals("gbuffers_block") || programName.equals("gbuffers_item") || programName.equals("gbuffers_entities") || programName.equals("gbuffers_weather");
    }

    private static StringBuilder getUniformsDeclarationCode(StringBuilder rawCode) {
        StringBuilder uniformsDeclarationCode = new StringBuilder();
        if (rawCode.indexOf("gbufferProjectionInverse") == -1) {
            uniformsDeclarationCode.append("uniform mat4 gbufferProjectionInverse;\n");
        }
        if (rawCode.indexOf("gbufferModelViewInverse") == -1) {
            uniformsDeclarationCode.append("uniform mat4 gbufferModelViewInverse;\n");
        }
        if (rawCode.indexOf("uniform float viewWidth") == -1) {
            uniformsDeclarationCode.append("uniform float viewWidth;\n");
            uniformsDeclarationCode.append("uniform float viewHeight;\n");
        }
        return uniformsDeclarationCode;
    }

    static {
        transformation = new ResourceLocation("immersive_portals:shaders/shader_code_transformation.txt");
        cullingEnabled = true;
        initialized = false;
    }
}

