/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.optifine_compatibility;

import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import com.qouteall.immersive_portals.optifine_compatibility.PerDimensionContext;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.optifine.shaders.Shaders;

public class ShaderContextManager {
    private Map<RegistryKey<World>, PerDimensionContext> managedContext = new HashMap<RegistryKey<World>, PerDimensionContext>();
    private Map<RegistryKey<World>, PerDimensionContext> abundantContext = new HashMap<RegistryKey<World>, PerDimensionContext>();
    private RegistryKey<World> currentContextDimension;
    private PerDimensionContext recordedOriginalContext = new PerDimensionContext();
    private PerDimensionContext templateContext;
    private boolean isCleaningUp = false;
    public static boolean doUseDuplicateContextForCurrentDimension = false;
    public static int forceCorrectedNum = 0;

    public boolean isContextSwitched() {
        return this.currentContextDimension != null;
    }

    public void cleanup() {
        this.isCleaningUp = true;
        Helper.log("start cleaning shader context " + this.managedContext.keySet());
        this.managedContext.forEach((dimension, context) -> this.forceSwitchToContextAndRun((PerDimensionContext)context, Shaders::uninit));
        this.managedContext.clear();
        this.abundantContext.forEach((dimension, context) -> this.forceSwitchToContextAndRun((PerDimensionContext)context, Shaders::uninit));
        this.abundantContext.clear();
        this.recordedOriginalContext = new PerDimensionContext();
        this.currentContextDimension = null;
        this.isCleaningUp = false;
    }

    public PerDimensionContext getOrCreateContext(RegistryKey<World> dimension) {
        if (!doUseDuplicateContextForCurrentDimension && this.isContextSwitched() && dimension == ShaderContextManager.getOriginalDimension()) {
            return this.recordedOriginalContext;
        }
        return this.managedContext.computeIfAbsent(dimension, k -> {
            if (this.abundantContext.containsKey(dimension)) {
                Helper.log("Employed abundant context" + k);
                return this.abundantContext.remove(dimension);
            }
            Helper.log("Context object created " + k);
            return this.createContextByTemplate();
        });
    }

    public void switchContextAndRun(Runnable func) {
        RegistryKey<World> oldContextDimension = this.currentContextDimension;
        ClientWorld currentClientWorld = Minecraft.func_71410_x().field_71441_e;
        RegistryKey dimensionToSwitchTo = currentClientWorld.func_234923_W_();
        if (this.currentContextDimension == null) {
            this.currentContextDimension = ShaderContextManager.getOriginalDimension();
            OFGlobal.copyContextToObject.accept(this.recordedOriginalContext);
        }
        if (this.currentContextDimension == dimensionToSwitchTo) {
            this.check((RegistryKey<World>)dimensionToSwitchTo);
            func.run();
        } else {
            this.currentContextDimension = dimensionToSwitchTo;
            PerDimensionContext newContext = this.getOrCreateContext((RegistryKey<World>)dimensionToSwitchTo);
            if (newContext.currentWorld != null) {
                ShaderContextManager.checkState(currentClientWorld, (RegistryKey<World>)dimensionToSwitchTo, newContext);
            }
            this.forceSwitchToContextAndRun(newContext, func);
        }
        this.currentContextDimension = oldContextDimension;
    }

    private void check(RegistryKey<World> dimensionToSwitchTo) {
        RegistryKey shaderCurrentDimension;
        World shadersCurrentWorld = OFGlobal.getCurrentWorld.get();
        if (shadersCurrentWorld != null && (shaderCurrentDimension = shadersCurrentWorld.func_234923_W_()) != dimensionToSwitchTo) {
            Helper.err("Shader Context Abnormal. Shader: " + shaderCurrentDimension + "Main: " + dimensionToSwitchTo);
        }
    }

    private static void checkState(ClientWorld currentClientWorld, RegistryKey<World> dimensionToSwitchTo, PerDimensionContext newContext) {
        RegistryKey newContextDimension = newContext.currentWorld.func_234923_W_();
        if (newContextDimension != dimensionToSwitchTo) {
            Helper.err("Shader Context Abnormal. Shader: " + newContextDimension + "Main: " + dimensionToSwitchTo);
            newContext.currentWorld = currentClientWorld;
            Helper.log("Force corrected");
            if (++forceCorrectedNum > 100) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceSwitchToContextAndRun(PerDimensionContext contextToSwitchTo, Runnable func) {
        PerDimensionContext originalContext = new PerDimensionContext();
        OFGlobal.copyContextToObject.accept(originalContext);
        OFGlobal.copyContextFromObject.accept(contextToSwitchTo);
        try {
            func.run();
        }
        finally {
            OFGlobal.copyContextToObject.accept(contextToSwitchTo);
            OFGlobal.copyContextFromObject.accept(originalContext);
        }
    }

    public boolean isCurrentDimensionRendered() {
        if (this.currentContextDimension == null) {
            return false;
        }
        return RenderStates.isDimensionRendered(this.currentContextDimension);
    }

    public void onPlayerTraveled(RegistryKey<World> from, RegistryKey<World> to) {
        if (this.managedContext.containsKey(from)) {
            assert (!this.abundantContext.containsKey(from));
            this.abundantContext.put(from, this.managedContext.remove(from));
        }
        PerDimensionContext oldContext = new PerDimensionContext();
        OFGlobal.copyContextToObject.accept(oldContext);
        this.managedContext.put(from, oldContext);
        PerDimensionContext newContext = this.getOrCreateContext(to);
        OFGlobal.copyContextFromObject.accept(newContext);
        this.managedContext.remove(to);
        this.check(to);
    }

    public void onShaderUninit() {
        if (!this.isCleaningUp) {
            this.cleanup();
        }
    }

    public void updateTemplateContext() {
        assert (!this.isContextSwitched());
        Shaders.uninit();
        this.cleanup();
        this.templateContext = new PerDimensionContext();
        OFGlobal.copyContextToObject.accept(this.templateContext);
        Helper.log("shader context template updated");
    }

    private PerDimensionContext createContextByTemplate() {
        assert (this.templateContext != null);
        PerDimensionContext newContext = new PerDimensionContext();
        this.forceSwitchToContextAndRun(this.templateContext, () -> OFGlobal.copyContextToObject.accept(newContext));
        newContext.doSpecialInit();
        return newContext;
    }

    public static RegistryKey<World> getOriginalDimension() {
        if (RenderInfo.isRendering()) {
            return RenderStates.originalPlayerDimension;
        }
        return Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_();
    }
}

