/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.optifine_compatibility;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.ducks.IEFrameBuffer;
import com.qouteall.immersive_portals.optifine_compatibility.OFGlobal;
import com.qouteall.immersive_portals.optifine_compatibility.OFHelper;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.render.MyGameRenderer;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PortalRenderer;
import com.qouteall.immersive_portals.render.QueryManager;
import com.qouteall.immersive_portals.render.SecondaryFrameBuffer;
import com.qouteall.immersive_portals.render.ShaderManager;
import com.qouteall.immersive_portals.render.ViewAreaRenderer;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderInfo;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import net.minecraft.client.shader.Framebuffer;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class RendererMixed
extends PortalRenderer {
    private SecondaryFrameBuffer[] deferredFbs = new SecondaryFrameBuffer[0];
    private MatrixStack modelView = new MatrixStack();

    @Override
    public boolean shouldSkipClearing() {
        return false;
    }

    @Override
    public void onRenderCenterEnded(MatrixStack matrixStack) {
        int portalLayer = PortalRendering.getPortalLayer();
        this.initStencilForLayer(portalLayer);
        this.deferredFbs[portalLayer].fb.func_147610_a(true);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        Framebuffer mcFrameBuffer = client.func_147110_a();
        MyRenderHelper.clearAlphaTo1(mcFrameBuffer);
        this.deferredFbs[portalLayer].fb.func_147610_a(true);
        MyRenderHelper.myDrawFrameBuffer(mcFrameBuffer, false, true);
        GL11.glDisable((int)2960);
        MatrixStack effectiveTransformation = this.modelView;
        this.modelView = new MatrixStack();
        this.renderPortals(effectiveTransformation);
    }

    private void initStencilForLayer(int portalLayer) {
        if (portalLayer == 0) {
            this.deferredFbs[portalLayer].fb.func_147610_a(true);
            GlStateManager.func_227766_w_((int)0);
            GL11.glClear((int)1024);
        } else {
            GL30.glBindFramebuffer((int)36008, (int)this.deferredFbs[portalLayer - 1].fb.field_147616_f);
            GL30.glBindFramebuffer((int)36009, (int)this.deferredFbs[portalLayer].fb.field_147616_f);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.deferredFbs[0].fb.field_147621_c, (int)this.deferredFbs[0].fb.field_147618_d, (int)0, (int)0, (int)this.deferredFbs[0].fb.field_147621_c, (int)this.deferredFbs[0].fb.field_147618_d, (int)1024, (int)9728);
        }
    }

    @Override
    public void onBeforeTranslucentRendering(MatrixStack matrixStack) {
    }

    @Override
    public void onAfterTranslucentRendering(MatrixStack matrixStack) {
        OFHelper.copyFromShaderFbTo(this.deferredFbs[PortalRendering.getPortalLayer()].fb, 256);
        this.modelView.func_227860_a_();
        this.modelView.func_227866_c_().func_227870_a_().func_226595_a_(matrixStack.func_227866_c_().func_227870_a_());
        this.modelView.func_227866_c_().func_227872_b_().func_226118_b_(matrixStack.func_227866_c_().func_227872_b_());
    }

    @Override
    public void prepareRendering() {
        if (CGlobal.shaderManager == null) {
            CGlobal.shaderManager = new ShaderManager();
        }
        if (this.deferredFbs.length != PortalRendering.getMaxPortalLayer() + 1) {
            for (SecondaryFrameBuffer fb : this.deferredFbs) {
                fb.fb.func_147608_a();
            }
            this.deferredFbs = new SecondaryFrameBuffer[PortalRendering.getMaxPortalLayer() + 1];
            for (int i = 0; i < this.deferredFbs.length; ++i) {
                this.deferredFbs[i] = new SecondaryFrameBuffer();
            }
        }
        for (SecondaryFrameBuffer deferredFb : this.deferredFbs) {
            deferredFb.prepare();
            ((IEFrameBuffer)deferredFb.fb).setIsStencilBufferEnabledAndReload(true);
            deferredFb.fb.func_147610_a(true);
            GlStateManager.func_227673_b_((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_227631_a_((double)1.0);
            GlStateManager.func_227766_w_((int)0);
            GL11.glClear((int)17664);
        }
        OFGlobal.bindToShaderFrameBuffer.run();
    }

    @Override
    public void finishRendering() {
        GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Shaders.useProgram((Program)Shaders.ProgramNone);
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        Framebuffer mainFrameBuffer = client.func_147110_a();
        mainFrameBuffer.func_147610_a(true);
        this.deferredFbs[0].fb.func_147615_c(mainFrameBuffer.field_147621_c, mainFrameBuffer.field_147618_d);
        CHelper.checkGlError();
    }

    @Override
    protected void doRenderPortal(Portal portal, MatrixStack matrixStack) {
        RendererMixed.client.field_71460_t.func_228379_a_(RenderStates.projectionMatrix);
        if (!this.tryRenderViewAreaInDeferredBufferAndIncreaseStencil(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        OFGlobal.bindToShaderFrameBuffer.run();
        this.renderPortalContent(portal);
        int innerLayer = PortalRendering.getPortalLayer();
        PortalRendering.popPortalLayer();
        int outerLayer = PortalRendering.getPortalLayer();
        if (innerLayer > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        this.deferredFbs[outerLayer].fb.func_147610_a(true);
        MyRenderHelper.myDrawFrameBuffer(this.deferredFbs[innerLayer].fb, true, true);
    }

    private boolean tryRenderViewAreaInDeferredBufferAndIncreaseStencil(Portal portal, MatrixStack matrixStack) {
        int portalLayer = PortalRendering.getPortalLayer();
        this.initStencilForLayer(portalLayer);
        this.deferredFbs[portalLayer].fb.func_147610_a(true);
        GL20.glUseProgram((int)0);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GlStateManager.func_227734_k_();
        boolean result = QueryManager.renderAndGetDoesAnySamplePassed(() -> ViewAreaRenderer.drawPortalViewTriangle(portal, matrixStack, true, true));
        GL11.glDisable((int)2960);
        OFGlobal.bindToShaderFrameBuffer.run();
        return result;
    }

    @Override
    public void invokeWorldRendering(RenderInfo renderInfo) {
        MyGameRenderer.renderWorldNew(renderInfo, runnable -> OFGlobal.shaderContextManager.switchContextAndRun(() -> {
            OFGlobal.bindToShaderFrameBuffer.run();
            runnable.run();
        }));
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }
}

