/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.network;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.CHelper;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ducks.IEClientPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEClientWorld;
import com.qouteall.immersive_portals.ducks.IEParticleManager;
import com.qouteall.immersive_portals.my_util.LimitedLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public class CommonNetwork {
    public static final Minecraft client = Minecraft.func_71410_x();
    private static final LimitedLogger limitedLogger = new LimitedLogger(100);
    private static boolean isProcessingRedirectedMessage = false;

    public static boolean getIsProcessingRedirectedMessage() {
        return isProcessingRedirectedMessage;
    }

    public static void processRedirectedPacket(RegistryKey<World> dimension, IPacket packet) {
        Runnable func = () -> {
            try {
                client.func_213239_aq().func_76320_a("process_redirected_packet");
                ClientWorld packetWorld = CGlobal.clientWorldLoader.getWorld(dimension);
                CommonNetwork.doProcessRedirectedMessage(packetWorld, packet);
            }
            finally {
                client.func_213239_aq().func_76319_b();
            }
        };
        CHelper.executeOnRenderThread(func);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcessRedirectedMessage(ClientWorld packetWorld, IPacket packet) {
        boolean oldIsProcessing = isProcessingRedirectedMessage;
        isProcessingRedirectedMessage = true;
        ClientPlayNetHandler netHandler = ((IEClientWorld)packetWorld).getNetHandler();
        if (netHandler.func_195514_j() != packetWorld) {
            ((IEClientPlayNetworkHandler)netHandler).setWorld(packetWorld);
            Helper.err("The world field of client net handler is wrong");
        }
        client.func_213239_aq().func_194340_a(() -> "handle_redirected_packet" + packetWorld.func_234923_W_() + packet);
        try {
            CommonNetwork.withSwitchedWorld(packetWorld, () -> packet.func_148833_a((INetHandler)netHandler));
        }
        catch (Throwable e) {
            limitedLogger.throwException(() -> new IllegalStateException("handling packet in " + packetWorld.func_234923_W_(), e));
        }
        finally {
            client.func_213239_aq().func_76319_b();
            isProcessingRedirectedMessage = oldIsProcessing;
        }
    }

    public static void withSwitchedWorld(ClientWorld newWorld, Runnable runnable) {
        ClientWorld originalWorld = CommonNetwork.client.field_71441_e;
        CommonNetwork.client.field_71441_e = newWorld;
        ((IEParticleManager)CommonNetwork.client.field_71452_i).mySetWorld(newWorld);
        try {
            runnable.run();
        }
        finally {
            if (CommonNetwork.client.field_71441_e != newWorld) {
                Helper.err("oops, respawn packet should not be redirected");
                originalWorld = CommonNetwork.client.field_71441_e;
            }
            CommonNetwork.client.field_71441_e = originalWorld;
            ((IEParticleManager)CommonNetwork.client.field_71452_i).mySetWorld(originalWorld);
        }
    }
}

