/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.my_util;

import com.qouteall.immersive_portals.Helper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SignalArged<Arg> {
    private List<Consumer<Arg>> funcList = new ArrayList<Consumer<Arg>>();
    private boolean isEmitting = false;

    public void emit(Arg arg) {
        this.isEmitting = true;
        try {
            this.funcList.forEach(runnable -> runnable.accept(arg));
        }
        finally {
            this.isEmitting = false;
        }
    }

    public <T> void connectWithWeakRef(T owner, BiConsumer<T, Arg> func) {
        WeakReference weakRef = new WeakReference(owner);
        Helper.SimpleBox<Object> boxOfRunnable = new Helper.SimpleBox<Object>(null);
        boxOfRunnable.obj = arg -> {
            Object currentTarget = weakRef.get();
            if (currentTarget != null) {
                func.accept(currentTarget, arg);
            } else {
                this.disconnect((Consumer)boxOfRunnable.obj);
            }
        };
        this.connect((Consumer)boxOfRunnable.obj);
    }

    public void connect(Consumer<Arg> func) {
        this.copyDataWhenEmitting();
        this.funcList.add(func);
    }

    public void disconnect(Consumer<Arg> func) {
        this.copyDataWhenEmitting();
        boolean removed = this.funcList.remove(func);
        assert (removed);
    }

    private void copyDataWhenEmitting() {
        if (this.isEmitting) {
            this.funcList = new ArrayList<Consumer<Arg>>(this.funcList);
        }
    }
}

