/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.my_util;

import com.qouteall.immersive_portals.Helper;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.Validate;

public class IntBox {
    public final BlockPos l;
    public final BlockPos h;

    public IntBox(BlockPos l, BlockPos h) {
        this.l = Helper.min(l, h);
        this.h = Helper.max(l, h);
    }

    public static IntBox getBoxByBasePointAndSize(BlockPos areaSize, BlockPos blockPos) {
        return new IntBox(blockPos, blockPos.func_177971_a((Vector3i)areaSize).func_177982_a(-1, -1, -1));
    }

    public IntBox expandOrShrink(Vector3i offset) {
        return new IntBox(this.l.func_177973_b(offset), this.h.func_177971_a(offset));
    }

    public IntBox getExpanded(Direction.Axis axis, int n) {
        return this.expandOrShrink((Vector3i)Helper.scale(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176730_m(), n));
    }

    public IntBox getExpanded(Direction direction, int n) {
        if (direction.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            return new IntBox(this.l, this.h.func_177971_a((Vector3i)Helper.scale(direction.func_176730_m(), n)));
        }
        return new IntBox(this.l.func_177971_a((Vector3i)Helper.scale(direction.func_176730_m(), n)), this.h);
    }

    public Stream<BlockPos> stream() {
        return IntStream.range(this.l.func_177958_n(), this.h.func_177958_n() + 1).boxed().flatMap(x -> IntStream.range(this.l.func_177956_o(), this.h.func_177956_o() + 1).boxed().flatMap(y -> IntStream.range(this.l.func_177952_p(), this.h.func_177952_p() + 1).boxed().map(z -> new BlockPos(x.intValue(), y.intValue(), z.intValue()))));
    }

    public Stream<BlockPos> fastStream() {
        return BlockPos.func_218281_b((BlockPos)this.l, (BlockPos)this.h);
    }

    public BlockPos getSize() {
        return this.h.func_177982_a(1, 1, 1).func_177973_b((Vector3i)this.l);
    }

    public IntBox getSurfaceLayer(Direction.Axis axis, Direction.AxisDirection axisDirection) {
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            IntBox result = new IntBox(this.l, new BlockPos((axis == Direction.Axis.X ? this.l : this.h).func_177958_n(), (axis == Direction.Axis.Y ? this.l : this.h).func_177956_o(), (axis == Direction.Axis.Z ? this.l : this.h).func_177952_p()));
            return result;
        }
        IntBox result = new IntBox(new BlockPos((axis == Direction.Axis.X ? this.h : this.l).func_177958_n(), (axis == Direction.Axis.Y ? this.h : this.l).func_177956_o(), (axis == Direction.Axis.Z ? this.h : this.l).func_177952_p()), this.h);
        return result;
    }

    public IntBox getSurfaceLayer(Direction facing) {
        return this.getSurfaceLayer(facing.func_176740_k(), facing.func_176743_c());
    }

    @Nullable
    public static IntBox getIntersect(IntBox a, IntBox b) {
        BlockPos l = Helper.max(a.l, b.l);
        BlockPos h = Helper.min(a.h, b.h);
        if (l.func_177958_n() > h.func_177958_n()) {
            return null;
        }
        if (l.func_177956_o() > h.func_177956_o()) {
            return null;
        }
        if (l.func_177952_p() > h.func_177952_p()) {
            return null;
        }
        return new IntBox(l, h);
    }

    public IntBox map(Function<BlockPos, BlockPos> func1, Function<BlockPos, BlockPos> func2) {
        return new IntBox(func1.apply(this.l), func2.apply(this.h));
    }

    public BlockPos getCenter() {
        return Helper.divide((Vector3i)this.l.func_177971_a((Vector3i)this.h), 2);
    }

    public Vector3d getCenterVec() {
        return new Vector3d((double)(this.l.func_177958_n() + this.h.func_177958_n() + 1) / 2.0, (double)(this.l.func_177956_o() + this.h.func_177956_o() + 1) / 2.0, (double)(this.l.func_177952_p() + this.h.func_177952_p() + 1) / 2.0);
    }

    public IntBox getAdjusted(int dxa, int dya, int dza, int dxb, int dyb, int dzb) {
        return new IntBox(this.l.func_177982_a(dxa, dya, dza), this.h.func_177982_a(dxb, dyb, dzb));
    }

    public Stream<BlockPos> forSixSurfaces(Function<Stream<IntBox>, Stream<IntBox>> mapper) {
        IntBox[] array = new IntBox[]{this.getSurfaceLayer(Direction.DOWN), this.getSurfaceLayer(Direction.NORTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.SOUTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.WEST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.EAST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.UP).getAdjusted(1, 0, 1, -1, 0, -1)};
        return mapper.apply(Arrays.stream(array).filter(intBox -> true)).flatMap(IntBox::stream);
    }

    public IntBox getMoved(Vector3i offset) {
        return new IntBox(this.l.func_177971_a(offset), this.h.func_177971_a(offset));
    }

    public static IntBox getContainingBox(IntBox box1, IntBox box2) {
        return new IntBox(Helper.min(box1.l, box2.l), Helper.max(box1.h, box2.h));
    }

    public IntBox getSubBoxInCenter(BlockPos subBoxSize) {
        BlockPos thisSize = this.getSize();
        Validate.isTrue((thisSize.func_177958_n() >= subBoxSize.func_177958_n() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.func_177956_o() >= subBoxSize.func_177956_o() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.func_177952_p() >= subBoxSize.func_177952_p() ? 1 : 0) != 0);
        return IntBox.getBoxByBasePointAndSize(subBoxSize, Helper.divide((Vector3i)thisSize.func_177973_b((Vector3i)subBoxSize), 2).func_177971_a((Vector3i)this.l));
    }

    public BlockPos[] getEightVertices() {
        return new BlockPos[]{new BlockPos(this.l.func_177958_n(), this.l.func_177956_o(), this.l.func_177952_p()), new BlockPos(this.l.func_177958_n(), this.l.func_177956_o(), this.h.func_177952_p()), new BlockPos(this.l.func_177958_n(), this.h.func_177956_o(), this.l.func_177952_p()), new BlockPos(this.l.func_177958_n(), this.h.func_177956_o(), this.h.func_177952_p()), new BlockPos(this.h.func_177958_n(), this.l.func_177956_o(), this.l.func_177952_p()), new BlockPos(this.h.func_177958_n(), this.l.func_177956_o(), this.h.func_177952_p()), new BlockPos(this.h.func_177958_n(), this.h.func_177956_o(), this.l.func_177952_p()), new BlockPos(this.h.func_177958_n(), this.h.func_177956_o(), this.h.func_177952_p())};
    }

    public AxisAlignedBB toRealNumberBox() {
        return new AxisAlignedBB((double)this.l.func_177958_n(), (double)this.l.func_177956_o(), (double)this.l.func_177952_p(), (double)(this.h.func_177958_n() + 1), (double)(this.h.func_177956_o() + 1), (double)(this.h.func_177952_p() + 1));
    }

    public IntBox getExpanded(BlockPos newPoint) {
        return new IntBox(Helper.min(this.l, newPoint), Helper.max(this.h, newPoint));
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.l.func_177958_n() && pos.func_177958_n() <= this.h.func_177958_n() && pos.func_177956_o() >= this.l.func_177956_o() && pos.func_177956_o() <= this.h.func_177956_o() && pos.func_177952_p() >= this.l.func_177952_p() && pos.func_177952_p() <= this.h.func_177952_p();
    }

    public String toString() {
        return String.format("(%d %d %d)-(%d %d %d)", this.l.func_177958_n(), this.l.func_177956_o(), this.l.func_177952_p(), this.h.func_177958_n(), this.h.func_177956_o(), this.h.func_177952_p());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBox intBox = (IntBox)o;
        return this.l.equals((Object)intBox.l) && this.h.equals((Object)intBox.h);
    }

    public int hashCode() {
        return Objects.hash(this.l, this.h);
    }
}

