/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.my_util;

import java.util.Objects;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;

public class DQuaternion {
    public final double x;
    public final double y;
    public final double z;
    public final double w;

    public DQuaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public static DQuaternion fromMcQuaternion(Quaternion quaternion) {
        return new DQuaternion(quaternion.func_195889_a(), quaternion.func_195891_b(), quaternion.func_195893_c(), quaternion.func_195894_d());
    }

    public Vector3d getRotatingAxis() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Quaternion toMcQuaternion() {
        return new Quaternion((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public static DQuaternion rotationByDegrees(Vector3d rotatingAxis, double degrees) {
        return DQuaternion.rotationByRadians(rotatingAxis, Math.toRadians(degrees));
    }

    public static DQuaternion rotationByRadians(Vector3d axis, double rotationAngle) {
        double s = Math.sin(rotationAngle / 2.0);
        return new DQuaternion(axis.func_82615_a() * s, axis.func_82617_b() * s, axis.func_82616_c() * s, Math.cos(rotationAngle / 2.0));
    }

    public Vector3d rotate(Vector3d vec) {
        DQuaternion result = this.hamiltonProduct(new DQuaternion(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0)).hamiltonProduct(this.getConjugated());
        return result.getRotatingAxis();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public DQuaternion hamiltonProduct(DQuaternion other) {
        double x1 = this.getX();
        double y1 = this.getY();
        double z1 = this.getZ();
        double w1 = this.getW();
        double x2 = other.getX();
        double y2 = other.getY();
        double z2 = other.getZ();
        double w2 = other.getW();
        return new DQuaternion(w1 * x2 + x1 * w2 + y1 * z2 - z1 * y2, w1 * y2 - x1 * z2 + y1 * w2 + z1 * x2, w1 * z2 + x1 * y2 - y1 * x2 + z1 * w2, w1 * w2 - x1 * x2 - y1 * y2 - z1 * z2);
    }

    public DQuaternion getConjugated() {
        return new DQuaternion(-this.x, -this.y, -this.z, this.w);
    }

    public DQuaternion multiply(double val) {
        return new DQuaternion(this.x * val, this.y * val, this.z * val, this.w * val);
    }

    public DQuaternion add(DQuaternion q) {
        return new DQuaternion(this.x + q.x, this.y + q.y, this.z + q.z, this.w + q.w);
    }

    public double dotProduct(DQuaternion q) {
        return this.getX() * q.getX() + this.getY() * q.getY() + this.getZ() * q.getZ() + this.getW() * q.getW();
    }

    public DQuaternion getNormalized() {
        double lenSq = this.dotProduct(this);
        if (lenSq != 0.0) {
            double len = Math.sqrt(lenSq);
            return this.multiply(1.0 / len);
        }
        return new DQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    public static DQuaternion getCameraRotation(double pitch, double yaw) {
        DQuaternion r1 = DQuaternion.rotationByDegrees(new Vector3d(1.0, 0.0, 0.0), pitch);
        DQuaternion r2 = DQuaternion.rotationByDegrees(new Vector3d(0.0, 1.0, 0.0), yaw + 180.0);
        DQuaternion result = r1.hamiltonProduct(r2);
        return result;
    }

    public static DQuaternion getCameraRotation1(double pitch, double yaw) {
        double p = Math.toRadians(pitch) / 2.0;
        double y = Math.toRadians(yaw) / 2.0;
        return new DQuaternion(-Math.sin(p) * Math.sin(y), Math.cos(p) * Math.cos(y), Math.sin(p) * Math.cos(y), -Math.cos(p) * Math.sin(y));
    }

    public static boolean isClose(DQuaternion a, DQuaternion b, double valve) {
        double dd;
        double dc;
        double db;
        double da;
        if (a.getW() * b.getW() < 0.0) {
            a = a.multiply(-1.0);
        }
        return (da = a.getX() - b.getX()) * da + (db = a.getY() - b.getY()) * db + (dc = a.getZ() - b.getZ()) * dc + (dd = a.getW() - b.getW()) * dd < valve;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DQuaternion that = (DQuaternion)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Double.compare(that.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return String.format("DQuaternion{x=%s, y=%s, z=%s, w=%s}", this.x, this.y, this.z, this.w);
    }

    public static DQuaternion interpolate(DQuaternion a, DQuaternion b, double t) {
        double DOT_THRESHOLD;
        double dot = a.dotProduct(b);
        if (dot < 0.0) {
            a = a.multiply(-1.0);
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            return a.multiply(1.0 - t).add(b.multiply(t)).getNormalized();
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        double s0 = Math.cos(theta) - dot * sin_theta / sin_theta_0;
        double s1 = sin_theta / sin_theta_0;
        return a.multiply(s0).add(b.multiply(s1));
    }

    public static Tuple<Double, Double> getPitchYawFromRotation(DQuaternion quaternion) {
        double x = quaternion.getX();
        double y = quaternion.getY();
        double z = quaternion.getZ();
        double w = quaternion.getW();
        double cosYaw = 2.0 * (y * y + z * z) - 1.0;
        double sinYaw = -(x * z + y * w) * 2.0;
        double cosPitch = 1.0 - 2.0 * (x * x + z * z);
        double sinPitch = (x * w + y * z) * 2.0;
        return new Tuple((Object)Math.toDegrees(Math.atan2(sinPitch, cosPitch)), (Object)Math.toDegrees(Math.atan2(sinYaw, cosYaw)));
    }
}

