/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin_client.sync;

import com.mojang.authlib.GameProfile;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.dimension_sync.DimensionTypeSync;
import com.qouteall.immersive_portals.ducks.IEBuiltChunk;
import com.qouteall.immersive_portals.ducks.IEClientPlayNetworkHandler;
import com.qouteall.immersive_portals.ducks.IEPlayerPositionLookS2CPacket;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.network.NetworkAdapt;
import com.qouteall.immersive_portals.render.MyBuiltChunkStorage;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public abstract class MixinClientPlayNetworkHandler
implements IEClientPlayNetworkHandler {
    @Shadow
    private ClientWorld field_147300_g;
    @Shadow
    private boolean field_147309_h;
    @Shadow
    private Minecraft field_147299_f;
    @Mutable
    @Shadow
    @Final
    private Map<UUID, NetworkPlayerInfo> field_147310_i;
    @Shadow
    private DynamicRegistries field_239163_t_;
    private boolean isReProcessingPassengerPacket;

    @Shadow
    public abstract void func_184328_a(SSetPassengersPacket var1);

    @Override
    public void setWorld(ClientWorld world) {
        this.field_147300_g = world;
    }

    @Override
    public Map getPlayerListEntries() {
        return this.field_147310_i;
    }

    @Override
    public void setPlayerListEntries(Map value) {
        this.field_147310_i = value;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(Minecraft minecraftClient_1, Screen screen_1, NetworkManager clientConnection_1, GameProfile gameProfile_1, CallbackInfo ci) {
        this.isReProcessingPassengerPacket = false;
    }

    @Inject(method={"Lnet/minecraft/client/network/play/ClientPlayNetHandler;handleJoinGame(Lnet/minecraft/network/play/server/SJoinGamePacket;)V"}, at={@At(value="RETURN")})
    private void onOnGameJoin(SJoinGamePacket packet, CallbackInfo ci) {
        DimensionTypeSync.onGameJoinPacketReceived(packet.func_240817_g_());
    }

    @Inject(method={"Lnet/minecraft/client/network/play/ClientPlayNetHandler;handlePlayerPosLook(Lnet/minecraft/network/play/server/SPlayerPositionLookPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/IPacket;Lnet/minecraft/network/INetHandler;Lnet/minecraft/util/concurrent/ThreadTaskExecutor;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onProcessingPositionPacket(SPlayerPositionLookPacket packet, CallbackInfo ci) {
        if (!NetworkAdapt.doesServerHasIP()) {
            return;
        }
        if (!this.field_147309_h) {
            return;
        }
        RegistryKey<World> playerDimension = ((IEPlayerPositionLookS2CPacket)packet).getPlayerDimension();
        ClientWorld world = this.field_147299_f.field_71441_e;
        if (world != null && world.func_230315_m_() != null && world.func_234923_W_() != playerDimension && !Minecraft.func_71410_x().field_71439_g.field_70128_L) {
            Helper.log(String.format("denied position packet %s %s %s %s", ((IEPlayerPositionLookS2CPacket)packet).getPlayerDimension(), packet.func_148932_c(), packet.func_148928_d(), packet.func_148933_e()));
            ci.cancel();
        }
        CGlobal.clientTeleportationManager.disableTeleportFor(20);
    }

    @Inject(method={"Lnet/minecraft/client/network/play/ClientPlayNetHandler;handleSetPassengers(Lnet/minecraft/network/play/server/SSetPassengersPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/IPacket;Lnet/minecraft/network/INetHandler;Lnet/minecraft/util/concurrent/ThreadTaskExecutor;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onOnEntityPassengersSet(SSetPassengersPacket entityPassengersSetS2CPacket_1, CallbackInfo ci) {
        Entity entity_1 = this.field_147300_g.func_73045_a(entityPassengersSetS2CPacket_1.func_186972_b());
        if (entity_1 == null && !this.isReProcessingPassengerPacket) {
            Helper.log("Re-processed riding packet");
            ModMain.clientTaskList.addTask(() -> {
                this.isReProcessingPassengerPacket = true;
                this.func_184328_a(entityPassengersSetS2CPacket_1);
                this.isReProcessingPassengerPacket = false;
                return true;
            });
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/client/network/play/ClientPlayNetHandler;processChunkUnload(Lnet/minecraft/network/play/server/SUnloadChunkPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkProvider;getLightManager()Lnet/minecraft/world/lighting/WorldLightManager;")}, cancellable=true)
    private void onOnUnload(SUnloadChunkPacket packet, CallbackInfo ci) {
        if (CGlobal.smoothChunkUnload) {
            DimensionalChunkPos pos = new DimensionalChunkPos((RegistryKey<World>)this.field_147300_g.func_234923_W_(), packet.func_186940_a(), packet.func_186941_b());
            WorldRenderer worldRenderer = CGlobal.clientWorldLoader.getWorldRenderer((RegistryKey<World>)this.field_147300_g.func_234923_W_());
            ViewFrustum storage = ((IEWorldRenderer)worldRenderer).getBuiltChunkStorage();
            if (storage instanceof MyBuiltChunkStorage) {
                for (int y = 0; y < 16; ++y) {
                    ChunkRenderDispatcher.ChunkRender builtChunk = ((MyBuiltChunkStorage)storage).provideBuiltChunk(new BlockPos(packet.func_186940_a() * 16, y * 16, packet.func_186941_b() * 16));
                    ((IEBuiltChunk)builtChunk).fullyReset();
                }
            }
            int[] counter = new int[]{(int)(Math.random() * 200.0)};
            ModMain.clientTaskList.addTask(() -> {
                ClientWorld world1 = CGlobal.clientWorldLoader.getWorld(pos.dimension);
                if (world1.func_72863_F().func_73149_a(pos.x, pos.z)) {
                    return true;
                }
                if (counter[0] > 0) {
                    counter[0] = counter[0] - 1;
                    return false;
                }
                IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
                profiler.func_76320_a("delayed_unload");
                for (int y = 0; y < 16; ++y) {
                    world1.func_225524_e_().func_215566_a(SectionPos.func_218154_a((int)pos.x, (int)y, (int)pos.z), true);
                }
                world1.func_225524_e_().func_215571_a(pos.getChunkPos(), false);
                profiler.func_76319_b();
                return true;
            });
            ci.cancel();
        }
    }

    @Override
    public void initScreenIfNecessary() {
        if (!this.field_147309_h) {
            this.field_147309_h = true;
            this.field_147299_f.func_147108_a((Screen)null);
        }
    }

    @Override
    public void portal_setRegistryManager(DynamicRegistries arg) {
        this.field_239163_t_ = arg;
    }
}

