/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin_client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ClientWorldLoader;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.OFInterface;
import com.qouteall.immersive_portals.ducks.IEWorldRenderer;
import com.qouteall.immersive_portals.portal.global_portals.GlobalTrackedPortal;
import com.qouteall.immersive_portals.render.CrossPortalEntityRenderer;
import com.qouteall.immersive_portals.render.MyBuiltChunkStorage;
import com.qouteall.immersive_portals.render.MyGameRenderer;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PixelCuller;
import com.qouteall.immersive_portals.render.TransformationManager;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderDimensionRedirect;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer
implements IEWorldRenderer {
    @Shadow
    private ClientWorld field_72769_h;
    @Shadow
    @Final
    private EntityRendererManager field_175010_j;
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    private double field_147596_f;
    @Shadow
    private double field_147597_g;
    @Shadow
    private double field_147602_h;
    @Shadow
    private ViewFrustum field_175008_n;
    @Mutable
    @Shadow
    @Final
    private ObjectList<?> field_72755_R;
    @Shadow
    private int field_72739_F;
    @Shadow
    private boolean field_147595_R;
    @Shadow
    private VertexBuffer field_175012_t;
    @Shadow
    @Final
    private VertexFormat field_175014_r;
    @Shadow
    @Final
    private TextureManager field_72770_i;
    @Shadow
    private VertexBuffer field_175011_u;
    @Shadow
    private ChunkRenderDispatcher field_174995_M;
    @Shadow
    private Set<ChunkRenderDispatcher.ChunkRender> field_175009_l;
    @Shadow
    private ShaderGroup field_239227_K_;
    private static boolean isReloadingOtherWorldRenderers = false;

    @Shadow
    protected abstract void func_228441_a_(RenderType var1, MatrixStack var2, double var3, double var5, double var7);

    @Shadow
    protected abstract void func_228418_a_(Entity var1, double var2, double var4, double var6, float var8, MatrixStack var9, IRenderTypeBuffer var10);

    @Shadow
    protected abstract void func_174967_a(long var1);

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/IRenderTypeBuffer$Impl;finish()V", ordinal=0, shift=At.Shift.AFTER)})
    private void onBeforeTranslucentRendering(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        CGlobal.renderer.onBeforeTranslucentRendering(matrices);
        MyGameRenderer.updateFogColor();
        MyGameRenderer.resetFogState();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="RETURN")})
    private void onAfterTranslucentRendering(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        CrossPortalEntityRenderer.onEndRenderingEntities(matrices);
        CGlobal.renderer.onAfterTranslucentRendering(matrices);
        RenderHelper.func_227781_a_((Matrix4f)matrices.func_227866_c_().func_227870_a_());
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderBlockLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/matrix/MatrixStack;DDD)V")})
    private void onBeforeRenderingLayer(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            PixelCuller.updateCullingPlaneInner(matrices, PortalRendering.getRenderingPortal(), true);
            PixelCuller.startCulling();
            if (PortalRendering.isRenderingOddNumberOfMirrors()) {
                MyRenderHelper.applyMirrorFaceCulling();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderBlockLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/matrix/MatrixStack;DDD)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingLayer(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            PixelCuller.endCulling();
            MyRenderHelper.recoverFaceCulling();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;getSolid()Lnet/minecraft/client/renderer/RenderType;")})
    private void onBeginRenderingSolid(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        MyGameRenderer.doPruneVisibleChunks(this.field_72755_R);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/DimensionRenderInfo;func_239217_c_()Z")})
    private void onAfterCutoutRendering(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        CrossPortalEntityRenderer.onBeginRenderingEntities(matrices);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V"))
    private void redirectClearing(int int_1, boolean boolean_1) {
        if (!CGlobal.renderer.shouldSkipClearing()) {
            RenderSystem.clear((int)int_1, (boolean)boolean_1);
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;loadRenderers()V"}, at=@At(value="NEW", target="net/minecraft/client/renderer/ViewFrustum"))
    private ViewFrustum redirectConstructingBuildChunkStorage(ChunkRenderDispatcher chunkBuilder_1, World world_1, int int_1, WorldRenderer worldRenderer_1) {
        if (CGlobal.useHackedChunkRenderDispatcher) {
            return new MyBuiltChunkStorage(chunkBuilder_1, world_1, int_1, worldRenderer_1);
        }
        return new ViewFrustum(chunkBuilder_1, world_1, int_1, worldRenderer_1);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ActiveRenderInfo;isThirdPerson()Z"))
    private boolean redirectIsThirdPerson(ActiveRenderInfo camera) {
        if (CrossPortalEntityRenderer.shouldRenderPlayerItself()) {
            return true;
        }
        return camera.func_216770_i();
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderEntity(Lnet/minecraft/entity/Entity;DDDFLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;)V"))
    private void redirectRenderEntity(WorldRenderer worldRenderer, Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider) {
        ActiveRenderInfo camera = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        if (entity == camera.func_216773_g() && CrossPortalEntityRenderer.shouldRenderPlayerItself()) {
            MyGameRenderer.renderPlayerItself(() -> {
                double distanceToCamera = entity.func_174824_e(RenderStates.tickDelta).func_72438_d(this.field_72777_q.field_71460_t.func_215316_n().func_216785_c());
                if (distanceToCamera > 1.0 || PortalRendering.isRenderingOddNumberOfMirrors()) {
                    CrossPortalEntityRenderer.beforeRenderingEntity(entity, matrixStack);
                    this.func_228418_a_(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
                    CrossPortalEntityRenderer.afterRenderingEntity(entity);
                }
            });
            return;
        }
        CrossPortalEntityRenderer.beforeRenderingEntity(entity, matrixStack);
        this.func_228418_a_(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
        CrossPortalEntityRenderer.afterRenderingEntity(entity);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderRainSnow(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void beforeRenderingWeather(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            PixelCuller.updateCullingPlaneInner(matrices, PortalRendering.getRenderingPortal(), true);
            PixelCuller.startCulling();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderRainSnow(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void afterRenderingWeather(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            PixelCuller.endCulling();
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;func_238206_b_(Lnet/minecraft/entity/Entity;)Z"))
    private boolean redirectGlowing(Minecraft client, Entity entity) {
        if (PortalRendering.isRendering()) {
            return false;
        }
        return client.func_238206_b_(entity);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;loadRenderers()V"}, at={@At(value="TAIL")})
    private void onReload(CallbackInfo ci) {
        ClientWorldLoader clientWorldLoader = CGlobal.clientWorldLoader;
        WorldRenderer this_ = (WorldRenderer)this;
        if (isReloadingOtherWorldRenderers) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        if (clientWorldLoader.getIsLoadingFakedWorld()) {
            return;
        }
        if (this_ != Minecraft.func_71410_x().field_71438_f) {
            return;
        }
        isReloadingOtherWorldRenderers = true;
        for (WorldRenderer worldRenderer : clientWorldLoader.worldRendererMap.values()) {
            if (worldRenderer == this_) continue;
            worldRenderer.func_72712_a();
        }
        isReloadingOtherWorldRenderers = false;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at={@At(value="HEAD")})
    private void onRenderSkyBegin(MatrixStack matrixStack_1, float float_1, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            ((RenderType)RenderType.func_228661_n_().get(0)).func_228547_a_();
            ((RenderType)RenderType.func_228661_n_().get(0)).func_228549_b_();
            if (OFInterface.isFogDisabled.getAsBoolean()) {
                GL11.glEnable((int)2912);
            }
        }
        if (PortalRendering.isRenderingOddNumberOfMirrors()) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WorldRenderer;SUN_TEXTURES:Lnet/minecraft/util/ResourceLocation;")})
    private void onStartRenderingSun(MatrixStack matrixStack, float f, CallbackInfo ci) {
        if (OFInterface.isFogDisabled.getAsBoolean()) {
            GL11.glDisable((int)2912);
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at={@At(value="RETURN")})
    private void onRenderSkyEnd(MatrixStack matrixStack_1, float float_1, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            GL11.glDisable((int)2912);
            RenderSystem.enableFog();
            RenderSystem.disableFog();
        }
        MyRenderHelper.recoverFaceCulling();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at={@At(value="HEAD")})
    private void onBeforeRender(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        TransformationManager.processTransformation(camera, matrices);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;updateChunks(J)V"))
    private void redirectUpdateChunks(WorldRenderer worldRenderer, long limitTime) {
        if (PortalRendering.isRendering() && !OFInterface.isOptifinePresent) {
            this.portal_updateChunks();
        } else {
            this.func_174967_a(limitTime);
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/WorldRenderer;updateCameraAndRender(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"))
    private void redirectRenderSky(WorldRenderer worldRenderer, MatrixStack matrixStack, float f) {
        if (Global.edgelessSky && PortalRendering.isRendering() && PortalRendering.getRenderingPortal() instanceof GlobalTrackedPortal) {
            MyGameRenderer.renderSkyFor(RenderDimensionRedirect.getRedirectedDimension(RenderStates.originalPlayerDimension), matrixStack, f);
            return;
        }
        if (OFInterface.isShaders.getAsBoolean()) {
            RegistryKey dim = Minecraft.func_71410_x().field_71441_e.func_234923_W_();
            RegistryKey<World> redirectedDimension = RenderDimensionRedirect.getRedirectedDimension((RegistryKey<World>)dim);
            MyGameRenderer.renderSkyFor(redirectedDimension, matrixStack, f);
            return;
        }
        worldRenderer.func_228424_a_(matrixStack, f);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/WorldRenderer;renderClouds(Lcom/mojang/blaze3d/matrix/MatrixStack;FDDD)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;enableFog()V", shift=At.Shift.AFTER)})
    private void onEnableFogInRenderClouds(MatrixStack matrices, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (OFInterface.isFogDisabled.getAsBoolean()) {
            MyGameRenderer.forceResetFogState();
            GL11.glEnable((int)2912);
        }
    }

    @Override
    public EntityRendererManager getEntityRenderDispatcher() {
        return this.field_175010_j;
    }

    @Override
    public ViewFrustum getBuiltChunkStorage() {
        return this.field_175008_n;
    }

    @Override
    public ObjectList getVisibleChunks() {
        return this.field_72755_R;
    }

    @Override
    public void setVisibleChunks(ObjectList l) {
        this.field_72755_R = l;
    }

    @Override
    public ChunkRenderDispatcher getChunkBuilder() {
        return this.field_174995_M;
    }

    @Override
    public void myRenderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider) {
        this.func_228418_a_(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
    }

    @Override
    public ShaderGroup portal_getTransparencyShader() {
        return this.field_239227_K_;
    }

    @Override
    public void portal_setTransparencyShader(ShaderGroup arg) {
        this.field_239227_K_ = arg;
    }

    private void portal_updateChunks() {
        ChunkRenderDispatcher chunkBuilder = this.field_174995_M;
        boolean uploaded = chunkBuilder.func_228908_d_();
        this.field_147595_R |= uploaded;
        int limit = 1;
        int num = 0;
        Iterator<ChunkRenderDispatcher.ChunkRender> iterator = this.field_175009_l.iterator();
        while (iterator.hasNext()) {
            ChunkRenderDispatcher.ChunkRender builtChunk = iterator.next();
            if (!builtChunk.func_217674_b()) continue;
            builtChunk.func_228929_a_(chunkBuilder);
            builtChunk.func_188282_m();
            iterator.remove();
            if (++num < limit) continue;
            break;
        }
    }
}

