/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin_client;

import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ducks.IEMinecraftClient;
import com.qouteall.immersive_portals.network.CommonNetwork;
import com.qouteall.immersive_portals.render.CrossPortalEntityRenderer;
import com.qouteall.immersive_portals.render.FPSMonitor;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient
implements IEMinecraftClient {
    @Final
    @Shadow
    @Mutable
    private Framebuffer field_147124_at;
    @Shadow
    public Screen field_71462_r;
    @Mutable
    @Shadow
    @Final
    public WorldRenderer field_71438_f;
    @Shadow
    private static int field_71470_ab;
    @Shadow
    @Nullable
    public ClientWorld field_71441_e;

    @Shadow
    public abstract IProfiler func_213239_aq();

    @Inject(method={"Lnet/minecraft/client/Minecraft;runTick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;tick(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.AFTER)})
    private void onAfterClientTick(CallbackInfo ci) {
        ModMain.postClientTickSignal.emit();
        CGlobal.clientTeleportationManager.manageTeleportation(0.0f);
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;runGameLoop(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Snooper;addMemoryStatsToSnooper()V")})
    private void onSnooperUpdate(boolean tick, CallbackInfo ci) {
        FPSMonitor.updateEverySecond(field_71470_ab);
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;updateWorldRenderer(Lnet/minecraft/client/world/ClientWorld;)V"}, at={@At(value="HEAD")})
    private void onSetWorld(ClientWorld clientWorld_1, CallbackInfo ci) {
        CGlobal.clientWorldLoader.cleanUp();
        CGlobal.clientTeleportationManager.disableTeleportFor(40);
        CrossPortalEntityRenderer.cleanUp();
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;func_238218_y_()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onIsFabulousGraphicsOrBetter(CallbackInfoReturnable<Boolean> cir) {
        if (PortalRendering.isRendering()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/client/Minecraft;wrapTask(Ljava/lang/Runnable;)Ljava/lang/Runnable;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateTask(Runnable runnable, CallbackInfoReturnable<Runnable> cir) {
        Minecraft this_ = (Minecraft)this;
        if (this_.func_213162_bc() && CommonNetwork.getIsProcessingRedirectedMessage()) {
            ClientWorld currWorld = this_.field_71441_e;
            Runnable newRunnable = () -> CommonNetwork.withSwitchedWorld(currWorld, runnable);
            cir.setReturnValue((Object)newRunnable);
        }
    }

    @Override
    public void setFrameBuffer(Framebuffer buffer) {
        this.field_147124_at = buffer;
    }

    @Override
    public Screen getCurrentScreen() {
        return this.field_71462_r;
    }

    @Override
    public void setWorldRenderer(WorldRenderer r) {
        this.field_71438_f = r;
    }
}

