/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin_client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.CGlobal;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ModMainClient;
import com.qouteall.immersive_portals.ducks.IEGameRenderer;
import com.qouteall.immersive_portals.render.CrossPortalThirdPersonView;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.context_management.PortalRendering;
import com.qouteall.immersive_portals.render.context_management.RenderStates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.math.vector.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer
implements IEGameRenderer {
    @Shadow
    @Final
    @Mutable
    private LightTexture field_78513_d;
    @Shadow
    private boolean field_175074_C;
    @Shadow
    @Final
    @Mutable
    private ActiveRenderInfo field_215317_L;
    @Shadow
    @Final
    private Minecraft field_78531_r;
    @Shadow
    private int field_78529_t;
    @Shadow
    private boolean field_175078_W;

    @Shadow
    public abstract void func_228379_a_(Matrix4f var1);

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;updateCameraAndRender(FJZ)V"}, at={@At(value="HEAD")})
    private void onFarBeforeRendering(float tickDelta, long nanoTime, boolean renderWorldIn, CallbackInfo ci) {
        if (this.field_78531_r.field_71441_e == null) {
            return;
        }
        RenderStates.updatePreRenderInfo(tickDelta);
        CGlobal.clientTeleportationManager.manageTeleportation(RenderStates.tickDelta);
        ModMain.preRenderSignal.emit();
        if (CGlobal.earlyClientLightUpdate) {
            MyRenderHelper.earlyUpdateLight();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;updateCameraAndRender(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderWorld(FJLcom/mojang/blaze3d/matrix/MatrixStack;)V")})
    private void onBeforeRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        ModMainClient.switchToCorrectRenderer();
        CGlobal.renderer.prepareRendering();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;updateCameraAndRender(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderWorld(FJLcom/mojang/blaze3d/matrix/MatrixStack;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingCenter(float float_1, long long_1, boolean boolean_1, CallbackInfo ci) {
        CGlobal.renderer.finishRendering();
        RenderStates.onTotalRenderEnd();
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;updateCameraAndRender(FJZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderWorld(FJLcom/mojang/blaze3d/matrix/MatrixStack;)V"))
    private void redirectRenderingWorld(GameRenderer gameRenderer, float tickDelta, long limitTime, MatrixStack matrix) {
        if (CrossPortalThirdPersonView.renderCrossPortalThirdPersonView()) {
            return;
        }
        gameRenderer.func_228378_a_(tickDelta, limitTime, matrix);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;renderWorld(FJLcom/mojang/blaze3d/matrix/MatrixStack;)V"}, at={@At(value="TAIL")})
    private void onRenderCenterEnded(float float_1, long long_1, MatrixStack matrixStack_1, CallbackInfo ci) {
        CGlobal.renderer.onRenderCenterEnded(matrixStack_1);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/GameRenderer;updateShaderGroupSize(II)V"}, at={@At(value="RETURN")})
    private void onOnResized(int int_1, int int_2, CallbackInfo ci) {
        if (CGlobal.clientWorldLoader != null) {
            CGlobal.clientWorldLoader.worldRendererMap.values().stream().filter(worldRenderer -> worldRenderer != this.field_78531_r.field_71438_f).forEach(worldRenderer -> worldRenderer.func_72720_a(int_1, int_2));
        }
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;applyBobbing(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/matrix/MatrixStack;translate(DDD)V"))
    private void redirectBobViewTranslate(MatrixStack matrixStack, double x, double y, double z) {
        double viewBobFactor = RenderStates.viewBobFactor;
        matrixStack.func_227861_a_(x * viewBobFactor, y * viewBobFactor, z * viewBobFactor);
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/GameRenderer;renderWorld(FJLcom/mojang/blaze3d/matrix/MatrixStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lnet/minecraft/util/math/vector/Matrix4f;)V"))
    private void redirectLoadProjectionMatrix(GameRenderer gameRenderer, Matrix4f matrix4f) {
        if (PortalRendering.isRendering()) {
            this.func_228379_a_(RenderStates.projectionMatrix);
        } else {
            this.func_228379_a_(matrix4f);
            if (RenderStates.projectionMatrix == null) {
                RenderStates.projectionMatrix = matrix4f;
            }
        }
    }

    @Override
    public void setLightmapTextureManager(LightTexture manager) {
        this.field_78513_d = manager;
    }

    @Override
    public boolean getDoRenderHand() {
        return this.field_175074_C;
    }

    @Override
    public void setDoRenderHand(boolean e) {
        this.field_175074_C = e;
    }

    @Override
    public void setCamera(ActiveRenderInfo camera_) {
        this.field_215317_L = camera_;
    }

    @Override
    public void setIsRenderingPanorama(boolean cond) {
        this.field_175078_W = cond;
    }
}

