/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin.position_sync;

import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ModMain;
import com.qouteall.immersive_portals.ducks.IEEntity;
import com.qouteall.immersive_portals.ducks.IEPlayerMoveC2SPacket;
import com.qouteall.immersive_portals.ducks.IEPlayerPositionLookS2CPacket;
import com.qouteall.immersive_portals.ducks.IEServerPlayNetworkHandler;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayNetHandler.class}, priority=900)
public abstract class MixinServerPlayNetworkHandler
implements IEServerPlayNetworkHandler {
    @Shadow
    public ServerPlayerEntity field_147369_b;
    @Shadow
    private Vector3d field_184362_y;
    @Shadow
    private int field_184363_z;
    @Shadow
    private int field_184343_A;
    @Shadow
    private int field_147368_e;
    @Shadow
    private boolean field_184345_D;
    @Shadow
    private double field_184359_v;
    @Shadow
    private double field_184360_w;
    @Shadow
    private double field_184361_x;

    @Shadow
    protected abstract boolean func_217264_d();

    @Shadow
    protected abstract boolean func_241163_a_(IWorldReader var1, AxisAlignedBB var2);

    @Inject(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processPlayer(Lnet/minecraft/network/play/client/CPlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/IPacket;Lnet/minecraft/network/INetHandler;Lnet/minecraft/world/server/ServerWorld;)V")}, cancellable=true)
    private void onProcessMovePacket(CPlayerPacket packet, CallbackInfo ci) {
        RegistryKey<World> packetDimension = ((IEPlayerMoveC2SPacket)packet).getPlayerDimension();
        if (packetDimension == null) {
            Helper.err("Player move packet is missing dimension info. Maybe the player client doesn't have IP");
            ModMain.serverTaskList.addTask(() -> {
                this.field_147369_b.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (Global.serverTeleportationManager.isJustTeleported((Entity)this.field_147369_b, 100L)) {
            this.cancelTeleportRequest();
        }
        if (this.field_147369_b.field_70170_p.func_234923_W_() != packetDimension) {
            ModMain.serverTaskList.addTask(() -> {
                Global.serverTeleportationManager.acceptDubiousMovePacket(this.field_147369_b, packet, packetDimension);
                return true;
            });
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processPlayer(Lnet/minecraft/network/play/client/CPlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;func_217264_d()Z"))
    private boolean redirectIsServerOwnerOnPlayerMove(ServerPlayNetHandler serverPlayNetworkHandler) {
        if (MixinServerPlayNetworkHandler.shouldAcceptDubiousMovement(this.field_147369_b)) {
            return true;
        }
        return this.func_217264_d();
    }

    @Redirect(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processPlayer(Lnet/minecraft/network/play/client/CPlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;isInvulnerableDimensionChange()Z"), require=0)
    private boolean redirectIsInTeleportationState(ServerPlayerEntity player) {
        if (MixinServerPlayNetworkHandler.shouldAcceptDubiousMovement(player)) {
            return true;
        }
        return player.func_184850_K();
    }

    @Overwrite
    public void func_175089_a(double destX, double destY, double destZ, float destYaw, float destPitch, Set<SPlayerPositionLookPacket.Flags> updates) {
        if (this.field_147369_b.field_70128_L) {
            ModMain.serverTaskList.addTask(() -> {
                this.doSendTeleportRequest(destX, destY, destZ, destYaw, destPitch, updates);
                return true;
            });
        } else {
            this.doSendTeleportRequest(destX, destY, destZ, destYaw, destPitch, updates);
        }
    }

    private void doSendTeleportRequest(double destX, double destY, double destZ, float destYaw, float destPitch, Set<SPlayerPositionLookPacket.Flags> updates) {
        float currPitch;
        if (Global.teleportationDebugEnabled) {
            new Throwable().printStackTrace();
            Helper.log(String.format("request teleport %s %s (%d %d %d)->(%d %d %d)", this.field_147369_b.func_200200_C_().func_150261_e(), this.field_147369_b.field_70170_p.func_234923_W_(), (int)this.field_147369_b.func_226277_ct_(), (int)this.field_147369_b.func_226278_cu_(), (int)this.field_147369_b.func_226281_cx_(), (int)destX, (int)destY, (int)destZ));
        }
        double currX = updates.contains(SPlayerPositionLookPacket.Flags.X) ? this.field_147369_b.func_226277_ct_() : 0.0;
        double currY = updates.contains(SPlayerPositionLookPacket.Flags.Y) ? this.field_147369_b.func_226278_cu_() : 0.0;
        double currZ = updates.contains(SPlayerPositionLookPacket.Flags.Z) ? this.field_147369_b.func_226281_cx_() : 0.0;
        float currYaw = updates.contains(SPlayerPositionLookPacket.Flags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float f = currPitch = updates.contains(SPlayerPositionLookPacket.Flags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        if (!Global.serverTeleportationManager.isJustTeleported((Entity)this.field_147369_b, 100L)) {
            this.field_184362_y = new Vector3d(destX, destY, destZ);
        }
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(destX, destY, destZ, destYaw, destPitch);
        SPlayerPositionLookPacket lookPacket = new SPlayerPositionLookPacket(destX - currX, destY - currY, destZ - currZ, destYaw - currYaw, destPitch - currPitch, updates, this.field_184363_z);
        ((IEPlayerPositionLookS2CPacket)lookPacket).setPlayerDimension((RegistryKey<World>)this.field_147369_b.field_70170_p.func_234923_W_());
        this.field_147369_b.field_71135_a.func_147359_a((IPacket)lookPacket);
    }

    @Redirect(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processPlayer(Lnet/minecraft/network/play/client/CPlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;func_241163_a_(Lnet/minecraft/world/IWorldReader;Lnet/minecraft/util/math/AxisAlignedBB;)Z"))
    private boolean onCheckPlayerCollision(ServerPlayNetHandler serverPlayNetworkHandler, IWorldReader worldView, AxisAlignedBB box) {
        if (Global.serverTeleportationManager.isJustTeleported((Entity)this.field_147369_b, 100L)) {
            return false;
        }
        if (((IEEntity)this.field_147369_b).getCollidingPortal() != null) {
            return false;
        }
        boolean portalsNearby = McHelper.getServerPortalsNearby((Entity)this.field_147369_b, 16.0).findAny().isPresent();
        if (portalsNearby) {
            return false;
        }
        return this.func_241163_a_(worldView, box);
    }

    @Inject(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processConfirmTeleport(Lnet/minecraft/network/play/client/CConfirmTeleportPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnTeleportConfirm(CConfirmTeleportPacket packet, CallbackInfo ci) {
        if (this.field_184362_y == null) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/network/play/ServerPlayNetHandler;processVehicleMove(Lnet/minecraft/network/play/client/CMoveVehiclePacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;isMoveVehiclePacketInvalid(Lnet/minecraft/network/play/client/CMoveVehiclePacket;)Z")}, cancellable=true)
    private void onOnVehicleMove(CMoveVehiclePacket packet, CallbackInfo ci) {
        if (Global.serverTeleportationManager.isJustTeleported((Entity)this.field_147369_b, 40L)) {
            Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b) {
                double currX = entity.func_226277_ct_();
                double currY = entity.func_226278_cu_();
                double currZ = entity.func_226281_cx_();
                double newX = packet.func_187004_a();
                double newY = packet.func_187002_b();
                double newZ = packet.func_187003_c();
                if (entity.func_213303_ch().func_186679_c(newX, newY, newZ) < 256.0) {
                    float yaw = packet.func_187006_d();
                    float pitch = packet.func_187005_e();
                    entity.func_70080_a(newX, newY, newZ, yaw, pitch);
                    this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                    this.field_184345_D = true;
                    this.field_184359_v = entity.func_226277_ct_();
                    this.field_184360_w = entity.func_226278_cu_();
                    this.field_184361_x = entity.func_226281_cx_();
                }
            }
            ci.cancel();
        }
    }

    private static boolean shouldAcceptDubiousMovement(ServerPlayerEntity player) {
        if (Global.serverTeleportationManager.isJustTeleported((Entity)player, 100L)) {
            return true;
        }
        if (Global.looseMovementCheck) {
            return true;
        }
        if (((IEEntity)player).getCollidingPortal() != null) {
            return true;
        }
        boolean portalsNearby = McHelper.getServerPortalsNearby((Entity)player, 16.0).findFirst().isPresent();
        return portalsNearby;
    }

    @Override
    public void cancelTeleportRequest() {
        this.field_184362_y = null;
    }
}

