/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin.entity_sync;

import com.google.common.collect.Lists;
import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.chunk_loading.EntitySync;
import com.qouteall.immersive_portals.ducks.IEEntityTracker;
import com.qouteall.immersive_portals.ducks.IEThreadedAnvilChunkStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkManager.class})
public abstract class MixinThreadedAnvilChunkStorage_E
implements IEThreadedAnvilChunkStorage {
    @Shadow
    @Final
    public Int2ObjectMap<ChunkManager.EntityTracker> field_219272_z;
    @Shadow
    @Final
    private ServerWorld field_219255_i;

    @Shadow
    abstract void func_219234_a(ServerPlayerEntity var1, boolean var2);

    @Inject(method={"Lnet/minecraft/world/server/ChunkManager;untrack(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUnloadEntity(Entity entity, CallbackInfo ci) {
        ServerPlayerEntity player;
        if (entity instanceof ServerPlayerEntity && Global.serverTeleportationManager.isTeleporting(player = (ServerPlayerEntity)entity)) {
            Object tracker = this.field_219272_z.remove(entity.func_145782_y());
            ((IEEntityTracker)tracker).stopTrackingToAllPlayers_();
            this.func_219234_a(player, false);
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/world/server/ChunkManager;tickEntityTracker()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickPlayerMovement(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void onPlayerRespawn(ServerPlayerEntity oldPlayer) {
        this.field_219272_z.values().forEach(obj -> ((IEEntityTracker)obj).onPlayerRespawn(oldPlayer));
    }

    @Override
    public void updateEntityTrackersAfterSendingChunkPacket(Chunk chunk, ServerPlayerEntity player) {
        ArrayList attachedEntityList = Lists.newArrayList();
        ArrayList passengerList = Lists.newArrayList();
        for (Object entityTracker : this.field_219272_z.values()) {
            Entity entity = ((IEEntityTracker)entityTracker).getEntity_();
            if (entity == player || entity.field_70176_ah != chunk.func_76632_l().field_77276_a || entity.field_70164_aj != chunk.func_76632_l().field_77275_b) continue;
            ((IEEntityTracker)entityTracker).updateEntityTrackingStatus(player);
            if (entity instanceof MobEntity && ((MobEntity)entity).func_110166_bE() != null) {
                attachedEntityList.add(entity);
            }
            if (entity.func_184188_bt().isEmpty()) continue;
            passengerList.add(entity);
        }
        EntitySync.withForceRedirect((RegistryKey<World>)this.field_219255_i.func_234923_W_(), () -> {
            for (Entity entity : attachedEntityList) {
                player.field_71135_a.func_147359_a((IPacket)new SMountEntityPacket(entity, ((MobEntity)entity).func_110166_bE()));
            }
            for (Entity entity : passengerList) {
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(entity));
            }
        });
    }

    @Override
    public void resendSpawnPacketToTrackers(Entity entity) {
        Object tracker = this.field_219272_z.get(entity.func_145782_y());
        ((IEEntityTracker)tracker).resendSpawnPacketToTrackers();
    }

    @Override
    public Int2ObjectMap<ChunkManager.EntityTracker> getEntityTrackerMap() {
        return this.field_219272_z;
    }
}

