/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin.entity_sync;

import com.google.common.collect.HashMultimap;
import com.mojang.authlib.GameProfile;
import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.ducks.IEServerPlayerEntity;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerEntity.class})
public abstract class MixinServerPlayerEntity
extends PlayerEntity
implements IEServerPlayerEntity {
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    @Shadow
    private Vector3d field_193110_cw;
    private HashMultimap<RegistryKey<World>, Entity> myRemovedEntities;
    @Shadow
    private boolean field_184851_cj;

    public MixinServerPlayerEntity(World world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"Lnet/minecraft/entity/player/ServerPlayerEntity;sendChunkUnload(Lnet/minecraft/util/math/ChunkPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSendUnloadChunkPacket(ChunkPos chunkPos_1, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"Lnet/minecraft/entity/player/ServerPlayerEntity;tick()V"}, at={@At(value="TAIL")})
    private void onTicking(CallbackInfo ci) {
        if (this.myRemovedEntities != null) {
            this.myRemovedEntities.keySet().forEach(dimension -> {
                Set list = this.myRemovedEntities.get(dimension);
                this.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)dimension, (IPacket)new SDestroyEntitiesPacket(list.stream().mapToInt(Entity::func_145782_y).toArray())));
            });
            this.myRemovedEntities = null;
        }
    }

    @Inject(method={"Lnet/minecraft/entity/player/ServerPlayerEntity;copyFrom(Lnet/minecraft/entity/player/ServerPlayerEntity;Z)V"}, at={@At(value="RETURN")})
    private void onCopyFrom(ServerPlayerEntity oldPlayer, boolean alive, CallbackInfo ci) {
        HashMultimap<RegistryKey<World>, Entity> oldPlayerRemovedEntities = ((MixinServerPlayerEntity)oldPlayer).myRemovedEntities;
        if (oldPlayerRemovedEntities != null) {
            this.myRemovedEntities = HashMultimap.create();
            this.myRemovedEntities.putAll(oldPlayerRemovedEntities);
        }
    }

    @Overwrite
    public void func_152339_d(Entity entity_1) {
        if (entity_1 instanceof PlayerEntity) {
            this.field_71135_a.func_147359_a(MyNetwork.createRedirectedMessage((RegistryKey<World>)entity_1.field_70170_p.func_234923_W_(), (IPacket)new SDestroyEntitiesPacket(new int[]{entity_1.func_145782_y()})));
        } else {
            if (this.myRemovedEntities == null) {
                this.myRemovedEntities = HashMultimap.create();
            }
            this.myRemovedEntities.put((Object)entity_1.field_70170_p.func_234923_W_(), (Object)entity_1);
        }
    }

    @Overwrite
    public void func_184848_d(Entity entity_1) {
        if (this.myRemovedEntities != null) {
            this.myRemovedEntities.remove((Object)entity_1.field_70170_p.func_234923_W_(), (Object)entity_1);
        }
    }

    @Override
    public void setEnteredNetherPos(Vector3d pos) {
        this.field_193110_cw = pos;
    }

    @Override
    public void updateDimensionTravelAdvancements(ServerWorld fromWorld) {
    }

    @Override
    public void setIsInTeleportationState(boolean arg) {
        this.field_184851_cj = arg;
    }

    @Override
    public void stopRidingWithoutTeleportRequest() {
        super.func_184210_p();
    }

    @Override
    public void startRidingWithoutTeleportRequest(Entity newVehicle) {
        super.func_184205_a(newVehicle, true);
    }
}

