/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin.entity_sync;

import com.qouteall.hiding_in_the_bushes.MyNetwork;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.chunk_loading.EntitySync;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.ducks.IEEntityTracker;
import com.qouteall.immersive_portals.ducks.IEThreadedAnvilChunkStorage;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.TrackedEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"net.minecraft.world.server.ChunkManager$EntityTracker"})
public abstract class MixinEntityTracker
implements IEEntityTracker {
    @Shadow
    @Final
    private TrackedEntity field_219402_b;
    @Shadow
    @Final
    private Entity field_219403_c;
    @Shadow
    @Final
    private int field_219404_d;
    @Shadow
    private SectionPos field_219405_e;
    @Shadow
    @Final
    private Set<ServerPlayerEntity> field_219406_f;

    @Shadow
    public abstract void func_219396_a();

    @Shadow
    protected abstract int func_229843_b_();

    @Redirect(method={"Lnet/minecraft/world/server/ChunkManager$EntityTracker;sendToAllTracking(Lnet/minecraft/network/IPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;sendPacket(Lnet/minecraft/network/IPacket;)V"))
    private void onSendToOtherNearbyPlayers(ServerPlayNetHandler serverPlayNetworkHandler, IPacket<?> packet_1) {
        EntitySync.sendRedirectedPacket(serverPlayNetworkHandler, packet_1, (RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_());
    }

    @Redirect(method={"Lnet/minecraft/world/server/ChunkManager$EntityTracker;sendToTrackingAndSelf(Lnet/minecraft/network/IPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;sendPacket(Lnet/minecraft/network/IPacket;)V"))
    private void onSendToNearbyPlayers(ServerPlayNetHandler serverPlayNetworkHandler, IPacket<?> packet_1) {
        EntitySync.sendRedirectedPacket(serverPlayNetworkHandler, packet_1, (RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_());
    }

    @Overwrite
    public void func_219400_b(ServerPlayerEntity player) {
        this.updateEntityTrackingStatus(player);
    }

    @Overwrite
    public void func_219397_a(List<ServerPlayerEntity> list) {
        for (ServerPlayerEntity player : McHelper.getRawPlayerList()) {
            this.updateEntityTrackingStatus(player);
        }
    }

    @Override
    public Entity getEntity_() {
        return this.field_219403_c;
    }

    @Override
    public void updateEntityTrackingStatus(ServerPlayerEntity player) {
        boolean isWatchedNow;
        IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)((ServerWorld)this.field_219403_c.field_70170_p).func_72863_F().field_217237_a;
        if (player == this.field_219403_c) {
            return;
        }
        int maxWatchDistance = Math.min(this.func_229843_b_(), (storage.getWatchDistance() - 1) * 16);
        boolean bl = isWatchedNow = NewChunkTrackingGraph.isPlayerWatchingChunkWithinRaidus(player, (RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_(), this.field_219403_c.field_70176_ah, this.field_219403_c.field_70164_aj, maxWatchDistance) && this.field_219403_c.func_174827_a(player);
        if (isWatchedNow) {
            ChunkPos chunkPos_1;
            ChunkHolder chunkHolder_1;
            boolean shouldTrack = this.field_219403_c.field_98038_p;
            if (!shouldTrack && (chunkHolder_1 = storage.getChunkHolder_((chunkPos_1 = new ChunkPos(this.field_219403_c.field_70176_ah, this.field_219403_c.field_70164_aj)).func_201841_a())) != null && chunkHolder_1.func_219298_c() != null) {
                shouldTrack = true;
            }
            if (shouldTrack && this.field_219406_f.add(player)) {
                EntitySync.withForceRedirect((RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_(), () -> this.field_219402_b.func_219455_b(player));
            }
        } else if (this.field_219406_f.remove(player)) {
            EntitySync.withForceRedirect((RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_(), () -> this.field_219402_b.func_219454_a(player));
        }
    }

    @Override
    public void onPlayerRespawn(ServerPlayerEntity oldPlayer) {
        this.field_219406_f.remove(oldPlayer);
        this.field_219402_b.func_219454_a(oldPlayer);
    }

    @Override
    public void resendSpawnPacketToTrackers() {
        IPacket spawnPacket = this.field_219403_c.func_213297_N();
        IPacket redirected = MyNetwork.createRedirectedMessage((RegistryKey<World>)this.field_219403_c.field_70170_p.func_234923_W_(), spawnPacket);
        this.field_219406_f.forEach(player -> player.field_71135_a.func_147359_a(redirected));
    }

    @Override
    public void stopTrackingToAllPlayers_() {
        this.func_219396_a();
    }

    @Override
    public void tickEntry() {
        this.field_219402_b.func_219453_a();
    }

    @Override
    public SectionPos getLastCameraPosition() {
        return this.field_219405_e;
    }

    @Override
    public void setLastCameraPosition(SectionPos arg) {
        this.field_219405_e = arg;
    }
}

