/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.mixin.collision;

import com.qouteall.immersive_portals.Global;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.ducks.IEEntity;
import com.qouteall.immersive_portals.portal.EndPortalEntity;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.teleportation.CollisionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEEntity {
    private Entity collidingPortal;
    private long collidingPortalActiveTickTime;
    @Shadow
    public World field_70170_p;
    @Shadow
    public boolean field_70156_m;

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_174826_a(AxisAlignedBB var1);

    @Shadow
    protected abstract Vector3d func_213306_e(Vector3d var1);

    @Shadow
    public abstract ITextComponent func_200200_C_();

    @Shadow
    public abstract double func_226277_ct_();

    @Shadow
    public abstract double func_226278_cu_();

    @Shadow
    public abstract double func_226281_cx_();

    @Shadow
    protected abstract BlockPos func_226268_ag_();

    @Inject(method={"Lnet/minecraft/entity/Entity;tick()V"}, at={@At(value="HEAD")})
    private void onTicking(CallbackInfo ci) {
        this.tickCollidingPortal(1.0f);
    }

    @Redirect(method={"Lnet/minecraft/entity/Entity;move(Lnet/minecraft/entity/MoverType;Lnet/minecraft/util/math/vector/Vector3d;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getAllowedMovement(Lnet/minecraft/util/math/vector/Vector3d;)Lnet/minecraft/util/math/vector/Vector3d;"))
    private Vector3d redirectHandleCollisions(Entity entity, Vector3d attemptedMove) {
        if (attemptedMove.func_189985_c() > 256.0 || this.collidingPortal == null || entity.func_184207_aI() || entity.func_184218_aH()) {
            return this.func_213306_e(attemptedMove);
        }
        Vector3d result = CollisionHelper.handleCollisionHalfwayInPortal((Entity)this, attemptedMove, this.getCollidingPortal(), attemptedMove1 -> this.func_213306_e((Vector3d)attemptedMove1));
        return result;
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;func_230279_az_()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.getCollidingPortal() instanceof EndPortalEntity) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/entity/Entity;doBlockCollisions()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getBoundingBox()Lnet/minecraft/util/math/AxisAlignedBB;"))
    private AxisAlignedBB redirectBoundingBoxInCheckingBlockCollision(Entity entity) {
        return CollisionHelper.getActiveCollisionBox(entity);
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;isEntityInsideOpaqueBlock()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInsideWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.getCollidingPortal() != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;setRawPosition(DDD)V"}, at={@At(value="HEAD")})
    private void onSetPos(double nx, double ny, double nz, CallbackInfo ci) {
        if (this instanceof ServerPlayerEntity && Global.teleportationDebugEnabled && (Math.abs(this.func_226277_ct_() - nx) > 10.0 || Math.abs(this.func_226278_cu_() - ny) > 10.0 || Math.abs(this.func_226281_cx_() - nz) > 10.0)) {
            Helper.log(String.format("%s %s teleported from %s %s %s to %s %s %s", this.func_200200_C_().func_150261_e(), this.field_70170_p.func_234923_W_(), (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), (int)nx, (int)ny, (int)nz));
            new Throwable().printStackTrace();
        }
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;setPose(Lnet/minecraft/entity/Pose;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetPose(Pose pose, CallbackInfo ci) {
        Entity this_ = (Entity)this;
        if (this_ instanceof ServerPlayerEntity && this_.func_213283_Z() == Pose.STANDING && (pose == Pose.CROUCHING || pose == Pose.SWIMMING) && (this.getCollidingPortal() != null || Global.serverTeleportationManager.isJustTeleported(this_, 20L))) {
            ci.cancel();
        }
    }

    @Override
    public Portal getCollidingPortal() {
        return (Portal)this.collidingPortal;
    }

    @Override
    public void tickCollidingPortal(float tickDelta) {
        Entity this_ = (Entity)this;
        if (this.collidingPortal != null) {
            if (this.collidingPortal.field_70170_p != this.field_70170_p) {
                this.collidingPortal = null;
            } else if (!this.func_174813_aQ().func_186662_g(0.5).func_72326_a(this.collidingPortal.func_174813_aQ())) {
                this.collidingPortal = null;
            }
            if (Math.abs(this.field_70170_p.func_82737_E() - this.collidingPortalActiveTickTime) >= 3L) {
                this.collidingPortal = null;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            McHelper.onClientEntityTick(this_);
        }
    }

    @Override
    public void notifyCollidingWithPortal(Entity portal) {
        this.collidingPortal = portal;
        this.collidingPortalActiveTickTime = this.field_70170_p.func_82737_E();
    }
}

