/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.dimension_sync;

import com.google.common.collect.Streams;
import com.qouteall.immersive_portals.Helper;
import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DimensionTypeSync {
    @OnlyIn(value=Dist.CLIENT)
    public static Map<RegistryKey<World>, RegistryKey<DimensionType>> clientTypeMap;
    @OnlyIn(value=Dist.CLIENT)
    private static DynamicRegistries currentDimensionTypeTracker;

    @OnlyIn(value=Dist.CLIENT)
    public static void onGameJoinPacketReceived(DynamicRegistries tracker) {
        currentDimensionTypeTracker = tracker;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Map<RegistryKey<World>, RegistryKey<DimensionType>> typeMapFromTag(CompoundNBT tag) {
        HashMap<RegistryKey<World>, RegistryKey<DimensionType>> result = new HashMap<RegistryKey<World>, RegistryKey<DimensionType>>();
        tag.func_150296_c().forEach(key -> {
            RegistryKey<World> worldKey = DimId.idToKey(key);
            String val = tag.func_74779_i(key);
            RegistryKey typeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)new ResourceLocation(val));
            result.put(worldKey, typeKey);
        });
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void acceptTypeMapData(CompoundNBT tag) {
        clientTypeMap = DimensionTypeSync.typeMapFromTag(tag);
        Helper.log("Received Dimension Type Sync");
        Helper.log("\n" + Helper.myToString(clientTypeMap.entrySet().stream().map(e -> ((RegistryKey)e.getKey()).func_240901_a_().toString() + " -> " + ((RegistryKey)e.getValue()).func_240901_a_())));
    }

    public static CompoundNBT createTagFromServerWorldInfo() {
        DynamicRegistries registryManager = McHelper.getServer().func_244267_aX();
        Registry dimensionTypes = registryManager.func_230520_a_();
        return DimensionTypeSync.typeMapToTag(Streams.stream((Iterable)McHelper.getServer().func_212370_w()).collect(Collectors.toMap(World::func_234923_W_, w -> {
            DimensionType dimensionType = w.func_230315_m_();
            ResourceLocation id = dimensionTypes.func_177774_c((Object)dimensionType);
            if (id == null) {
                Helper.err("Missing dim type id for " + w.func_234923_W_());
                return DimensionType.field_235999_c_;
            }
            return DimensionTypeSync.idToDimType(id);
        })));
    }

    public static RegistryKey<DimensionType> idToDimType(ResourceLocation id) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)id);
    }

    private static CompoundNBT typeMapToTag(Map<RegistryKey<World>, RegistryKey<DimensionType>> data) {
        CompoundNBT tag = new CompoundNBT();
        data.forEach((worldKey, typeKey) -> tag.func_218657_a(worldKey.func_240901_a_().toString(), (INBT)StringNBT.func_229705_a_((String)typeKey.func_240901_a_().toString())));
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RegistryKey<DimensionType> getDimensionTypeKey(RegistryKey<World> worldKey) {
        if (worldKey == World.field_234918_g_) {
            return DimensionType.field_235999_c_;
        }
        if (worldKey == World.field_234919_h_) {
            return DimensionType.field_236000_d_;
        }
        if (worldKey == World.field_234920_i_) {
            return DimensionType.field_236001_e_;
        }
        RegistryKey<DimensionType> obj = clientTypeMap.get(worldKey);
        if (obj == null) {
            Helper.err("Missing Dimension Type For " + worldKey);
            return DimensionType.field_235999_c_;
        }
        return obj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static DimensionType getDimensionType(RegistryKey<DimensionType> registryKey) {
        return (DimensionType)currentDimensionTypeTracker.func_230520_a_().func_230516_a_(registryKey);
    }
}

