/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.immersive_portals.dimension_sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.qouteall.immersive_portals.dimension_sync.DimId;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public class DimensionIdRecord {
    public static DimensionIdRecord clientRecord;
    public static DimensionIdRecord serverRecord;
    final BiMap<RegistryKey<World>, Integer> idMap;
    final BiMap<Integer, RegistryKey<World>> inverseMap;

    public DimensionIdRecord(BiMap<RegistryKey<World>, Integer> data) {
        this.idMap = data;
        this.inverseMap = data.inverse();
    }

    public RegistryKey<World> getDim(int integerId) {
        RegistryKey result = (RegistryKey)this.inverseMap.get((Object)integerId);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + integerId);
        }
        return result;
    }

    public int getIntId(RegistryKey<World> dim) {
        Integer result = (Integer)this.idMap.get(dim);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + dim);
        }
        return result;
    }

    public String toString() {
        return this.idMap.entrySet().stream().map(e -> ((RegistryKey)e.getKey()).func_240901_a_().toString() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
    }

    public static DimensionIdRecord tagToRecord(CompoundNBT tag) {
        CompoundNBT intids = tag.func_74775_l("intids");
        if (intids == null) {
            return null;
        }
        HashBiMap bimap = HashBiMap.create();
        intids.func_150296_c().forEach(dim -> {
            if (intids.func_74764_b(dim)) {
                int intid = intids.func_74762_e(dim);
                bimap.put(DimId.idToKey(dim), (Object)intid);
            }
        });
        return new DimensionIdRecord((BiMap<RegistryKey<World>, Integer>)bimap);
    }

    public static CompoundNBT recordToTag(DimensionIdRecord record) {
        CompoundNBT intids = new CompoundNBT();
        record.idMap.forEach((key, intid) -> intids.func_218657_a(key.func_240901_a_().toString(), (INBT)IntNBT.func_229692_a_((int)intid)));
        CompoundNBT result = new CompoundNBT();
        result.func_218657_a("intids", (INBT)intids);
        return result;
    }
}

